/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.moveworkforward.confluence.microsoftteams.notifier.services.AtlassianPluginService;
import com.moveworkforward.rest.AbstractCrossSellController;
import com.moveworkforward.service.impl.AbstractAtlassianPluginService;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/cross-sell")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class CrossSellController
extends AbstractCrossSellController {
    private static final Logger log = LoggerFactory.getLogger(CrossSellController.class);
    private final I18nResolver i18nResolver;

    @Autowired
    public CrossSellController(AtlassianPluginService atlassianPluginService, @ComponentImport I18nResolver i18nResolver) {
        super((AbstractAtlassianPluginService)atlassianPluginService);
        this.i18nResolver = i18nResolver;
    }

    protected String getCrossSellValue() {
        return this.i18nResolver.getText("cross-sell-plugins");
    }

    protected String getUserKey() {
        return Optional.ofNullable(AuthenticatedUserThreadLocal.get()).map(confluenceUser -> confluenceUser.getKey().getStringValue()).orElse(null);
    }
}

