/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.model;

import com.atlassian.confluence.plugins.tasklist.TaskStatus;
import com.moveworkforward.ao.entity.EntityType;
import com.moveworkforward.confluence.microsoftteams.notifier.model.AbstractConfluenceScheduledReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.SourceEntity;
import com.moveworkforward.model.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true, value={"tag", "url", "urlId"})
@EntityType(value="task-reminder-report")
public class TaskReminderReportConfiguration
extends AbstractConfluenceScheduledReportConfiguration<SourceEntity> {
    public static final String TYPE = "task-reminder-report";
    private int days;
    private List<Expiration> expirations = new ArrayList<Expiration>();
    private int taskCount;
    private List<User> creatorsUsers = new ArrayList<User>();
    private List<User> assigneesUsers = new ArrayList<User>();
    private List<User> completeUsers = new ArrayList<User>();
    private TaskStatus taskStatus;

    public String getType() {
        return TYPE;
    }

    @JsonIgnore
    public String getReportTime() {
        if (this.getDelivery() != null) {
            this.getDelivery().setDeliverOnSchedule(true);
        }
        return super.getReportTime();
    }

    public List<String> getSourceKeys() {
        if (CollectionUtils.isEmpty((Collection)this.sources)) {
            return new ArrayList<String>();
        }
        return this.sources.stream().map(SourceEntity::getSpaceKey).collect(Collectors.toList());
    }

    public void setSourceKeys(List<String> sourceKeys) {
        this.sources = CollectionUtils.isEmpty((Collection)this.sources) ? new ArrayList() : sourceKeys.stream().map(SourceEntity::new).collect(Collectors.toList());
    }

    public int getDays() {
        return this.days;
    }

    public List<Expiration> getExpirations() {
        return this.expirations;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public List<User> getCreatorsUsers() {
        return this.creatorsUsers;
    }

    public List<User> getAssigneesUsers() {
        return this.assigneesUsers;
    }

    public List<User> getCompleteUsers() {
        return this.completeUsers;
    }

    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public void setDays(int days) {
        this.days = days;
    }

    public void setExpirations(List<Expiration> expirations) {
        this.expirations = expirations;
    }

    public void setTaskCount(int taskCount) {
        this.taskCount = taskCount;
    }

    public void setCreatorsUsers(List<User> creatorsUsers) {
        this.creatorsUsers = creatorsUsers;
    }

    public void setAssigneesUsers(List<User> assigneesUsers) {
        this.assigneesUsers = assigneesUsers;
    }

    public void setCompleteUsers(List<User> completeUsers) {
        this.completeUsers = completeUsers;
    }

    public void setTaskStatus(TaskStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String toString() {
        return "TaskReminderReportConfiguration(super=" + super.toString() + ", days=" + this.days + ", expirations=" + this.expirations + ", taskCount=" + this.taskCount + ", creatorsUsers=" + this.creatorsUsers + ", assigneesUsers=" + this.assigneesUsers + ", completeUsers=" + this.completeUsers + ", taskStatus=" + this.taskStatus + ")";
    }

    public static enum Expiration {
        EXPIRED,
        EXPIRING_WITHIN,
        EXPIRING_AFTER,
        WITHOUT_DUE_DATE;

    }
}

