/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.util;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.google.common.collect.ImmutableMap;
import com.moveworkforward.confluence.microsoftteams.notifier.actions.Source;
import com.moveworkforward.confluence.microsoftteams.notifier.model.CalendarEventInfo;
import com.moveworkforward.confluence.microsoftteams.notifier.model.QuestionAndAnswerEventInfo;
import com.moveworkforward.confluence.microsoftteams.notifier.model.QuestionType;
import com.moveworkforward.model.MessageAudit;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageAuditUtil {
    private static final Logger log = LoggerFactory.getLogger(MessageAuditUtil.class);
    private static final String PAGE_ID = "pageId";

    private MessageAuditUtil() {
    }

    public static MessageAudit createMessageAudit(AttachmentEvent event) {
        try {
            ContentEntityObject page = event.getAttachedTo();
            Space space = event.getAttachment().getSpace();
            return MessageAudit.builder().eventType(Source.getSource((ContentEvent)event).toString()).tag(space.getKey()).targetDetails((Map)ImmutableMap.of((Object)PAGE_ID, (Object)page.getIdAsString())).build();
        }
        catch (Exception e) {
            log.warn("Can't build audit message: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static MessageAudit createMessageAudit(CalendarEventInfo event) {
        try {
            String spaceKey = event.getSpaceKey();
            return MessageAudit.builder().eventType(event.getSource().toString()).tag(spaceKey).build();
        }
        catch (Exception e) {
            log.warn("Can't build audit message: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static MessageAudit createMessageAudit(QuestionAndAnswerEventInfo event) {
        try {
            String spaceKey = event.getSpace() != null ? event.getSpace().getKey() : "05f11044-da77-41a8-ac66-a9388ffd0925";
            Source source = event.getQuestionType() == QuestionType.ANSWER ? Source.ANSWER_CREATED : Source.QUESTION_CREATED;
            return MessageAudit.builder().eventType(source.toString()).tag(spaceKey).build();
        }
        catch (Exception e) {
            log.warn("Can't build audit message: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static MessageAudit createMessageAudit(CommentEvent event) {
        try {
            String spaceKey = event.getComment().getSpace().getKey();
            ContentEntityObject page = event.getComment().getContainer();
            return MessageAudit.builder().eventType(Source.getSource((ContentEvent)event).toString()).tag(spaceKey).targetDetails((Map)ImmutableMap.of((Object)PAGE_ID, (Object)page.getIdAsString())).build();
        }
        catch (Exception e) {
            log.warn("Can't build audit message: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static MessageAudit createMessageAudit(PageEvent event) {
        try {
            Page page = event.getPage();
            String spaceKey = page.getSpaceKey();
            return MessageAudit.builder().eventType(Source.getSource((ContentEvent)event).toString()).tag(spaceKey).targetDetails((Map)ImmutableMap.of((Object)PAGE_ID, (Object)page.getIdAsString())).build();
        }
        catch (Exception e) {
            log.warn("Can't build audit message: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static MessageAudit createMessageAudit(BlogPostEvent event) {
        try {
            BlogPost page = event.getBlogPost();
            String spaceKey = page.getSpaceKey();
            return MessageAudit.builder().eventType(Source.getSource((ContentEvent)event).toString()).tag(spaceKey).targetDetails((Map)ImmutableMap.of((Object)PAGE_ID, (Object)page.getIdAsString())).build();
        }
        catch (Exception e) {
            log.warn("Can't build audit message: {}", (Object)e.getMessage());
            return null;
        }
    }
}

