/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ModelVersion;
import com.moveworkforward.ao.AbstractUpgradeTask;
import com.moveworkforward.ao.entity.PluginSettingEntity;
import com.moveworkforward.ao.entity.ReportEntity;
import com.moveworkforward.confluence.microsoftteams.notifier.model.Configuration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.NotificationFilters;
import com.moveworkforward.confluence.microsoftteams.notifier.model.TaskReminderReportConfiguration;
import com.moveworkforward.model.BaseDestination;
import com.moveworkforward.model.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask4
extends AbstractUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask4.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"4");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        activeObjects.migrate(new Class[]{PluginSettingEntity.class, ReportEntity.class});
        this.migrateConfigurations(activeObjects);
        this.migrateReports(activeObjects);
    }

    private void migrateReports(ActiveObjects activeObjects) {
        ReportEntity[] entities = (ReportEntity[])activeObjects.find(ReportEntity.class, Query.select().where("TYPE = ?", new Object[]{"task-reminder-report"}));
        if (entities == null) {
            log.info("Reports, Nothing to migrate for version 4");
            return;
        }
        for (ReportEntity entity : entities) {
            try {
                log.info("{} report configurations for migration", (Object)entity.getContent());
                Map map = (Map)this.objectMapper.readValue(entity.getContent(), Map.class);
                String userKey = (String)map.get("userKey");
                TaskReminderReportConfiguration configuration = (TaskReminderReportConfiguration)((Object)this.objectMapper.readValue(entity.getContent(), TaskReminderReportConfiguration.class));
                if (StringUtils.isNotBlank((CharSequence)userKey)) {
                    configuration.setOwner(new User(userKey));
                }
                entity.setContent(this.objectMapper.writeValueAsString((Object)configuration));
                entity.save();
            }
            catch (Exception e) {
                log.error("Can't migrate report configuration " + entity.getContent(), (Throwable)e);
            }
        }
    }

    private void migrateConfigurations(ActiveObjects activeObjects) {
        PluginSettingEntity[] entities = (PluginSettingEntity[])activeObjects.find(PluginSettingEntity.class, Query.select().where("TYPE = ?", new Object[]{"CONFIGURATION"}));
        if (entities == null) {
            log.info("Configurations, Nothing to migrate for version 4");
            return;
        }
        for (PluginSettingEntity entity : entities) {
            try {
                log.info("{} configurations for migration", (Object)entity.getContent());
                Map map = (Map)this.objectMapper.readValue(entity.getContent(), Map.class);
                String webhookUrl = (String)map.get("webhookUrl");
                Integer webhookUrlId = (Integer)map.get("webhookUrlId");
                Configuration configuration = (Configuration)((Object)this.objectMapper.readValue(entity.getContent(), Configuration.class));
                configuration.setSpaceKey((String)map.get("tag"));
                BaseDestination destination = new BaseDestination();
                destination.setUrl(webhookUrl);
                destination.setUrlId(webhookUrlId);
                destination.setUseUrl(webhookUrlId == null);
                configuration.setDestinations(Collections.singletonList(destination));
                if (configuration.getConfiguration() != null && configuration.getConfiguration().getFilters() != null) {
                    NotificationFilters notificationFilters = configuration.getConfiguration().getFilters();
                    Map filters = Optional.ofNullable(map.get("configuration")).map(o -> ((Map)o).get("filters")).orElse(new HashMap());
                    List includeUserKeys = Optional.ofNullable(filters.get("includeUserKeys")).orElse(new ArrayList());
                    List excludeUserKeys = Optional.ofNullable(filters.get("excludeUserKeys")).orElse(new ArrayList());
                    notificationFilters.setIncludeUsers(includeUserKeys.stream().map(s -> new User(s)).collect(Collectors.toList()));
                    notificationFilters.setExcludeUsers(excludeUserKeys.stream().map(s -> new User(s)).collect(Collectors.toList()));
                }
                entity.setContent(this.objectMapper.writeValueAsString((Object)configuration));
                entity.save();
            }
            catch (Exception e) {
                log.error("Can't migrate configuration " + entity.getContent(), (Throwable)e);
            }
        }
    }
}

