/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.moveworkforward.confluence.microsoftteams.notifier.model.MatchingStrategy;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsSourceEntity;
import com.moveworkforward.confluence.microsoftteams.notifier.model.TopItemsDataHolder;
import com.moveworkforward.confluence.microsoftteams.notifier.model.TopItemsReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.report.AbstractReportExecutor;
import com.moveworkforward.confluence.microsoftteams.notifier.report.TopItemsReportCreator;
import com.moveworkforward.confluence.microsoftteams.notifier.services.StatisticService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.TopItemsReportConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.UrlConfigurationServiceImpl;
import com.moveworkforward.confluence.microsoftteams.notifier.util.FilterUtils;
import com.moveworkforward.model.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TopItemsReportExecutor
extends AbstractReportExecutor<TopItemsReportConfiguration, TopItemsDataHolder> {
    private final StatisticService statisticService;

    @Autowired
    public TopItemsReportExecutor(TopItemsReportConfigurationService configurationService, UrlConfigurationServiceImpl urlConfigurationService, TopItemsReportCreator reportCreator, StatisticService statisticService) {
        super(configurationService, urlConfigurationService, reportCreator);
        this.statisticService = statisticService;
        this.isReschedule = true;
    }

    @Override
    protected TopItemsDataHolder getPayloadDataByConfiguration(TopItemsReportConfiguration configuration, Date date) {
        TopItemsDataHolder dataHolder = new TopItemsDataHolder();
        LinkedHashSet statisticsData = new LinkedHashSet();
        for (StatisticsSourceEntity source : configuration.getSources()) {
            this.statisticService.getByTag(source.getSpaceKey(), false).forEach(sd -> {
                if (this.isAccepted((StatisticsData)((Object)sd), configuration)) {
                    statisticsData.add(sd);
                }
            });
        }
        configuration.getSectionTypes().forEach(sectionType -> {
            switch (sectionType) {
                case AUTHOR: {
                    dataHolder.setTopAuthors(this.collectTopAuthors(statisticsData, configuration));
                    break;
                }
                case CONTRIBUTOR: {
                    dataHolder.setTopContributors(this.collectTopContributors(statisticsData, configuration));
                    break;
                }
                case READER: {
                    dataHolder.setTopViewers(this.collectTopViewers(statisticsData, configuration));
                    break;
                }
                case PAGE: {
                    dataHolder.setTopPages(this.collectTopContent(statisticsData, StatisticsData.ContentType.PAGE, configuration));
                    break;
                }
                case BLOG_POST: {
                    dataHolder.setTopBlogPosts(this.collectTopContent(statisticsData, StatisticsData.ContentType.BLOG_POST, configuration));
                }
            }
        });
        return dataHolder;
    }

    private Set<StatisticsData> collectTopContent(Set<StatisticsData> statisticsData, StatisticsData.ContentType contentType, TopItemsReportConfiguration configuration) {
        statisticsData = statisticsData.stream().filter(sd -> contentType.equals((Object)sd.getContentType())).collect(Collectors.toSet());
        return FilterUtils.trim(FilterUtils.sortByPopularity(statisticsData), configuration.getContentAmount());
    }

    private Set<TopItemsDataHolder.TopViewer> collectTopViewers(Set<StatisticsData> statisticsData, TopItemsReportConfiguration configuration) {
        HashMap topViewerMap = new HashMap();
        statisticsData.forEach(sd -> {
            if (!MapUtils.isEmpty(sd.getUserStatistics().getViewers())) {
                sd.getUserStatistics().getViewers().forEach((user, count) -> {
                    if (user == null || StringUtils.isEmpty((Object)user.getUserKey())) {
                        return;
                    }
                    TopItemsDataHolder.TopViewer topViewer = topViewerMap.compute(user, (viewer, data) -> data == null ? new TopItemsDataHolder.TopViewer((User)viewer) : data);
                    topViewer.setContentCount(topViewer.getContentCount() + count);
                });
            }
        });
        ArrayList topViewers = new ArrayList(topViewerMap.values());
        topViewers.sort((o1, o2) -> o2.getContentCount() - o1.getContentCount());
        return FilterUtils.trim(topViewers, configuration.getContentAmount());
    }

    private Set<TopItemsDataHolder.TopContributor> collectTopContributors(Set<StatisticsData> statisticsData, TopItemsReportConfiguration configuration) {
        HashMap topContributorMap = new HashMap();
        statisticsData.forEach(sd -> {
            User author = sd.getAuthor();
            if (author == null || StringUtils.isEmpty((Object)author.getUserKey())) {
                return;
            }
            TopItemsDataHolder.TopContributor topAuthor = topContributorMap.compute(author, (user, data) -> data == null ? new TopItemsDataHolder.TopContributor((User)user) : data);
            topAuthor.setContentCount(topAuthor.getContentCount() + 1);
            if (!MapUtils.isEmpty(sd.getUserStatistics().getEditors())) {
                sd.getUserStatistics().getEditors().forEach((user, count) -> {
                    if (user == null || StringUtils.isEmpty((Object)user.getUserKey())) {
                        return;
                    }
                    TopItemsDataHolder.TopContributor topEditor = topContributorMap.compute(user, (editor, data) -> data == null ? new TopItemsDataHolder.TopContributor((User)editor) : data);
                    topEditor.setEditCount(topEditor.getEditCount() + count);
                });
            }
        });
        ArrayList topContributors = new ArrayList(topContributorMap.values());
        topContributors.sort((o1, o2) -> o2.getContentCount() + o2.getEditCount() - (o1.getContentCount() + o1.getEditCount()));
        return FilterUtils.trim(topContributors, configuration.getContentAmount());
    }

    private Set<TopItemsDataHolder.TopAuthor> collectTopAuthors(Collection<StatisticsData> statisticsData, TopItemsReportConfiguration configuration) {
        HashMap topAuthorsMap = new HashMap();
        statisticsData.forEach(sd -> {
            User author = sd.getAuthor();
            if (author == null || StringUtils.isEmpty((Object)author.getUserKey())) {
                return;
            }
            TopItemsDataHolder.TopAuthor topAuthor = topAuthorsMap.compute(author, (user, data) -> data == null ? new TopItemsDataHolder.TopAuthor((User)user) : data);
            topAuthor.setContentCount(topAuthor.getContentCount() + 1);
            topAuthor.setCommentCount(topAuthor.getCommentCount() + sd.getCommentCount());
            topAuthor.setLikeCount(topAuthor.getLikeCount() + sd.getLikeCount());
        });
        ArrayList topAuthors = new ArrayList(topAuthorsMap.values());
        topAuthors.sort((o1, o2) -> o2.getLikeCount() + o2.getContentCount() + o2.getCommentCount() - (o1.getLikeCount() + o1.getContentCount() + o1.getCommentCount()));
        return FilterUtils.trim(topAuthors, configuration.getContentAmount());
    }

    private boolean isAccepted(StatisticsData statisticsData, TopItemsReportConfiguration configuration) {
        List<User> authors = configuration.getAuthors();
        List<User> ignoredAuthors = configuration.getIgnoredAuthors();
        List<User> commentators = configuration.getCommentators();
        List<User> ignoredCommentators = configuration.getIgnoredCommentators();
        List<String> labels = configuration.getLabels();
        MatchingStrategy strategy = configuration.getLabelMatchingStrategy() == null ? MatchingStrategy.ALL : configuration.getLabelMatchingStrategy();
        TopItemsReportConfigurationService contentConfigurationService = (TopItemsReportConfigurationService)this.configurationService;
        Optional<SpaceContentEntityObject> optional = Optional.ofNullable(contentConfigurationService.getContentEntity(statisticsData.getContentType(), statisticsData.getContentId()));
        Map<String, Object> additionalInfo = statisticsData.getAdditionalInfo();
        User contentAuthor = Optional.ofNullable(statisticsData.getAuthor()).orElse(new User());
        List contentLabels = optional.map(e -> e.getLabels().stream().map(Label::getName).collect(Collectors.toList())).orElse(new ArrayList());
        additionalInfo.put("labels", contentLabels);
        Set<User> contentCommentators = statisticsData.getUserStatistics().getCommentators().keySet();
        return FilterUtils.isUserAccepted(authors, contentAuthor, "Author") && FilterUtils.isUserAccepted(ignoredAuthors, contentAuthor, "Ignored Author", FilterUtils.CheckStrategy.NOT_CONTAINS) && FilterUtils.isUsersAccepted(commentators, contentCommentators, "Commentators") && FilterUtils.isUsersAccepted(ignoredCommentators, contentCommentators, "Ignored Commentators", FilterUtils.CheckStrategy.NOT_CONTAINS) && FilterUtils.isLabelAccepted(labels, strategy, contentLabels);
    }
}

