/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.listeners;

import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.microsoftteams.notifier.api.EventNotifier;
import com.moveworkforward.confluence.microsoftteams.notifier.components.EventProcessorChecker;
import com.moveworkforward.confluence.microsoftteams.notifier.listeners.AutoSubscribingEventListener;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceEventListener
extends AutoSubscribingEventListener {
    private final EventNotifier eventNotifier;
    private final EventProcessorChecker eventProcessorChecker;

    @Inject
    public ConfluenceEventListener(@ComponentImport EventPublisher eventPublisher, EventNotifier eventNotifier, EventProcessorChecker eventProcessorChecker) {
        super(eventPublisher);
        this.eventNotifier = eventNotifier;
        this.eventProcessorChecker = eventProcessorChecker;
    }

    @EventListener
    public void commentCreateEvent(CommentCreateEvent event) {
        this.processEvent((CommentEvent)event);
    }

    @EventListener
    public void commentUpdateEvent(CommentUpdateEvent event) {
        this.processEvent((CommentEvent)event);
    }

    @EventListener
    public void pageCreateEvent(PageCreateEvent event) {
        this.processEvent((PageEvent)event);
    }

    @EventListener
    public void pageTrashedEvent(PageTrashedEvent event) {
        this.processEvent((PageEvent)event);
    }

    @EventListener
    public void pageDeletedEvent(PageRemoveEvent event) {
        this.processEvent((PageEvent)event);
    }

    @EventListener
    public void pageUpdatedEvent(PageUpdateEvent event) {
        this.processEvent((PageEvent)event);
    }

    @EventListener
    public void blogPostCreateEvent(BlogPostCreateEvent event) {
        this.processEvent((BlogPostEvent)event);
    }

    @EventListener
    public void blogPostUpdateEvent(BlogPostUpdateEvent event) {
        this.processEvent((BlogPostEvent)event);
    }

    @EventListener
    public void blogPostRemoveEvent(BlogPostRemoveEvent event) {
        this.processEvent((BlogPostEvent)event);
    }

    @EventListener
    public void blogPostTrashedEvent(BlogPostTrashedEvent event) {
        this.processEvent((BlogPostEvent)event);
    }

    private void processEvent(CommentEvent event) {
        if (!this.eventProcessorChecker.shouldProcessEvent((ContentEvent)event)) {
            return;
        }
        this.eventNotifier.notify(event);
    }

    private void processEvent(PageEvent event) {
        if (!this.eventProcessorChecker.shouldProcessEvent((ContentEvent)event)) {
            return;
        }
        this.eventNotifier.notify(event);
    }

    private void processEvent(BlogPostEvent event) {
        if (!this.eventProcessorChecker.shouldProcessEvent((ContentEvent)event)) {
            return;
        }
        this.eventNotifier.notify(event);
    }
}

