/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.plugins.tasklist.Task;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ConfigurationLevel;
import com.moveworkforward.confluence.microsoftteams.notifier.model.InlineTaskDataHolder;
import com.moveworkforward.confluence.microsoftteams.notifier.model.TaskReminderReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.report.AbstractReportExecutor;
import com.moveworkforward.confluence.microsoftteams.notifier.report.InlineTaskReminderScheduledReportCreator;
import com.moveworkforward.confluence.microsoftteams.notifier.report.taskremind.InlineTaskServiceHolder;
import com.moveworkforward.confluence.microsoftteams.notifier.report.taskremind.SearchTaskParameters;
import com.moveworkforward.confluence.microsoftteams.notifier.report.taskremind.SearchTaskSortParameter;
import com.moveworkforward.confluence.microsoftteams.notifier.services.TaskReminderReportConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.UrlConfigurationServiceImpl;
import com.moveworkforward.model.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.MethodUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InlineTaskReminderScheduledReportExecutor
extends AbstractReportExecutor<TaskReminderReportConfiguration, InlineTaskDataHolder> {
    private static final Logger log = LoggerFactory.getLogger(InlineTaskReminderScheduledReportExecutor.class);
    private final InlineTaskServiceHolder inlineTaskServiceHolder;
    private final TaskReminderReportConfigurationService service;
    private final SpaceManager spaceManager;
    private final UserAccessor userAccessor;

    @Autowired
    public InlineTaskReminderScheduledReportExecutor(InlineTaskServiceHolder inlineTaskServiceHolder, @ComponentImport SpaceManager spaceManager, TaskReminderReportConfigurationService service, @ComponentImport UserAccessor userAccessor, UrlConfigurationServiceImpl urlConfigurationService, InlineTaskReminderScheduledReportCreator inlineTaskReminderScheduledReportCreator) {
        super(service, urlConfigurationService, inlineTaskReminderScheduledReportCreator);
        this.inlineTaskServiceHolder = inlineTaskServiceHolder;
        this.service = service;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
    }

    @Override
    protected InlineTaskDataHolder getPayloadDataByConfiguration(TaskReminderReportConfiguration configuration, Date date) {
        Map<TaskReminderReportConfiguration.Expiration, List<Task>> tasks = this.getTasks(configuration, date);
        return new InlineTaskDataHolder(tasks.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    public Map<TaskReminderReportConfiguration.Expiration, List<Task>> getTasks(TaskReminderReportConfiguration configuration, Date date) {
        if (this.inlineTaskServiceHolder.getInlineTaskService() == null) {
            log.debug("Inline task plugin is not found");
            return Collections.emptyMap();
        }
        HashMap<TaskReminderReportConfiguration.Expiration, List<Task>> result = new HashMap<TaskReminderReportConfiguration.Expiration, List<Task>>();
        Map<TaskReminderReportConfiguration.Expiration, SearchTaskParameters> params = this.getSearchParameters(configuration, date);
        params.forEach((expiration, value) -> {
            List<Task> tasks = this.searchTasks(configuration, date, (SearchTaskParameters)value);
            if (!CollectionUtils.isEmpty(tasks)) {
                result.put((TaskReminderReportConfiguration.Expiration)((Object)expiration), tasks);
            }
        });
        return result;
    }

    private List<Task> searchTasks(TaskReminderReportConfiguration configuration, Date date, SearchTaskParameters searchTaskParameters) {
        ArrayList<Task> result = new ArrayList<Task>();
        int pageIndex = 0;
        PageResponse<Task> pageResponse = null;
        do {
            searchTaskParameters.setPageIndex(pageIndex++);
            pageResponse = this.searchTasks(configuration.getOwner().getUserKey(), searchTaskParameters);
            List tasks = pageResponse.getResults();
            if (CollectionUtils.isEmpty((Collection)tasks)) {
                log.debug("Found nothing for configuration: {}", (Object)configuration);
                break;
            }
            log.debug("Found {} tasks for date {}", (Object)tasks.size(), (Object)date);
            if (!CollectionUtils.isEmpty(configuration.getCompleteUsers())) {
                tasks = tasks.stream().filter(t -> {
                    ConfluenceUser confluenceUser = this.userAccessor.getUserByName(t.getCompleteUser());
                    return confluenceUser != null && this.extractKeys(configuration.getCompleteUsers()).contains(confluenceUser.getKey().getStringValue());
                }).collect(Collectors.toList());
                log.debug("After filtering by completer {} tasks for date {}", (Object)tasks.size(), (Object)date);
            }
            for (int i = 0; i < tasks.size() && result.size() < configuration.getTaskCount(); ++i) {
                result.add((Task)tasks.get(i));
            }
        } while (result.size() < configuration.getTaskCount() && pageResponse.hasMore());
        return result;
    }

    private PageResponse<Task> searchTasks(String userKey, SearchTaskParameters parameters) {
        AuthenticatedUserThreadLocal.set((ConfluenceUser)this.userAccessor.getUserByKey(new UserKey(userKey)));
        return (PageResponse)MethodUtils.invokeMethod((Object)this.inlineTaskServiceHolder.getInlineTaskService(), (String)"searchTasks", (Object)parameters.getSearchParamsObj());
    }

    private Map<TaskReminderReportConfiguration.Expiration, SearchTaskParameters> getSearchParameters(TaskReminderReportConfiguration configuration, Date date) {
        ArrayList spaceIds = new ArrayList();
        boolean isGlobal = configuration.getSources().stream().anyMatch(s -> ConfigurationLevel.GLOBAL.equals((Object)configuration.getLevel()));
        if (!isGlobal) {
            List<String> spaceKeys = this.service.getSpaceKeys(configuration);
            spaceKeys.forEach(s -> {
                if (!"05f11044-da77-41a8-ac66-a9388ffd0925".equalsIgnoreCase((String)s)) {
                    try {
                        Optional.ofNullable(this.spaceManager.getSpace(s)).ifPresent(space -> spaceIds.add(space.getId()));
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        HashMap<TaskReminderReportConfiguration.Expiration, SearchTaskParameters> result = new HashMap<TaskReminderReportConfiguration.Expiration, SearchTaskParameters>();
        configuration.getExpirations().forEach(expiration -> {
            try {
                result.put((TaskReminderReportConfiguration.Expiration)((Object)expiration), this.getSearchTaskParameters((TaskReminderReportConfiguration.Expiration)((Object)expiration), configuration, spaceIds, date));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
        return result;
    }

    private SearchTaskParameters getSearchTaskParameters(TaskReminderReportConfiguration.Expiration expiration, TaskReminderReportConfiguration configuration, List<Long> spaceIds, Date date) {
        SearchTaskParameters parameters = new SearchTaskParameters(this.inlineTaskServiceHolder.getInlineTaskService());
        parameters.setPageSize(configuration.getTaskCount());
        parameters.setAssigneeUserKeys(this.extractKeys(configuration.getAssigneesUsers()));
        parameters.setCreatorUserKeys(this.extractKeys(configuration.getCreatorsUsers()));
        parameters.setStatus(configuration.getTaskStatus());
        parameters.setSpaceIds(spaceIds);
        parameters.setDisplayedPages(1);
        parameters.setSortParameters(new SearchTaskSortParameter(this.inlineTaskServiceHolder.getInlineTaskService()));
        int days = configuration.getDays();
        DateTime dateTime = new DateTime((Object)date);
        switch (expiration) {
            case EXPIRING_AFTER: {
                parameters.setStartDueDate(dateTime.plusDays(days).toDate());
                break;
            }
            case EXPIRED: {
                parameters.setStartDueDate(dateTime.minusDays(days).toDate());
                parameters.setEndDueDate(dateTime.toDate());
                break;
            }
            case EXPIRING_WITHIN: {
                parameters.setStartDueDate(dateTime.toDate());
                parameters.setEndDueDate(dateTime.plusDays(days).toDate());
                break;
            }
            case WITHOUT_DUE_DATE: {
                parameters.setStartCreatedDate(dateTime.minusDays(days).toDate());
                break;
            }
            default: {
                throw new RuntimeException("Unknown expiration: " + (Object)((Object)expiration));
            }
        }
        return parameters;
    }

    private List<String> extractKeys(List<User> users) {
        if (CollectionUtils.isEmpty(users)) {
            return new ArrayList<String>();
        }
        return users.stream().map(User::getUserKey).collect(Collectors.toList());
    }
}

