/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.model;

import com.atlassian.confluence.plugins.tasklist.Task;
import com.atlassian.confluence.plugins.tasklist.TaskStatus;
import com.atlassian.sal.api.message.I18nResolver;
import com.moveworkforward.confluence.microsoftteams.notifier.components.ConfluenceTaskBodyFormatter;
import com.moveworkforward.confluence.microsoftteams.notifier.model.AdaptiveCard;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TasksReminderCard
extends AdaptiveCard {
    private final ConfluenceTaskBodyFormatter confluenceTaskBodyFormatter;
    private final I18nResolver i18nResolver;

    public TasksReminderCard(Set<Task> tasks, String configurationName, ConfluenceTaskBodyFormatter confluenceTaskBodyFormatter, I18nResolver i18nResolver) throws JSONException {
        this.confluenceTaskBodyFormatter = confluenceTaskBodyFormatter;
        this.i18nResolver = i18nResolver;
        if (tasks == null || tasks.size() == 0) {
            return;
        }
        this.addToBody(this.createTitleContainer(configurationName));
        List<Task> completeTasks = tasks.stream().filter(t -> t.getStatus() == TaskStatus.CHECKED).collect(Collectors.toList());
        this.addToBody(this.createCompleteTasksContainer(completeTasks));
        List<Task> incompleteTasks = tasks.stream().filter(t -> t.getStatus() == TaskStatus.UNCHECKED).collect(Collectors.toList());
        this.addToBody(this.createIncompleteTasksContainer(incompleteTasks));
    }

    private JSONObject createCompleteTasksContainer(List<Task> tasks) throws JSONException {
        if (tasks == null || tasks.size() == 0) {
            return null;
        }
        String completeTasksString = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.tasks.complete");
        return this.createTasksContainer(tasks, "complete", completeTasksString);
    }

    private JSONObject createIncompleteTasksContainer(List<Task> tasks) throws JSONException {
        if (tasks == null || tasks.size() == 0) {
            return null;
        }
        String incompleteTasksString = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.tasks.incomplete");
        return this.createTasksContainer(tasks, "incomplete", incompleteTasksString);
    }

    private JSONObject createTasksContainer(List<Task> tasks, String id, String title) throws JSONException {
        if (tasks == null || tasks.size() == 0) {
            return null;
        }
        JSONObject container = new JSONObject();
        JSONArray items = new JSONArray();
        container.put("type", (Object)"Container");
        container.put("items", (Object)items);
        JSONObject headerItem = new JSONObject();
        headerItem.put("type", (Object)"ColumnSet");
        JSONArray columns = new JSONArray();
        columns.put((Object)this.createTextColumn(title + " (" + tasks.size() + ")", "Medium"));
        columns.put((Object)this.createToggleVisibilityColumn(id));
        headerItem.put("columns", (Object)columns);
        items.put((Object)headerItem);
        JSONObject listContainerItem = this.createTasksListContainer(id, tasks);
        items.put((Object)listContainerItem);
        return container;
    }

    private JSONObject createTitleContainer(String configurationName) throws JSONException {
        JSONObject container = new JSONObject();
        JSONArray items = new JSONArray();
        container.put("type", (Object)"Container");
        container.put("spacing", (Object)"Large");
        container.put("style", (Object)"emphasis");
        container.put("items", (Object)items);
        container.put("bleed", true);
        JSONObject item = new JSONObject();
        JSONArray columns = new JSONArray();
        item.put("type", (Object)"ColumnSet");
        item.put("columns", (Object)columns);
        String title = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.reports.task.reminder.title");
        if (configurationName != null) {
            title = title + " - " + configurationName;
        }
        columns.put((Object)this.createTextColumn(title, "Large"));
        items.put((Object)item);
        return container;
    }

    private JSONObject createTextColumn(String text, String size) throws JSONException {
        JSONObject column = new JSONObject();
        JSONArray items = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"TextBlock");
        item.put("text", (Object)text);
        item.put("wrap", true);
        if (size != null) {
            item.put("size", (Object)size);
        }
        item.put("weight", (Object)"Bolder");
        items.put((Object)item);
        column.put("items", (Object)items);
        column.put("type", (Object)"Column");
        return column;
    }

    private JSONObject createToggleVisibilityColumn(String id) throws JSONException {
        JSONObject column = new JSONObject();
        column.put("type", (Object)"Column");
        column.put("spacing", (Object)"Small");
        JSONObject selectAction = new JSONObject();
        selectAction.put("type", (Object)"Action.ToggleVisibility");
        selectAction.put("title", (Object)"expand");
        JSONArray targetElements = new JSONArray();
        targetElements.put((Object)("content" + id));
        targetElements.put((Object)("down" + id));
        targetElements.put((Object)("up" + id));
        selectAction.put("targetElements", (Object)targetElements);
        column.put("selectAction", (Object)selectAction);
        column.put("verticalContentAlignment", (Object)"Center");
        JSONArray items = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"Image");
        item.put("id", (Object)("down" + id));
        item.put("url", (Object)"https://adaptivecards.io/content/down.png");
        item.put("width", (Object)"20px");
        item.put("altText", (Object)"Details collapsed");
        items.put((Object)item);
        item = new JSONObject();
        item.put("type", (Object)"Image");
        item.put("id", (Object)("up" + id));
        item.put("url", (Object)"https://adaptivecards.io/content/up.png");
        item.put("width", (Object)"20px");
        item.put("altText", (Object)"Details expanded");
        item.put("isVisible", false);
        items.put((Object)item);
        column.put("items", (Object)items);
        column.put("width", (Object)"auto");
        return column;
    }

    private JSONObject createTasksListContainer(String id, List<Task> tasks) throws JSONException {
        JSONObject container = new JSONObject();
        container.put("type", (Object)"Container");
        container.put("id", (Object)("content" + id));
        container.put("isVisible", false);
        JSONArray items = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"Container");
        JSONArray subItems = new JSONArray();
        for (Task task : tasks) {
            String taskBody = this.confluenceTaskBodyFormatter.parseTaskBody(task);
            JSONObject subItem = new JSONObject();
            subItem.put("type", (Object)"TextBlock");
            subItem.put("text", (Object)taskBody);
            subItem.put("isSubtle", true);
            subItem.put("wrap", true);
            subItems.put((Object)subItem);
        }
        item.put("items", (Object)subItems);
        items.put((Object)item);
        container.put("items", (Object)items);
        return container;
    }
}

