/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ApplicationUpdateConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.repository.ApplicationUpdateConfigurationRepository;
import com.moveworkforward.confluence.microsoftteams.notifier.services.AbstractReportConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.validators.AdminValidationHelper;
import com.moveworkforward.model.AppVersion;
import com.moveworkforward.service.ConfigurationAuditService;
import com.moveworkforward.service.impl.AppVersionService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationUpdateConfigurationService
extends AbstractReportConfigurationService<ApplicationUpdateConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationUpdateConfigurationService.class);
    protected final AppVersionService appVersionService;
    private final PluginAccessor pluginAccessor;

    @Autowired
    public ApplicationUpdateConfigurationService(ApplicationUpdateConfigurationRepository repository, ConfigurationAuditService auditService, AdminValidationHelper validationHelper, @ComponentImport UserAccessor userAccessor, @ComponentImport PluginAccessor pluginAccessor, AppVersionService appVersionService) {
        super(repository, auditService, validationHelper, userAccessor);
        this.pluginAccessor = pluginAccessor;
        this.appVersionService = appVersionService;
    }

    @Override
    public void validate(ApplicationUpdateConfiguration configuration) {
        super.validate(configuration);
        configuration.getDelivery().setDeliverOnSchedule(true);
        if (CollectionUtils.isEmpty((Collection)configuration.getProducts()) && CollectionUtils.isEmpty((Collection)configuration.getPlugins())) {
            throw new RuntimeException("Either products or plugins updates should be set up");
        }
    }

    protected void doEnhancement(ApplicationUpdateConfiguration configuration) {
        if (CollectionUtils.isNotEmpty((Collection)configuration.getPlugins())) {
            configuration.getPlugins().forEach(pluginSource -> {
                block6: {
                    try {
                        Plugin plugin = this.pluginAccessor.getPlugin(pluginSource.getKey());
                        if (plugin != null) {
                            pluginSource.setName(plugin.getName());
                            break block6;
                        }
                        if (!StringUtils.isBlank((CharSequence)pluginSource.getName())) break block6;
                        try {
                            AppVersion availableVersion = this.appVersionService.getLastAvailablePluginVersion(pluginSource.getKey());
                            if (availableVersion != null) {
                                pluginSource.setName(availableVersion.getName());
                            }
                        }
                        catch (Exception e) {
                            log.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    @Override
    protected List<String> getSpaceKeys(ApplicationUpdateConfiguration configuration) {
        return Arrays.asList("05f11044-da77-41a8-ac66-a9388ffd0925");
    }

    public String getType() {
        return "applications-update-report";
    }

    public Class<ApplicationUpdateConfiguration> getConfigurationClass() {
        return ApplicationUpdateConfiguration.class;
    }
}

