/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableMap;
import com.moveworkforward.ao.PluginRepository;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.confluence.microsoftteams.notifier.actions.Source;
import com.moveworkforward.confluence.microsoftteams.notifier.model.Configuration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ConfluenceGlobalSettings;
import com.moveworkforward.confluence.microsoftteams.notifier.model.DecoratorSpace;
import com.moveworkforward.confluence.microsoftteams.notifier.model.QuestionType;
import com.moveworkforward.confluence.microsoftteams.notifier.services.ConfigurationServiceImpl;
import com.moveworkforward.confluence.microsoftteams.notifier.services.GlobalSettingsService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.UrlConfigurationServiceImpl;
import com.moveworkforward.confluence.microsoftteams.notifier.util.SpaceUtils;
import com.moveworkforward.model.BaseDestination;
import com.moveworkforward.model.UrlTestResponse;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="configurations")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class ConfluenceConfigurationController {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceConfigurationController.class);
    private final ConfigurationServiceImpl configurationService;
    private final SpaceManager spaceManager;
    private final PermissionManager permissionManager;
    private final PluginAccessor pluginAccessor;
    private UrlConfigurationServiceImpl urlConfigurationService;
    private final GlobalSettingsService globalSettingsService;
    private final List<PluginRepository<? extends PluginEntity>> repositories;

    @Inject
    public ConfluenceConfigurationController(ConfigurationServiceImpl configurationService, UrlConfigurationServiceImpl urlConfigurationService, GlobalSettingsService globalSettingsService, @ComponentImport SpaceManager spaceManager, @ComponentImport PermissionManager permissionManager, @ComponentImport PluginAccessor pluginAccessor, List<PluginRepository<? extends PluginEntity>> repositories) {
        this.configurationService = configurationService;
        this.urlConfigurationService = urlConfigurationService;
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.pluginAccessor = pluginAccessor;
        this.globalSettingsService = globalSettingsService;
        this.repositories = repositories;
    }

    @GET
    @Path(value="/spaces")
    public List<DecoratorSpace> getSpaces(@QueryParam(value="currentSpaceKey") String currentSpaceKey) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        ArrayList<DecoratorSpace> spaces = new ArrayList<DecoratorSpace>();
        if (currentSpaceKey == null) {
            TreeMap<String, DecoratorSpace> result = new TreeMap<String, DecoratorSpace>();
            SpaceUtils spaceUtils = new SpaceUtils(this.spaceManager, this.repositories);
            spaceUtils.fillUpSpaces(result);
            ConfluenceGlobalSettings globalSettings = (ConfluenceGlobalSettings)this.globalSettingsService.get(false);
            spaceUtils.fillUpSpaces(globalSettings.getAllowedKeys(), result);
            spaceUtils.fillUpSpaces(globalSettings.getIgnoredKeys(), result);
            spaceUtils.fillUpSpaces(globalSettings.getSpacesWhereAllowedNotificationsForViewRestrictedContent(), result);
            spaces.addAll(result.values());
        } else {
            Space space = this.spaceManager.getSpace(currentSpaceKey);
            if (this.permissionManager.hasPermission((User)confluenceUser, Permission.VIEW, (Object)space)) {
                spaces.add(new DecoratorSpace(space));
            }
        }
        return spaces;
    }

    @GET
    @Path(value="/event-types")
    public Set<Map<String, String>> getSupportedEventTypes() {
        ArrayList<Source> supportedEventTypes = new ArrayList<Source>();
        supportedEventTypes.add(Source.PAGE_CREATED);
        supportedEventTypes.add(Source.PAGE_UPDATED);
        supportedEventTypes.add(Source.PAGE_DELETED);
        supportedEventTypes.add(Source.COMMENT_CREATED);
        supportedEventTypes.add(Source.COMMENT_UPDATED);
        supportedEventTypes.add(Source.BLOGPOST_CREATED);
        supportedEventTypes.add(Source.BLOGPOST_UPDATED);
        supportedEventTypes.add(Source.BLOGPOST_DELETED);
        supportedEventTypes.add(Source.ATTACHMENT_CREATED);
        supportedEventTypes.add(Source.ATTACHMENT_UPDATED);
        try {
            if (this.pluginAccessor.isPluginEnabled("com.atlassian.confluence.extra.team-calendars")) {
                supportedEventTypes.add(Source.CALENDAR_EVENT_CREATED);
                supportedEventTypes.add(Source.CALENDAR_EVENT_UPDATED);
                supportedEventTypes.add(Source.CALENDAR_EVENT_DELETED);
            }
        }
        catch (Throwable e) {
            log.debug("Could not test Team Calendars plugin", e);
        }
        if (this.pluginAccessor.isPluginEnabled("com.elitesoftsp.confluence.tiny.question.answer.plugins")) {
            supportedEventTypes.add(Source.ANSWER_CREATED);
            supportedEventTypes.add(Source.QUESTION_CREATED);
        } else {
            try {
                if (this.pluginAccessor.isPluginModuleEnabled(QuestionType.ANSWER.getPluginModuleKey())) {
                    supportedEventTypes.add(Source.ANSWER_CREATED);
                }
            }
            catch (Throwable e) {
                log.debug("Could not test Answers plugin", e);
            }
            try {
                if (this.pluginAccessor.isPluginModuleEnabled(QuestionType.QUESTION.getPluginModuleKey())) {
                    supportedEventTypes.add(Source.QUESTION_CREATED);
                }
            }
            catch (Throwable e) {
                log.debug("Could not test Questions plugin", e);
            }
        }
        LinkedHashSet<Map<String, String>> result = new LinkedHashSet<Map<String, String>>();
        supportedEventTypes.forEach(eventType -> result.add((Map<String, String>)ImmutableMap.of((Object)"type", (Object)eventType.toString(), (Object)"text", (Object)eventType.getName())));
        return result;
    }

    @POST
    @Path(value="/test-webhook-url")
    public UrlTestResponse testWebhookUrl(BaseDestination request, @QueryParam(value="showDetails") boolean showDetails) {
        return this.urlConfigurationService.testUrl(request, showDetails);
    }

    @GET
    public List<Configuration> getConfigurations(@QueryParam(value="spaceKey") String spaceKey) {
        log.debug("Getting configurations for spaceKey: " + spaceKey);
        List configurations = StringUtils.isBlank((String)spaceKey) ? this.configurationService.getAll(true) : this.configurationService.getByTag(spaceKey, true);
        return configurations;
    }

    @POST
    public Configuration saveConfiguration(Configuration configuration) {
        log.debug("Saving: " + configuration.toString());
        return (Configuration)this.configurationService.save(configuration, true);
    }

    @Path(value="key/{key}")
    @DELETE
    public Configuration deleteConfigurationByKey(@PathParam(value="key") String key) {
        if (key == null) {
            throw new RuntimeException("Id was not supplied.");
        }
        return (Configuration)((Object)this.configurationService.deleteByKey(key));
    }

    @Path(value="/{id}")
    @DELETE
    public Configuration deleteConfigurationByKey(@PathParam(value="id") Integer id) {
        if (id == null) {
            throw new RuntimeException("Id was not supplied.");
        }
        return (Configuration)this.configurationService.delete(id, true);
    }
}

