/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.components;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.tasklist.Task;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceTaskBodyFormatter {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceTaskBodyFormatter.class);
    private final UserAccessor userAccessor;
    private final LocaleManager localeManager;
    private final TimeZoneManager timeZoneManager;
    private final PageManager pageManager;
    private final String baseUrl;

    @Autowired
    public ConfluenceTaskBodyFormatter(@ComponentImport UserAccessor userAccessor, @ComponentImport PageManager pageManager, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport LocaleManager localeManager, @ComponentImport TimeZoneManager timeZoneManager) {
        this.userAccessor = userAccessor;
        this.localeManager = localeManager;
        this.timeZoneManager = timeZoneManager;
        this.pageManager = pageManager;
        this.baseUrl = webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE);
    }

    public String parseTaskBody(Task task) {
        if (task == null || task.getBody() == null) {
            return null;
        }
        String body = task.getBody();
        Pattern pattern = Pattern.compile("<span>(.*?)</span>");
        Matcher matcher = pattern.matcher(body);
        String response = matcher.find() && matcher.groupCount() > 0 ? matcher.group(1) : body;
        response = this.parseUsers(response);
        response = this.parseDate(response);
        log.debug("parseTaskBody() -> " + response);
        return this.addLinkAndListToTaskBody(response.trim(), task.getContentId());
    }

    private String addLinkAndListToTaskBody(String body, long contentId) {
        String pageUrl = this.baseUrl + this.getPageLink(contentId);
        return "* [" + body + "](" + pageUrl + ")";
    }

    private String getPageLink(long contentId) {
        Page page = this.pageManager.getPage(contentId);
        if (page == null) {
            return null;
        }
        return page.getUrlPath();
    }

    private String parseUsers(String body) {
        String result = body;
        Pattern pattern = Pattern.compile("<ac:link><ri:user ri:userkey=\"(.*?)\" /></ac:link>");
        Matcher matcher = pattern.matcher(body);
        if (!matcher.find()) {
            log.debug("parseUsers() no match found for body " + body);
        } else if (matcher.groupCount() < 1) {
            log.debug("parseUsers() not enough groups found for body " + body);
        } else {
            do {
                String userKey;
                ConfluenceUser user;
                if ((user = this.userAccessor.getUserByKey(new UserKey(userKey = matcher.group(1)))) != null) {
                    result = result.replace(matcher.group(0), user.getName());
                    continue;
                }
                log.debug("parseUsers() user with key " + userKey + " not found");
                result = result.replace(matcher.group(0), matcher.group(1));
            } while (matcher.find());
        }
        return result;
    }

    private String parseDate(String body) {
        String result = body;
        Pattern pattern = Pattern.compile("<time datetime=\"(.*?)\" />");
        Matcher matcher = pattern.matcher(body);
        if (!matcher.find()) {
            log.debug("parseDate() no match found for body " + body);
        } else if (matcher.groupCount() < 1) {
            log.debug("parseDate() not enough groups found for body " + body);
        } else {
            do {
                String formattedDate = matcher.group(1);
                try {
                    Date date = new SimpleDateFormat("yyyy-MM-dd").parse(matcher.group(1));
                    formattedDate = this.formatDate(date);
                }
                catch (ParseException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                result = result.replace(matcher.group(0), formattedDate);
            } while (matcher.find());
        }
        return result;
    }

    private String formatDate(Date date) {
        try {
            ZoneId zone = this.timeZoneManager.getDefaultTimeZone().toZoneId();
            LocalDate localDate = LocalDate.from(date.toInstant().atZone(zone));
            return this.getDateTimeFormatter(FormatStyle.SHORT).format(localDate);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private DateTimeFormatter getDateTimeFormatter(FormatStyle formatStyle) {
        return DateTimeFormatter.ofLocalizedDate(formatStyle).withLocale(this.localeManager.getSiteDefaultLocale());
    }
}

