/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ApplicationUpdateConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.report.AbstractReportCreator;
import com.moveworkforward.model.AppVersion;
import com.moveworkforward.model.VersionPayloadHolder;
import com.moveworkforward.model.teams.MessageData;
import com.moveworkforward.model.teams.payload.Message;
import com.moveworkforward.util.TeamsPayloadUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationUpdateReportCreator
extends AbstractReportCreator<ApplicationUpdateConfiguration, VersionPayloadHolder> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationUpdateReportCreator.class);

    @Autowired
    public ApplicationUpdateReportCreator(I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        super(i18nResolver, webResourceUrlProvider);
    }

    @Override
    public String createPayload(ApplicationUpdateConfiguration configuration, VersionPayloadHolder payloadHolder) {
        String subTitle = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.app.update");
        String showText = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.show");
        String hideText = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.hide");
        MessageData messageData = new MessageData(configuration.getName(), subTitle, null);
        if (CollectionUtils.isNotEmpty((Collection)payloadHolder.getProductVersions())) {
            String productTitle = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.products");
            messageData.getItems().add(new MessageData.Item("products", productTitle, showText, hideText, this.getItems(payloadHolder.getProductVersions())));
        }
        if (CollectionUtils.isNotEmpty((Collection)payloadHolder.getPluginVersions())) {
            String pluginTitle = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.plugins");
            messageData.getItems().add(new MessageData.Item("plugins", pluginTitle, showText, hideText, this.getItems(payloadHolder.getPluginVersions())));
        }
        Message message = TeamsPayloadUtils.createToggleableItemsMessage((MessageData)messageData);
        String payload = this.objectMapper.writeValueAsString((Object)message);
        log.debug("Update product/plugin report payload: {}", (Object)payload);
        return payload;
    }

    private List<String> getItems(List<AppVersion> versions) {
        ArrayList<String> items = new ArrayList<String>();
        versions.forEach(version -> {
            StringBuilder builder = new StringBuilder();
            builder.append(version.getName());
            String versionValue = StringUtils.isBlank((CharSequence)version.getUrl()) ? version.getVersion() : TeamsPayloadUtils.makeMicrosoftTeamsLink((String)version.getVersion(), (String)version.getUrl());
            builder.append(" \r- ").append(this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.new.version")).append(": ").append(versionValue);
            if (StringUtils.isNotBlank((CharSequence)version.getNotes())) {
                builder.append(" \r- ").append(this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.notes")).append(": ").append(version.getNotes());
            }
            builder.append(" \r");
            items.add(builder.toString());
        });
        return items;
    }
}

