/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.model;

import com.moveworkforward.ao.entity.EntityType;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.confluence.microsoftteams.notifier.actions.Source;
import com.moveworkforward.confluence.microsoftteams.notifier.configuration.ChannelConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.NotificationRuleConfiguration;
import com.moveworkforward.model.AbstractPluginEntity;
import com.moveworkforward.model.BaseDestination;
import com.moveworkforward.model.DestinationHolder;
import com.moveworkforward.model.SourcePluginEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true, value={"destination", "sourceKeys"})
@EntityType(value="CONFIGURATION")
public class Configuration
extends AbstractPluginEntity
implements SourcePluginEntity,
PluginEntity,
DestinationHolder<BaseDestination> {
    public static final String TYPE = "CONFIGURATION";
    public static final String ALL_SPACES = "05f11044-da77-41a8-ac66-a9388ffd0925";
    public static final String NO_SPACES = "f94a2448-696d-4d81-ae30-4e2054daf97f";
    public static final String NOT_SET = "NOT_SET";
    @JsonProperty(value="key")
    private String key;
    private String spaceKey;
    private List<BaseDestination> destinations = new ArrayList<BaseDestination>();
    private List<Source> events = new ArrayList<Source>();
    private String pathFilter;
    private String name;
    @JsonProperty(value="configuration")
    private NotificationRuleConfiguration configuration = new NotificationRuleConfiguration();
    private boolean enabled = true;
    private boolean minimalContent;
    private boolean expandedCard;
    private boolean viewActionsButton = true;

    public Configuration() {
        this.destinations.add(new BaseDestination());
    }

    public Configuration(ChannelConfiguration entity) {
        this.key = entity.getId();
        this.spaceKey = entity.getSpaceKey();
        BaseDestination destination = new BaseDestination();
        destination.setUrl(entity.getWebhookUrl());
        this.getDestinations().add(destination);
        this.pathFilter = entity.getPathFilter();
        this.enabled = entity.getEnabled() == null || entity.getEnabled() != false;
        this.name = entity.getName();
        if (StringUtils.isNotBlank((String)entity.getEvents())) {
            for (String source : entity.getEvents().split(",")) {
                this.events.add(Source.valueOf(source));
            }
        }
    }

    public String getKey() {
        if (StringUtils.isBlank((String)this.key)) {
            this.key = UUID.randomUUID().toString();
        }
        return this.key;
    }

    public String getTag() {
        return NO_SPACES.equalsIgnoreCase(this.getSpaceKey()) ? ALL_SPACES : this.getSpaceKey();
    }

    public String getSpaceKey() {
        if (StringUtils.isBlank((String)this.spaceKey)) {
            this.spaceKey = ALL_SPACES;
        }
        return this.spaceKey;
    }

    public BaseDestination getDestination() {
        return this.destinations.get(0);
    }

    public List<String> getSourceKeys() {
        return Collections.singletonList(this.getSpaceKey());
    }

    public void setSourceKeys(List<String> sourceKeys) {
        this.spaceKey = CollectionUtils.isEmpty(sourceKeys) ? ALL_SPACES : sourceKeys.get(0);
    }

    public List<BaseDestination> getDestinations() {
        return this.destinations;
    }

    public List<Source> getEvents() {
        return this.events;
    }

    public String getPathFilter() {
        return this.pathFilter;
    }

    public String getName() {
        return this.name;
    }

    public NotificationRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMinimalContent() {
        return this.minimalContent;
    }

    public boolean isExpandedCard() {
        return this.expandedCard;
    }

    public boolean isViewActionsButton() {
        return this.viewActionsButton;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setDestinations(List<BaseDestination> destinations) {
        this.destinations = destinations;
    }

    public void setEvents(List<Source> events) {
        this.events = events;
    }

    public void setPathFilter(String pathFilter) {
        this.pathFilter = pathFilter;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConfiguration(NotificationRuleConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setMinimalContent(boolean minimalContent) {
        this.minimalContent = minimalContent;
    }

    public void setExpandedCard(boolean expandedCard) {
        this.expandedCard = expandedCard;
    }

    public void setViewActionsButton(boolean viewActionsButton) {
        this.viewActionsButton = viewActionsButton;
    }

    public String toString() {
        return "Configuration(super=" + super.toString() + ", key=" + this.key + ", spaceKey=" + this.spaceKey + ", destinations=" + this.destinations + ", events=" + this.events + ", pathFilter=" + this.pathFilter + ", name=" + this.name + ", configuration=" + this.configuration + ", enabled=" + this.enabled + ", minimalContent=" + this.minimalContent + ", expandedCard=" + this.expandedCard + ", viewActionsButton=" + this.viewActionsButton + ")";
    }
}

