/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.tasklist.Task;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.moveworkforward.confluence.microsoftteams.notifier.components.ConfluenceTaskBodyFormatter;
import com.moveworkforward.confluence.microsoftteams.notifier.model.InlineTaskDataHolder;
import com.moveworkforward.confluence.microsoftteams.notifier.model.TaskReminderReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.TasksReminderCard;
import com.moveworkforward.confluence.microsoftteams.notifier.report.AbstractReportCreator;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InlineTaskReminderScheduledReportCreator
extends AbstractReportCreator<TaskReminderReportConfiguration, InlineTaskDataHolder> {
    private static final Logger log = LoggerFactory.getLogger(InlineTaskReminderScheduledReportCreator.class);
    private final LocaleManager localeManager;
    private final TimeZoneManager timeZoneManager;
    private final PageManager pageManager;
    private final ConfluenceTaskBodyFormatter confluenceTaskBodyFormatter;

    @Autowired
    public InlineTaskReminderScheduledReportCreator(@ComponentImport UserAccessor userAccessor, @ComponentImport PageManager pageManager, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport LocaleManager localeManager, @ComponentImport TimeZoneManager timeZoneManager, @ComponentImport I18nResolver i18nResolver) {
        super(i18nResolver, webResourceUrlProvider);
        this.localeManager = localeManager;
        this.timeZoneManager = timeZoneManager;
        this.pageManager = pageManager;
        this.confluenceTaskBodyFormatter = new ConfluenceTaskBodyFormatter(userAccessor, pageManager, webResourceUrlProvider, localeManager, timeZoneManager);
    }

    @Override
    public String createPayload(TaskReminderReportConfiguration configuration, InlineTaskDataHolder payloadHolder) {
        String cardString = null;
        Set<Task> tasks = payloadHolder.getTasks();
        String configurationName = configuration.getName();
        if (tasks == null || tasks.size() == 0) {
            log.debug("createTasksReminderCardFromTasks() no tasks");
            return null;
        }
        try {
            TasksReminderCard card = new TasksReminderCard(tasks, configurationName, this.confluenceTaskBodyFormatter, this.i18nResolver);
            cardString = card.convertToString();
        }
        catch (Exception e) {
            log.error("Can't create card from task", (Throwable)e);
        }
        return cardString;
    }

    private String getPageLink(long contentId) {
        Page page = this.pageManager.getPage(contentId);
        if (page == null) {
            return null;
        }
        return page.getUrlPath();
    }

    private String formatDate(Date date) {
        try {
            ZoneId zone = this.timeZoneManager.getDefaultTimeZone().toZoneId();
            LocalDate localDate = LocalDate.from(date.toInstant().atZone(zone));
            return this.getDateTimeFormatter(FormatStyle.SHORT).format(localDate);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private DateTimeFormatter getDateTimeFormatter(FormatStyle formatStyle) {
        return DateTimeFormatter.ofLocalizedDate(formatStyle).withLocale(this.localeManager.getSiteDefaultLocale());
    }
}

