/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.util;

import com.moveworkforward.confluence.microsoftteams.notifier.actions.Source;
import com.moveworkforward.confluence.microsoftteams.notifier.model.payload.AbstractBodyItem;
import com.moveworkforward.confluence.microsoftteams.notifier.model.payload.Attachment;
import com.moveworkforward.confluence.microsoftteams.notifier.model.payload.ColumnItem;
import com.moveworkforward.confluence.microsoftteams.notifier.model.payload.ColumnSet;
import com.moveworkforward.confluence.microsoftteams.notifier.model.payload.Container;
import com.moveworkforward.confluence.microsoftteams.notifier.model.payload.Message;
import com.moveworkforward.confluence.microsoftteams.notifier.model.payload.MicrosoftTeamsActiveCardMessage;
import com.moveworkforward.confluence.microsoftteams.notifier.model.payload.TextBlock;
import com.moveworkforward.confluence.microsoftteams.notifier.util.MessageData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadUtils {
    private static final Logger log = LoggerFactory.getLogger(PayloadUtils.class);

    private PayloadUtils() {
    }

    public static String makeMicrosoftTeamsLink(String text, String url) {
        return "[" + text + "](" + url + ")";
    }

    public static Message createToggleableItemsMessage(MessageData messageData) {
        MicrosoftTeamsActiveCardMessage microsoftTeamsActiveCardMessage = new MicrosoftTeamsActiveCardMessage(messageData.getTitle());
        microsoftTeamsActiveCardMessage.getBody().add(TextBlock.builder().text(messageData.getTitle()).wrap(true).weight("Bolder").build());
        microsoftTeamsActiveCardMessage.getBody().add(TextBlock.builder().text(messageData.getDescription()).wrap(true).size("Medium").subtle(true).build());
        if (StringUtils.isNotBlank((CharSequence)messageData.getSectionsTitle())) {
            Container sectionsContainer = Container.builder().visible(true).items(new ArrayList<AbstractBodyItem>()).spacing("Large").style("emphasis").bleed(true).build();
            microsoftTeamsActiveCardMessage.getBody().add(sectionsContainer);
            sectionsContainer.getItems().add(new ColumnSet(new ColumnSet.Column(ColumnItem.builder().text(messageData.getSectionsTitle()).visible(true).weight("Bolder").build())));
        }
        messageData.getItems().forEach(messageItem -> PayloadUtils.addMessageItems(microsoftTeamsActiveCardMessage.getBody(), messageItem));
        return new Message(new Attachment(microsoftTeamsActiveCardMessage));
    }

    public static void addMessageItems(List<AbstractBodyItem> body, MessageData.Item messageItem) {
        List<String> content = messageItem.getContent();
        Container container = new Container();
        body.add(container);
        ColumnSet columnSet = new ColumnSet();
        container.getItems().add(columnSet);
        columnSet.getColumns().add(new ColumnSet.Column(ColumnItem.builder().text(messageItem.getTitle()).visible(true).wrap(true).build()));
        if (CollectionUtils.isEmpty(content)) {
            log.debug("No content for: {}", (Object)messageItem.getId());
            return;
        }
        ColumnSet.Column toggleColumn = ColumnSet.Column.builder().width("auto").spacing("Small").items(new ArrayList<ColumnItem>()).build();
        String typeId = messageItem.getId().replace(" ", "_");
        toggleColumn.setSelectAction(new ColumnSet.SelectAction("cardContent-" + typeId, "chevronDown-" + typeId, "chevronUp-" + typeId));
        toggleColumn.getItems().add(ColumnItem.builder().wrap(true).color("Accent").visible(true).id("chevronDown-" + typeId).text(messageItem.getShowText()).build());
        toggleColumn.getItems().add(ColumnItem.builder().wrap(true).color("Accent").visible(false).id("chevronUp-" + typeId).text(messageItem.getHideText()).build());
        columnSet.getColumns().add(toggleColumn);
        List<AbstractBodyItem> items = content.stream().map(item -> TextBlock.builder().text((String)item).subtle(false).wrap(true).build()).collect(Collectors.toList());
        container.getItems().add(Container.builder().id("cardContent-" + typeId).visible(false).items(items).build());
    }

    public static String toMinimalMessage(String message, Source source) {
        try {
            JSONObject jsonObject = new JSONObject(message);
            Set<String> factsToKeep = PayloadUtils.getFactsToKeep(source);
            if (factsToKeep.isEmpty()) {
                jsonObject.remove("sections");
            } else {
                JSONArray array = jsonObject.optJSONArray("sections");
                if (array != null) {
                    for (int i = 0; i < array.length(); ++i) {
                        JSONArray facts = array.optJSONObject(i).optJSONArray("facts");
                        if (facts == null) continue;
                        JSONArray newFacts = new JSONArray();
                        for (int j = 0; j < facts.length(); ++j) {
                            JSONObject fact = facts.getJSONObject(j);
                            if (!factsToKeep.contains(fact.getString("name"))) continue;
                            newFacts.put((Object)fact);
                        }
                        JSONObject detailsSection = new JSONObject();
                        detailsSection.put("facts", (Object)newFacts);
                        JSONArray sections = new JSONArray();
                        sections.put((Object)detailsSection);
                        jsonObject.put("sections", (Object)sections);
                        break;
                    }
                }
            }
            return jsonObject.toString();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return message;
        }
    }

    private static Set<String> getFactsToKeep(Source source) {
        HashSet<String> result = new HashSet<String>();
        switch (source) {
            case COMMENT_UPDATED: 
            case COMMENT_CREATED: {
                result.add("Comment");
            }
        }
        return result;
    }
}

