/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.components;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRestoreEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.moveworkforward.confluence.microsoftteams.notifier.actions.Source;
import com.moveworkforward.confluence.microsoftteams.notifier.model.CalendarEventInfo;
import com.moveworkforward.confluence.microsoftteams.notifier.model.QuestionAndAnswerEventInfo;
import com.moveworkforward.confluence.microsoftteams.notifier.model.QuestionType;
import com.moveworkforward.confluence.microsoftteams.notifier.util.DateTimeUtil;
import com.moveworkforward.confluence.microsoftteams.notifier.util.PayloadUtils;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MicrosoftTeamsEventCreator {
    private static final Logger log = Logger.getLogger(MicrosoftTeamsEventCreator.class);
    private final DateTimeUtil dateTimeUtil;

    @Autowired
    public MicrosoftTeamsEventCreator(DateTimeUtil dateTimeUtil) {
        this.dateTimeUtil = dateTimeUtil;
    }

    public static String absoluteUrl(String relativeUrl, String baseUrl) {
        return (baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl) + relativeUrl;
    }

    public String create(ContentEvent event, String baseUrl) {
        if (event == null) {
            return null;
        }
        if (event instanceof CommentEvent) {
            return this.create((CommentEvent)event, baseUrl);
        }
        if (event instanceof PageEvent) {
            return this.create((PageEvent)event, baseUrl);
        }
        if (event instanceof BlogPostEvent) {
            return this.create((BlogPostEvent)event, baseUrl);
        }
        if (event instanceof AttachmentEvent) {
            return this.create((AttachmentEvent)event, baseUrl);
        }
        log.error((Object)("MicrosoftTeamsEventCreator has not implementation for " + event.getClass().toString()));
        return null;
    }

    String create(CommentEvent event, String baseUrl) {
        String title = this.makeTitle(event);
        JSONObject object = this.createGenericEvent(baseUrl, (ContentEvent)event, title);
        try {
            object.put("summary", (Object)this.textMessage(event));
            if (!(event instanceof CommentRemoveEvent)) {
                object.put("text", (Object)PayloadUtils.makeMicrosoftTeamsLink(String.format("Follow this link to see the comment %s", event.getComment().getDisplayTitle()), baseUrl + event.getComment().getUrlPath()));
                this.createActions(baseUrl + event.getComment().getUrlPath(), "View Comment", object);
            }
        }
        catch (JSONException e) {
            log.error((Object)("JSON construction error :" + e.getMessage()), (Throwable)e);
        }
        return object.toString();
    }

    String create(AttachmentEvent event, String baseUrl) {
        String title = this.makeTitle(event);
        JSONObject object = this.createGenericEvent(baseUrl, (ContentEvent)event, title);
        try {
            if (!(event instanceof AttachmentRemoveEvent)) {
                Attachment attachment = event.getAttachment();
                String triggerDisplayName = attachment.getLastModifier().getFullName();
                String username = attachment.getLastModifier().getName();
                String userLink = PayloadUtils.makeMicrosoftTeamsLink(triggerDisplayName, baseUrl + "/display/~" + username);
                object.put("text", (Object)String.format("by %s", userLink));
            }
        }
        catch (JSONException e) {
            log.error((Object)("JSON construction error :" + e.getMessage()), (Throwable)e);
        }
        return object.toString();
    }

    String create(PageEvent event, String baseUrl) {
        String title = this.makeTitle(event);
        JSONObject object = this.createGenericEvent(baseUrl, (ContentEvent)event, title);
        try {
            object.put("summary", (Object)this.textMessage(event));
            if (!(event instanceof PageRemoveEvent) && !(event instanceof PageTrashedEvent)) {
                object.put("text", (Object)PayloadUtils.makeMicrosoftTeamsLink(String.format("Follow this link to see %s", event.getPage().getDisplayTitle()), baseUrl + event.getPage().getUrlPath()));
                this.createActions(baseUrl + event.getPage().getUrlPath(), "View Page", object);
            } else {
                object.put("text", (Object)title);
            }
        }
        catch (JSONException e) {
            log.error((Object)("JSON construction error :" + e.getMessage()), (Throwable)e);
        }
        return object.toString();
    }

    String create(BlogPostEvent event, String baseUrl) {
        String title = this.makeTitle(event);
        JSONObject object = this.createGenericEvent(baseUrl, (ContentEvent)event, title);
        try {
            object.put("summary", (Object)this.textMessage(event));
            if (!(event instanceof BlogPostRemoveEvent) && !(event instanceof BlogPostTrashedEvent)) {
                object.put("text", (Object)PayloadUtils.makeMicrosoftTeamsLink(String.format("Follow this link to see %s", event.getBlogPost().getDisplayTitle()), baseUrl + event.getBlogPost().getUrlPath()));
                this.createActions(baseUrl + event.getBlogPost().getUrlPath(), "View Blog post", object);
            } else {
                object.put("text", (Object)title);
            }
        }
        catch (JSONException e) {
            log.error((Object)("JSON construction error :" + e.getMessage()), (Throwable)e);
        }
        return object.toString();
    }

    String create(CalendarEventInfo eventInfo, String baseUrl) {
        JSONObject object = new JSONObject();
        try {
            JSONObject fact;
            String triggerDisplayName = eventInfo.getTrigger().getFullName();
            String eventName = StringUtils.defaultIfBlank((String)eventInfo.getDescription(), (String)eventInfo.getName());
            String calendarTypeName = eventInfo.getTypeName();
            String operation = this.getCalendarOperation(eventInfo.getSource());
            String summary = String.format("%s %s the event %s in %s in the %s", triggerDisplayName, operation, eventName, calendarTypeName, eventInfo.getCalendarName());
            JSONObject detailsSection = new JSONObject();
            JSONArray sections = new JSONArray();
            object.put("@type", (Object)"MessageCard");
            object.put("@context", (Object)"http://schema.org/extensions");
            object.put("title", (Object)summary);
            object.put("summary", (Object)summary);
            JSONArray facts = new JSONArray();
            if (eventInfo.getTrigger() != null) {
                fact = new JSONObject();
                try {
                    String userFullName = eventInfo.getTrigger().getFullName();
                    String username = eventInfo.getTrigger().getName();
                    String userLink = PayloadUtils.makeMicrosoftTeamsLink(userFullName, baseUrl + "/display/~" + username);
                    fact.put("name", (Object)"Created by");
                    fact.put("value", (Object)userLink);
                    facts.put((Object)fact);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (StringUtils.isNotEmpty((String)eventInfo.getSpaceUrlPath())) {
                fact = new JSONObject();
                try {
                    String calendarLink = this.calendarLink(eventInfo.getSpaceUrlPath(), eventInfo.getName(), baseUrl);
                    fact.put("name", (Object)"Calendar");
                    fact.put("value", (Object)calendarLink);
                    facts.put((Object)fact);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            fact = new JSONObject();
            try {
                fact.put("name", (Object)"Invitees");
                fact.put("value", (Object)this.getUserList(eventInfo.getInvitees(), eventInfo.getTrigger(), baseUrl));
                facts.put((Object)fact);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JSONObject factDates = new JSONObject();
            try {
                factDates.put("name", (Object)"Dates");
                factDates.put("value", (Object)this.dateTimeUtil.getDates(eventInfo.getStartTime(), eventInfo.getEndTime(), eventInfo.isAllDay()));
                facts.put((Object)factDates);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            detailsSection.put("facts", (Object)facts);
            sections.put((Object)detailsSection);
            object.put("sections", (Object)sections);
        }
        catch (JSONException e) {
            log.error((Object)("JSON construction error :" + e.getMessage()), (Throwable)e);
        }
        return object.toString();
    }

    private String getCalendarOperation(Source source) {
        switch (source) {
            case CALENDAR_EVENT_UPDATED: {
                return "updated";
            }
            case CALENDAR_EVENT_DELETED: {
                return "deleted";
            }
        }
        return "created";
    }

    String create(QuestionAndAnswerEventInfo eventInfo, String baseUrl) {
        JSONObject object = new JSONObject();
        try {
            JSONObject fact;
            Space space;
            String triggerDisplayName = eventInfo.getTrigger().getFullName();
            String title = eventInfo.getQuestionType() == QuestionType.ANSWER ? triggerDisplayName + " posted an answer" : triggerDisplayName + " posted a question";
            JSONObject detailsSection = new JSONObject();
            JSONArray sections = new JSONArray();
            object.put("@type", (Object)"MessageCard");
            object.put("@context", (Object)"http://schema.org/extensions");
            object.put("title", (Object)title);
            String link = eventInfo.getTitle() != null ? PayloadUtils.makeMicrosoftTeamsLink(eventInfo.getTitle(), baseUrl + eventInfo.getUrlPath()) : PayloadUtils.makeMicrosoftTeamsLink("Click here to view", baseUrl + eventInfo.getUrlPath());
            object.put("text", (Object)link);
            JSONArray facts = new JSONArray();
            if (eventInfo.getTrigger() != null) {
                JSONObject fact2 = new JSONObject();
                try {
                    String username = eventInfo.getTrigger().getName();
                    String userLink = PayloadUtils.makeMicrosoftTeamsLink(triggerDisplayName, baseUrl + "/display/~" + username);
                    fact2.put("name", (Object)"Created by");
                    fact2.put("value", (Object)userLink);
                    facts.put((Object)fact2);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if ((space = eventInfo.getSpace()) != null) {
                fact = new JSONObject();
                try {
                    fact.put("name", (Object)"Space");
                    fact.put("value", (Object)space.getDisplayTitle());
                    facts.put((Object)fact);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (StringUtils.isNotEmpty((String)eventInfo.getAbbreviateContent())) {
                fact = new JSONObject();
                try {
                    fact.put("name", (Object)"Content");
                    fact.put("value", (Object)eventInfo.getAbbreviateContent());
                    facts.put((Object)fact);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (eventInfo.getTopics() != null && eventInfo.getTopics().size() > 0) {
                fact = new JSONObject();
                try {
                    fact.put("name", (Object)"Labels");
                    fact.put("value", (Object)String.join((CharSequence)", ", eventInfo.getTopics()));
                    facts.put((Object)fact);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            detailsSection.put("facts", (Object)facts);
            sections.put((Object)detailsSection);
            object.put("sections", (Object)sections);
        }
        catch (JSONException e) {
            log.error((Object)("JSON construction error :" + e.getMessage()), (Throwable)e);
        }
        return object.toString();
    }

    public String calendarLink(String spaceUrlPath, String calendarName, String baseUrl) {
        return PayloadUtils.makeMicrosoftTeamsLink(calendarName, MicrosoftTeamsEventCreator.absoluteUrl(spaceUrlPath + "/calendars", baseUrl));
    }

    private String getUserList(Set<ConfluenceUser> invitees, ConfluenceUser trigger, String baseUrl) {
        if (invitees.isEmpty()) {
            return "";
        }
        if (invitees.size() == 1 && invitees.iterator().next().getKey().equals((Object)trigger.getKey())) {
            return "";
        }
        List userLinks = invitees.stream().map(i -> PayloadUtils.makeMicrosoftTeamsLink(i.getFullName(), baseUrl + "/display/~" + i.getName())).collect(Collectors.toList());
        return String.join((CharSequence)", ", userLinks.subList(0, userLinks.size() - 1));
    }

    private JSONObject createGenericEvent(String baseUrl, ContentEvent event, String title) {
        JSONObject detailsSection = new JSONObject();
        JSONArray sections = new JSONArray();
        JSONObject object = new JSONObject();
        try {
            object.put("@type", (Object)"MessageCard");
            object.put("@context", (Object)"http://schema.org/extensions");
            object.put("title", (Object)title);
            JSONArray facts = this.getFacts(event, baseUrl);
            detailsSection.put("facts", (Object)facts);
            sections.put((Object)detailsSection);
            object.put("sections", (Object)sections);
        }
        catch (JSONException e) {
            log.error((Object)("JSON construction error :" + e.getMessage()), (Throwable)e);
        }
        return object;
    }

    private void createActions(String linkUrl, String caption, JSONObject object) throws JSONException {
        JSONArray actions = new JSONArray();
        JSONObject action = new JSONObject();
        action.put("@context", (Object)"http://schema.org");
        action.put("@type", (Object)"ViewAction");
        action.put("name", (Object)caption);
        JSONArray actionTargets = new JSONArray();
        actionTargets.put((Object)linkUrl);
        action.put("target", (Object)actionTargets);
        actions.put((Object)action);
        object.put("potentialAction", (Object)actions);
    }

    private JSONArray getFacts(ContentEvent event, String baseUrl) {
        String userLink;
        String username;
        String userFullName;
        JSONObject userNameFact;
        JSONArray result = new JSONArray();
        ConfluenceUser createdBy = null;
        ConfluenceUser updatedBy = null;
        ConfluenceUser deletedBy = null;
        Space space = null;
        Page content = null;
        Date lastModified = null;
        String commentValue = null;
        if (event instanceof PageEvent) {
            Page page = ((PageEvent)event).getPage();
            if (event instanceof PageCreateEvent) {
                createdBy = page.getCreator();
            } else if (event instanceof PageTrashedEvent) {
                createdBy = page.getCreator();
                deletedBy = this.getDeletedBy(event);
            } else {
                createdBy = page.getCreator();
                updatedBy = page.getLastModifier();
            }
            space = page.getSpace();
            lastModified = page.getLastModificationDate();
            content = page;
        } else if (event instanceof BlogPostEvent) {
            BlogPost blog = ((BlogPostEvent)event).getBlogPost();
            if (event instanceof BlogPostCreateEvent) {
                createdBy = blog.getCreator();
            } else if (event instanceof BlogPostTrashedEvent) {
                createdBy = blog.getCreator();
                deletedBy = this.getDeletedBy(event);
            } else {
                createdBy = blog.getCreator();
                updatedBy = blog.getLastModifier();
            }
            space = blog.getSpace();
            lastModified = blog.getLastModificationDate();
            content = blog;
        } else if (event instanceof CommentEvent) {
            Comment comment = ((CommentEvent)event).getComment();
            if (event instanceof CommentCreateEvent) {
                createdBy = comment.getCreator();
            } else {
                createdBy = comment.getCreator();
                updatedBy = comment.getLastModifier();
            }
            commentValue = StringUtils.abbreviate((String)comment.getBodyAsStringWithoutMarkup(), (int)1000);
            space = comment.getSpace();
            lastModified = comment.getLastModificationDate();
            content = comment.getContainer();
        } else if (event instanceof AttachmentEvent) {
            Attachment attachment = ((AttachmentEvent)event).getAttachment();
            if (((AttachmentEvent)event).getAttachments().size() == 1) {
                commentValue = attachment.getVersionComment();
            }
            content = ((AttachmentEvent)event).getAttachedTo();
            lastModified = attachment.getLastModificationDate();
            space = attachment.getSpace();
        }
        if (commentValue != null) {
            JSONObject commentValueFact = new JSONObject();
            try {
                commentValueFact.put("name", (Object)"Comment");
                commentValueFact.put("value", (Object)commentValue);
                result.put((Object)commentValueFact);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (deletedBy != null) {
            userNameFact = new JSONObject();
            try {
                userFullName = deletedBy.getFullName();
                username = deletedBy.getName();
                userLink = PayloadUtils.makeMicrosoftTeamsLink(userFullName, baseUrl + "/display/~" + username);
                userNameFact.put("name", (Object)"Deleted by");
                userNameFact.put("value", (Object)userLink);
                result.put((Object)userNameFact);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else if (updatedBy != null) {
            userNameFact = new JSONObject();
            try {
                userFullName = updatedBy.getFullName();
                username = updatedBy.getName();
                userLink = PayloadUtils.makeMicrosoftTeamsLink(userFullName, baseUrl + "/display/~" + username);
                userNameFact.put("name", (Object)"Updated by");
                userNameFact.put("value", (Object)userLink);
                result.put((Object)userNameFact);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (lastModified != null) {
            JSONObject lastModifiedFact = new JSONObject();
            String lastModifiedDateFormatted = this.dateTimeUtil.formatDate(lastModified);
            try {
                lastModifiedFact.put("name", (Object)"Updated at");
                lastModifiedFact.put("value", (Object)lastModifiedDateFormatted);
                result.put((Object)lastModifiedFact);
            }
            catch (JSONException e) {
                log.error((Object)("JSON construction error :" + e.getMessage()), (Throwable)e);
            }
        }
        if (createdBy != null) {
            userNameFact = new JSONObject();
            try {
                userFullName = createdBy.getFullName();
                username = createdBy.getName();
                userLink = PayloadUtils.makeMicrosoftTeamsLink(userFullName, baseUrl + "/display/~" + username);
                userNameFact.put("name", (Object)"Created by");
                userNameFact.put("value", (Object)userLink);
                result.put((Object)userNameFact);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (content != null) {
            JSONObject contentFact = new JSONObject();
            String contentLink = PayloadUtils.makeMicrosoftTeamsLink(content.getDisplayTitle(), baseUrl + content.getUrlPath());
            try {
                contentFact.put("name", (Object)"Content");
                contentFact.put("value", (Object)contentLink);
                result.put((Object)contentFact);
            }
            catch (JSONException e) {
                log.error((Object)("JSON construction error :" + e.getMessage()), (Throwable)e);
            }
        }
        if (space != null) {
            JSONObject spaceFact = new JSONObject();
            String spaceLink = PayloadUtils.makeMicrosoftTeamsLink(space.getDisplayTitle(), baseUrl + space.getUrlPath());
            try {
                spaceFact.put("name", (Object)"Space");
                spaceFact.put("value", (Object)spaceLink);
                result.put((Object)spaceFact);
            }
            catch (JSONException e) {
                log.error((Object)("JSON construction error :" + e.getMessage()), (Throwable)e);
            }
        }
        return result;
    }

    private String textMessage(CommentEvent event) {
        return event.getComment().getBodyAsString();
    }

    private String textMessage(PageEvent event) {
        return event.getPage().getExcerpt();
    }

    private String textMessage(BlogPostEvent event) {
        return event.getBlogPost().getExcerpt();
    }

    private String makeTitle(CommentEvent event) {
        if (event == null) {
            return "";
        }
        Comment comment = event.getComment();
        String username = comment.getLastModifier().getFullName();
        return String.format("A comment in the page '%s' was %s by %s", comment.getDisplayTitle(), comment.isNew() ? "created" : "updated", username);
    }

    private String makeTitle(AttachmentEvent event) {
        if (event == null) {
            return "";
        }
        ContentEntityObject attachedTo = event.getAttachedTo();
        Attachment attachment = event.getAttachment();
        return String.format("An attachment to the content '%s' was %s", attachedTo.getTitle(), attachment.isNew() ? "created" : "updated");
    }

    private String makeTitle(PageEvent event) {
        if (event == null) {
            return "";
        }
        String action = "changed";
        String username = event.getPage().getLastModifier().getFullName();
        if (event instanceof PageCreateEvent) {
            action = "created";
        } else if (event instanceof PageUpdateEvent) {
            action = "updated";
        } else if (event instanceof PageRemoveEvent || event instanceof PageTrashedEvent) {
            action = "removed";
            if (event instanceof PageTrashedEvent) {
                ConfluenceUser user = this.getDeletedBy((ContentEvent)event);
                user = user == null ? AuthenticatedUserThreadLocal.get() : user;
                username = user == null ? "Unknown" : user.getFullName();
            }
        } else if (event instanceof PageRestoreEvent) {
            action = "restored";
        }
        return String.format("Page '%s' was %s by %s.", event.getPage().getDisplayTitle(), action, username);
    }

    private String makeTitle(BlogPostEvent event) {
        if (event == null) {
            return "";
        }
        String title = event.getBlogPost().getDisplayTitle();
        String action = "changed";
        String username = event.getBlogPost().getLastModifier().getFullName();
        if (event instanceof BlogPostCreateEvent) {
            action = "created";
        } else if (event instanceof BlogPostUpdateEvent) {
            action = "updated";
        } else if (event instanceof BlogPostRemoveEvent || event instanceof BlogPostTrashedEvent) {
            action = "removed";
            if (event instanceof BlogPostTrashedEvent) {
                ConfluenceUser user = this.getDeletedBy((ContentEvent)event);
                user = user == null ? AuthenticatedUserThreadLocal.get() : user;
                username = user == null ? "Unknown" : user.getFullName();
            }
        } else if (event instanceof BlogPostRestoreEvent) {
            action = "restored";
        }
        return String.format("Blog post '%s' was %s by %s.", title, action, username);
    }

    private ConfluenceUser getDeletedBy(ContentEvent event) {
        ConfluenceUser user = null;
        if (event instanceof PageTrashedEvent) {
            user = (ConfluenceUser)((PageTrashedEvent)event).getOriginatingUser();
        } else if (event instanceof BlogPostTrashedEvent) {
            user = (ConfluenceUser)((BlogPostTrashedEvent)event).getOriginatingUser();
        }
        return user;
    }
}

