/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.util;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class ThreadUtils {
    private static final Logger log = LoggerFactory.getLogger(ThreadUtils.class);
    public static final int DEFAULT_POOL_SIZE = 20;
    public static final String THREAD_POOL_SIZE = "moveworkforward.pool.size";

    public static ThreadPoolExecutor createExecutorService(Environment environment, final String threadName) {
        int poolSize = ThreadUtils.getPoolSize(environment);
        log.info("Creating ExecutorService, thread name: {}, pool size: {}", (Object)threadName, (Object)poolSize);
        return new ThreadPoolExecutor(0, poolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            final AtomicInteger threadNumber = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, threadName + this.threadNumber.getAndIncrement() + "-thread");
            }
        });
    }

    public static int getPoolSize(Environment environment) {
        int possibleThreads = Runtime.getRuntime().availableProcessors() * 2;
        log.debug("Suggested threads for available cores: {}", (Object)possibleThreads);
        possibleThreads = Math.max(20, possibleThreads);
        log.debug("Default pool size {}", (Object)20);
        int poolSize = (Integer)environment.getProperty(THREAD_POOL_SIZE, Integer.class, (Object)possibleThreads);
        log.debug("Chosen pool size: {}", (Object)poolSize);
        return poolSize;
    }
}

