/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageCard {
    protected JSONObject card = new JSONObject();
    protected JSONArray facts = new JSONArray();
    protected JSONArray actions = new JSONArray();
    protected JSONArray sections = new JSONArray();

    public MessageCard() throws JSONException {
        this.card.put("@type", (Object)"MessageCard");
        this.card.put("@context", (Object)"http://schema.org/extensions");
    }

    public void setSummary(String summary) throws JSONException {
        this.card.put("summary", (Object)summary);
    }

    public void setTitle(String title) throws JSONException {
        this.card.put("title", (Object)title);
    }

    public void setText(String text) throws JSONException {
        this.card.put("text", (Object)text);
    }

    public void addViewAction(String name, String target) throws JSONException {
        this.addAction("ViewAction", name, target);
    }

    private void addAction(String type, String name, String target) throws JSONException {
        JSONObject action = new JSONObject();
        action.put("@type", (Object)type);
        action.put("name", (Object)name);
        action.put("@context", (Object)"http://schema.org");
        JSONArray actionTargets = new JSONArray();
        actionTargets.put((Object)target);
        action.put("target", (Object)actionTargets);
        this.actions.put((Object)action);
    }

    public void addFact(String name, String value) throws JSONException {
        if (name == null || value == null) {
            return;
        }
        JSONObject fact = new JSONObject();
        fact.put("name", (Object)name);
        fact.put("value", (Object)value);
        this.facts.put((Object)fact);
    }

    public void addSection(JSONArray section) throws JSONException {
        this.card.put("sections", (Object)this.sections);
    }

    public String convertToString() throws JSONException {
        return this.card.toString();
    }
}

