/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.components;

import com.atlassian.confluence.core.AbstractVersionedEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.moveworkforward.confluence.microsoftteams.notifier.actions.Source;
import com.moveworkforward.confluence.microsoftteams.notifier.api.EventNotifier;
import com.moveworkforward.confluence.microsoftteams.notifier.components.MicrosoftTeamsEventCreator;
import com.moveworkforward.confluence.microsoftteams.notifier.components.MicrosoftTeamsNotificationTransport;
import com.moveworkforward.confluence.microsoftteams.notifier.configuration.LicenseManager;
import com.moveworkforward.confluence.microsoftteams.notifier.model.CalendarEventInfo;
import com.moveworkforward.confluence.microsoftteams.notifier.model.Configuration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ConfluenceGlobalSettings;
import com.moveworkforward.confluence.microsoftteams.notifier.model.MatchingStrategy;
import com.moveworkforward.confluence.microsoftteams.notifier.model.NotificationFilters;
import com.moveworkforward.confluence.microsoftteams.notifier.model.QuestionAndAnswerEventInfo;
import com.moveworkforward.confluence.microsoftteams.notifier.model.QuestionType;
import com.moveworkforward.confluence.microsoftteams.notifier.services.ConfigurationServiceImpl;
import com.moveworkforward.confluence.microsoftteams.notifier.services.GlobalSettingsService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.UrlConfigurationServiceImpl;
import com.moveworkforward.confluence.microsoftteams.notifier.services.UserService;
import com.moveworkforward.confluence.microsoftteams.notifier.util.MessageAuditUtil;
import com.moveworkforward.confluence.microsoftteams.notifier.util.PayloadUtils;
import com.moveworkforward.confluence.microsoftteams.notifier.util.ThreadUtils;
import com.moveworkforward.model.MessageAudit;
import com.moveworkforward.service.MessageAuditService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class EventNotifierImpl
implements EventNotifier,
LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(EventNotifierImpl.class);
    public static final boolean DO_NOT_CHECK_PERMISSIONS = false;
    private static final int DEFAULT_POOL_SIZE = 20;
    private final MicrosoftTeamsEventCreator microsoftTeamsEventCreator;
    private final MicrosoftTeamsNotificationTransport notificationTransport;
    private final ConfigurationServiceImpl configurationService;
    private final UrlConfigurationServiceImpl urlConfigurationService;
    private final LicenseManager licenseManager;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final SpaceManager spaceManager;
    private final UserService userService;
    private final MessageAuditService messageAuditService;
    private final GlobalSettingsService globalSettingsService;
    private final ExecutorService executor;

    @Inject
    public EventNotifierImpl(MicrosoftTeamsEventCreator microsoftTeamsEventCreator, MicrosoftTeamsNotificationTransport notificationTransport, ConfigurationServiceImpl configurationService, UrlConfigurationServiceImpl urlConfigurationService, LicenseManager licenseManager, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport SpaceManager spaceManager, UserService userService, MessageAuditService messageAuditService, GlobalSettingsService globalSettingsService, Environment environment) {
        this.microsoftTeamsEventCreator = microsoftTeamsEventCreator;
        this.notificationTransport = notificationTransport;
        this.configurationService = configurationService;
        this.urlConfigurationService = urlConfigurationService;
        this.licenseManager = licenseManager;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.spaceManager = spaceManager;
        this.userService = userService;
        this.messageAuditService = messageAuditService;
        this.globalSettingsService = globalSettingsService;
        this.executor = ThreadUtils.createExecutorService(environment, "moveworkforward-microsoftteams-conf-notification-");
    }

    public static boolean isAllowed(ConfluenceGlobalSettings globalSettings, String spaceKey) {
        if (globalSettings.isAppDisabledInEntities() && CollectionUtils.isEmpty((Collection)globalSettings.getIgnoredKeys())) {
            log.debug("Global settings disabled in entities and ignored keys empty");
            return false;
        }
        if (globalSettings.isAppEnabledInEntitites()) {
            if (!(CollectionUtils.isEmpty((Collection)globalSettings.getAllowedKeys()) || "05f11044-da77-41a8-ac66-a9388ffd0925".equals(spaceKey) || globalSettings.getAllowedKeys().contains(spaceKey))) {
                log.debug("Global settings allowed space keys {} do not contain {}", (Object)globalSettings.getAllowedKeys(), (Object)spaceKey);
                return false;
            }
            if (!CollectionUtils.isEmpty((Collection)globalSettings.getIgnoredKeys()) && !"05f11044-da77-41a8-ac66-a9388ffd0925".equals(spaceKey) && globalSettings.getIgnoredKeys().contains(spaceKey)) {
                log.debug("Global settings allowed space keys {} contain {}", (Object)globalSettings.getIgnoredKeys(), (Object)spaceKey);
                return false;
            }
        }
        return true;
    }

    public void onStart() {
    }

    public void onStop() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(800L, TimeUnit.MILLISECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
    }

    @Override
    public void notify(CommentEvent event) {
        log.debug(">>>>>>> CommentEvent >>>>>>>>>> " + event);
        if (!this.licenseManager.isLicensed()) {
            return;
        }
        ContentEntityObject page = event.getComment().getContainer();
        if (!page.isPersistent()) {
            log.info("Page has not been persisted. Don't notify");
            return;
        }
        MessageAudit messageAudit = MessageAuditUtil.createMessageAudit(event);
        try {
            String spaceKey = event.getComment().getSpace().getKey();
            String path = page.getUrlPath();
            ConfluenceUser actor = this.getActor((AbstractVersionedEntityObject)event.getComment());
            List labels = page.getLabels();
            Page parentFilterPage = null;
            if (page instanceof Page) {
                parentFilterPage = (Page)page;
            }
            this.processEvent((ContentEvent)event, actor, spaceKey, path, labels, parentFilterPage, messageAudit);
        }
        catch (Exception e) {
            this.saveAudit(e, messageAudit);
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void notify(PageEvent event) {
        log.debug(">>>>>>> PageEvent >>>>>>>>>> " + event);
        if (!this.licenseManager.isLicensed()) {
            return;
        }
        Page page = event.getPage();
        if (!page.isPersistent()) {
            log.info("Page has not been persisted. Don't notify");
            return;
        }
        MessageAudit messageAudit = MessageAuditUtil.createMessageAudit(event);
        try {
            String spaceKey = page.getSpaceKey();
            String path = page.getUrlPath();
            ConfluenceUser actor = this.getActor((ContentEvent)event);
            List labels = page.getLabels();
            this.processEvent((ContentEvent)event, actor, spaceKey, path, labels, page, messageAudit);
        }
        catch (Exception e) {
            this.saveAudit(e, messageAudit);
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void notify(BlogPostEvent event) {
        log.debug(">>>>>>> BlogPostEvent >>>>>>>>>> + " + event);
        if (!this.licenseManager.isLicensed()) {
            return;
        }
        BlogPost page = event.getBlogPost();
        if (!page.isPersistent()) {
            log.info("Page has not been persisted. Don't notify");
            return;
        }
        MessageAudit messageAudit = MessageAuditUtil.createMessageAudit(event);
        try {
            String spaceKey = page.getSpaceKey();
            String path = page.getUrlPath();
            ConfluenceUser actor = this.getActor((ContentEvent)event);
            List labels = page.getLabels();
            this.processEvent((ContentEvent)event, actor, spaceKey, path, labels, null, messageAudit);
        }
        catch (Exception e) {
            this.saveAudit(e, messageAudit);
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void notify(AttachmentEvent event) {
        log.debug(">>>>>>> AttachmentEvent >>>>>>>>>> + " + event);
        if (!this.licenseManager.isLicensed()) {
            return;
        }
        ContentEntityObject page = event.getAttachedTo();
        if (!page.isPersistent()) {
            log.info("Page has not been persisted. Don't notify");
            return;
        }
        MessageAudit messageAudit = MessageAuditUtil.createMessageAudit(event);
        try {
            Attachment attachment = event.getAttachment();
            Space space = attachment.getSpace();
            String spaceKey = space.getKey();
            String path = page.getUrlPath();
            Page parentFilterPage = null;
            if (page instanceof Page) {
                parentFilterPage = (Page)page;
            }
            ConfluenceUser actor = attachment.getLastModifier();
            List labels = page.getLabels();
            this.processEvent((ContentEvent)event, actor, spaceKey, path, labels, parentFilterPage, messageAudit);
        }
        catch (Exception e) {
            this.saveAudit(e, messageAudit);
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private ConfluenceUser getActor(ContentEvent event) {
        ConfluenceUser actor = null;
        actor = event instanceof PageTrashedEvent ? (ConfluenceUser)((PageTrashedEvent)event).getOriginatingUser() : (event instanceof BlogPostTrashedEvent ? (ConfluenceUser)((BlogPostTrashedEvent)event).getOriginatingUser() : this.getActor((AbstractVersionedEntityObject)event.getContent()));
        if (actor == null) {
            log.debug("Can't get actor from: {}", (Object)event.getContent());
            actor = AuthenticatedUserThreadLocal.get();
        }
        return actor;
    }

    private ConfluenceUser getActor(AbstractVersionedEntityObject entityObject) {
        ConfluenceUser actor;
        ConfluenceUser confluenceUser = actor = entityObject.isNew() ? entityObject.getCreator() : entityObject.getLastModifier();
        if (actor == null) {
            log.debug("Can't get actor from: {}", (Object)entityObject);
            actor = AuthenticatedUserThreadLocal.get();
        }
        return actor;
    }

    @Override
    public void notifyCalendarEvent(CalendarEventInfo event) {
        log.debug(">>>>>>> CalendarEventInfo >>>>>>>>>> + " + event);
        if (!this.licenseManager.isLicensed()) {
            return;
        }
        this.executor.execute(() -> this.processCalendarEvent(event));
    }

    @Override
    public void notifyQuestionAndAnswerEvent(QuestionAndAnswerEventInfo event) {
        log.debug(">>>>>>> QuestionAndAnswerEventInfo >>>>>>>>>> + " + event);
        if (!this.licenseManager.isLicensed()) {
            return;
        }
        MessageAudit messageAudit = MessageAuditUtil.createMessageAudit(event);
        try {
            String spaceKey = event.getSpace() != null ? event.getSpace().getKey() : "f94a2448-696d-4d81-ae30-4e2054daf97f";
            ConfluenceUser actor = event.getTrigger();
            ConfluenceGlobalSettings globalSettings = (ConfluenceGlobalSettings)this.globalSettingsService.get(false);
            List configurations = this.configurationService.getAll(false);
            Source source = event.getQuestionType() == QuestionType.ANSWER ? Source.ANSWER_CREATED : Source.QUESTION_CREATED;
            Set<Configuration> channels = configurations.stream().filter(Configuration::isEnabled).filter(x -> this.filterBySource(source, (Configuration)((Object)x))).filter(x -> this.filterBySpace(spaceKey, (Configuration)((Object)x))).filter(x -> this.filterByActor(actor, (Configuration)((Object)x))).filter(x -> this.filterByGlobalSettings(globalSettings, (Configuration)((Object)x))).filter(x -> this.filterByTopics(event.getTopics(), (Configuration)((Object)x))).collect(Collectors.toSet());
            if (channels.size() > 0) {
                String message = this.microsoftTeamsEventCreator.create(event, this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE));
                this.sendToMicrosoft(channels, message, source, messageAudit);
            } else {
                log.debug("There are no rules matching the event.");
            }
        }
        catch (Exception e) {
            this.saveAudit(e, messageAudit);
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean filterByTopics(List<String> topics, Configuration x) {
        NotificationFilters notificationFilters = x.getConfiguration().getFilters();
        log.debug("filterByTopics for topics[{}]", (Object)String.join((CharSequence)"||", topics));
        return this.filterByLabels(topics, notificationFilters.getTopics(), notificationFilters.getTopicMatchingStrategy());
    }

    private void saveAudit(Exception e, MessageAudit messageAudit) {
        Optional.ofNullable(messageAudit).ifPresent(m -> m.setException(e));
        this.messageAuditService.save(messageAudit);
    }

    private void processEvent(ContentEvent event, ConfluenceUser actor, String spaceKey, String path, List<Label> labels, Page page, MessageAudit messageAudit) throws Exception {
        List configurations = this.configurationService.getAll(false);
        ConfluenceGlobalSettings globalSettings = (ConfluenceGlobalSettings)this.globalSettingsService.get(false);
        Source source = Source.getSource(event);
        Set<Configuration> channels = configurations.stream().filter(Configuration::isEnabled).filter(x -> this.filterBySource(source, (Configuration)((Object)x))).filter(x -> this.filterBySpace(spaceKey, (Configuration)((Object)x))).filter(x -> this.filterByActor(actor, (Configuration)((Object)x))).filter(x -> this.filterByLabels(labels, (Configuration)((Object)x))).filter(x -> this.filterByPathFilter(path, (Configuration)((Object)x))).filter(x -> this.filterByParentPage(page, (Configuration)((Object)x))).filter(x -> this.filterByGlobalSettings(globalSettings, (Configuration)((Object)x))).collect(Collectors.toSet());
        if (channels.size() > 0) {
            String message = this.microsoftTeamsEventCreator.create(event, this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE));
            this.sendToMicrosoft(channels, message, source, messageAudit);
        } else {
            log.debug("There are no rules matching the event.");
        }
    }

    private void processCalendarEvent(CalendarEventInfo event) {
        MessageAudit messageAudit = MessageAuditUtil.createMessageAudit(event);
        try {
            String spaceKey = event.getSpaceKey();
            ConfluenceUser actor = event.getTrigger();
            List configurations = this.configurationService.getAll(false);
            ConfluenceGlobalSettings globalSettings = (ConfluenceGlobalSettings)this.globalSettingsService.get(false);
            Source source = event.getSource();
            Set<Configuration> channels = configurations.stream().filter(Configuration::isEnabled).filter(x -> this.filterBySource(source, (Configuration)((Object)x))).filter(x -> this.filterBySpace(spaceKey, (Configuration)((Object)x))).filter(x -> this.filterByActor(actor, (Configuration)((Object)x))).filter(x -> this.filterByGlobalSettings(globalSettings, (Configuration)((Object)x))).collect(Collectors.toSet());
            if (channels.size() > 0) {
                Space space = this.spaceManager.getSpace(event.getSpaceKey());
                if (space != null) {
                    event.setSpaceUrlPath(space.getUrlPath());
                }
                this.sendToMicrosoft(channels, this.microsoftTeamsEventCreator.create(event, this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE)), source, messageAudit);
            } else {
                log.debug("There are no rules matching the event.");
            }
        }
        catch (Exception e) {
            this.saveAudit(e, messageAudit);
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean filterByParentPage(Page page, Configuration x) {
        Page currentPage;
        String parentPageIdFilter = x.getConfiguration().getFilters().getParentPageId();
        if (page == null || parentPageIdFilter == null || StringUtils.isBlank((String)parentPageIdFilter)) {
            log.debug("Parent page id filter is not set.");
            return true;
        }
        for (currentPage = page; currentPage != null && !parentPageIdFilter.equals(currentPage.getIdAsString()); currentPage = currentPage.getParent()) {
        }
        boolean result = currentPage != null;
        log.debug("Parent page filter result {}", (Object)result);
        return result;
    }

    private boolean filterByActor(ConfluenceUser actor, Configuration x) {
        Collection<ConfluenceUser> excludeUsers;
        boolean foundInExcludedGroups;
        Collection<ConfluenceUser> includeUsers;
        boolean foundInIncludedGroups;
        boolean result = true;
        if (actor == null) {
            log.warn("Actor is undefined");
            return result;
        }
        String actorUserKey = actor.getKey().getStringValue();
        List<String> includeUserKeys = x.getConfiguration().getFilters().getIncludeUserKeys();
        List<String> excludeUserKeys = x.getConfiguration().getFilters().getExcludeUserKeys();
        List<String> includeGroupNames = x.getConfiguration().getFilters().getIncludeGroupNames();
        List<String> excludeGroupNames = x.getConfiguration().getFilters().getExcludeGroupNames();
        if (includeUserKeys.size() > 0 && !includeUserKeys.contains(actorUserKey)) {
            log.debug("includeUserKeys has values, but does not have {}", (Object)actorUserKey);
            result = false;
        }
        if (excludeUserKeys.size() > 0 && excludeUserKeys.contains(actorUserKey)) {
            log.debug("excludeUserKeys has values and it has the actor {}", (Object)actorUserKey);
            result = false;
        }
        if (includeGroupNames.size() > 0 && !(foundInIncludedGroups = (includeUsers = this.userService.getUsersByKeysAndGroups(new ArrayList<String>(), includeGroupNames)).stream().anyMatch(u -> u.getKey().getStringValue().equalsIgnoreCase(actorUserKey)))) {
            log.debug("includeGroupNames has values and those groups DO NOT have the actor {}", (Object)actorUserKey);
            result = false;
        }
        if (excludeGroupNames.size() > 0 && (foundInExcludedGroups = (excludeUsers = this.userService.getUsersByKeysAndGroups(new ArrayList<String>(), excludeGroupNames)).stream().anyMatch(u -> u.getKey().getStringValue().equalsIgnoreCase(actorUserKey)))) {
            log.debug("excludeGroupNames has values and those groups have the actor {}", (Object)actorUserKey);
            result = false;
        }
        return result;
    }

    private boolean filterBySpace(String spaceKey, Configuration x) {
        String configSpaceKey = x.getSpaceKey();
        boolean result = configSpaceKey.equals(spaceKey) || configSpaceKey.equals("05f11044-da77-41a8-ac66-a9388ffd0925");
        log.debug("filterBySpace result {}, spaceKey[{}] x.getTag()[{}]", new Object[]{result, spaceKey, configSpaceKey});
        return result;
    }

    private boolean filterBySource(Source source, Configuration x) {
        boolean result = x.getEvents() != null && x.getEvents().contains((Object)source);
        log.debug("filterBySource result {}, source[{}], x.getEvents()[{}]", new Object[]{result, source, x.getEvents()});
        return result;
    }

    private boolean filterByLabels(List<Label> labels, Configuration x) {
        List<String> labelNames = labels.stream().map(Label::getName).collect(Collectors.toList());
        NotificationFilters notificationFilters = x.getConfiguration().getFilters();
        return this.filterByLabels(labelNames, notificationFilters.getLabels(), notificationFilters.getLabelMatchingStrategy());
    }

    private boolean filterByLabels(List<String> labels, List<String> filterLabels, MatchingStrategy matchingStrategy) {
        boolean result = true;
        if (filterLabels.isEmpty()) {
            log.debug("filterByLabels (filterLabels.isEmpty()) result is true");
            return true;
        }
        if (matchingStrategy == MatchingStrategy.ALL) {
            result = filterLabels.stream().allMatch(filterLabel -> labels.stream().anyMatch(l -> l.equalsIgnoreCase((String)filterLabel)));
        } else if (matchingStrategy == MatchingStrategy.ANY) {
            result = filterLabels.stream().anyMatch(filterLabel -> labels.stream().anyMatch(l -> l.equalsIgnoreCase((String)filterLabel)));
        }
        log.debug("matchingStrategy[{}] result[{}] labels[{}] filterLabels[{}]", new Object[]{matchingStrategy, result, String.join((CharSequence)"||", labels), String.join((CharSequence)"||", filterLabels)});
        return result;
    }

    private boolean filterByPathFilter(String path, Configuration x) {
        boolean result = x.getPathFilter() == null || x.getPathFilter().trim().length() == 0 || path.contains(x.getPathFilter().trim());
        log.debug("filterByPathFilter path[{}] result[{}]", (Object)path, (Object)result);
        return result;
    }

    protected boolean filterByGlobalSettings(ConfluenceGlobalSettings globalSettings, Configuration x) {
        return EventNotifierImpl.isAllowed(globalSettings, x.getSpaceKey());
    }

    private void sendToMicrosoft(Collection<Configuration> configurations, String message, Source source, MessageAudit originalMessageAudit) {
        if (StringUtils.isBlank((String)message) || configurations.isEmpty()) {
            log.debug("Nothing to send, channels {}, message {}", (Object)configurations.size(), (Object)message);
            return;
        }
        log.debug("msTeamsEvent message: " + message);
        String minimalMessage = null;
        HashSet<ImmutablePair> sendInfo = new HashSet<ImmutablePair>();
        for (Configuration configuration : configurations) {
            ImmutablePair sendData;
            String url = this.urlConfigurationService.resolveUrl(configuration.getDestination());
            if (StringUtils.isBlank((String)url)) {
                log.info("URL is empty, can't send payload");
                this.messageAuditService.save(this.configurationMessageAudit(originalMessageAudit, configuration, url));
                continue;
            }
            String contentToSend = message;
            if (configuration.isMinimalContent()) {
                contentToSend = minimalMessage = minimalMessage == null ? PayloadUtils.toMinimalMessage(message, source) : minimalMessage;
                log.debug("Switching to minimal content for url: {}", (Object)url);
            }
            if (!sendInfo.add(sendData = ImmutablePair.of((Object)url, (Object)contentToSend))) {
                log.debug("Message has already been sent to the URL '{}'", (Object)url);
                continue;
            }
            log.debug("Sending notifications to " + url);
            this.executor.execute(this.notificationTransport.sendNotification(url, contentToSend, this.configurationMessageAudit(originalMessageAudit, configuration, url)));
        }
    }

    private MessageAudit configurationMessageAudit(MessageAudit messageAudit, Configuration configuration, String url) {
        if (messageAudit == null) {
            return null;
        }
        return messageAudit.toBuilder().configuration(new MessageAudit.Configuration(configuration.getId(), configuration.getName(), url)).error(StringUtils.isBlank((String)url) ? "URL configuration is not found or URL is empty" : null).build();
    }
}

