/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence.helper;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class AttachmentHelper {
    public static final String VERSION_FILE = "META-INF/version.properties";
    private static final String VERSION_STRING = "version=1.2";
    public static final String MACRO_PROPERTIES_FILE = "META-INF/macro.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getZipData(String graphml, String image, String customData, String palettes, String macroProperties) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream out = new ZipOutputStream(baos);){
            AttachmentHelper.writeEntry(out, VERSION_FILE, VERSION_STRING);
            AttachmentHelper.writeEntry(out, MACRO_PROPERTIES_FILE, macroProperties);
            AttachmentHelper.writeEntry(out, "diagram.graphml", graphml);
            AttachmentHelper.writeEntry(out, "diagram.svg", image);
            AttachmentHelper.writeEntry(out, "CustomData.json", customData);
            if (palettes != null && palettes.length() > 0) {
                AttachmentHelper.writeEntry(out, "Palettes.json", palettes);
            }
        }
        return baos.toByteArray();
    }

    private static void writeEntry(ZipOutputStream out, String name, String text) throws IOException {
        ZipEntry entry = new ZipEntry(name);
        out.putNextEntry(entry);
        AttachmentHelper.write(out, text);
        out.closeEntry();
    }

    private static void write(OutputStream os, String text) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new Guard(os), StandardCharsets.UTF_8));){
            bw.write(text);
        }
    }

    public static void write(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[8192];
        int read = is.read(buffer);
        while (read > -1) {
            os.write(buffer, 0, read);
            read = is.read(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getEntry(String entryName, InputStream is) throws IOException {
        byte[] result = new byte[]{};
        try (ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (entryName.equals(entry.getName())) {
                    result = AttachmentHelper.readEntry(zis);
                    break;
                }
                entry = zis.getNextEntry();
            }
        }
        return result;
    }

    private static byte[] readEntry(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AttachmentHelper.write(is, baos);
        return baos.toByteArray();
    }

    public static String getValidFileName(String fileName) {
        String fileExtension;
        if (fileName == null) {
            return null;
        }
        int index = -1;
        if (fileName.endsWith(".svg") || fileName.endsWith(".graphml") || fileName.endsWith(".png") || fileName.endsWith(".json") || fileName.endsWith(".zip")) {
            index = fileName.lastIndexOf(".");
        }
        String string = fileExtension = index > 0 ? fileName.substring(index) : "";
        if (!fileExtension.equals("")) {
            fileName = fileName.substring(0, index);
        }
        fileName = fileName.replaceAll("[./\\\\\"<>?*&|:]", "_");
        byte[] utf8Bytes = fileName.getBytes(StandardCharsets.UTF_8);
        int maxAllowedFileNameLength = 200;
        if (utf8Bytes.length > 200) {
            CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.IGNORE);
            ByteBuffer buffer = ByteBuffer.wrap(utf8Bytes, 0, 200);
            try {
                CharBuffer decoded = decoder.decode(buffer);
                fileName = new String(decoded.array());
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
        }
        return fileName + fileExtension;
    }

    public static String getPngDataUri(InputStream attachmentData, String entryName, double imageWidth, double imageHeight) {
        try {
            byte[] data = AttachmentHelper.getEntry(entryName, attachmentData);
            if (data.length > 0) {
                return "data:image/png;base64," + AttachmentHelper.writePng(new ByteArrayInputStream(data), imageWidth, imageHeight);
            }
            return "data:image/png,";
        }
        catch (IOException e) {
            return "data:image/png,";
        }
    }

    public static String getSvgDataUri(InputStream attachmentData, String entryName) {
        try {
            byte[] data = AttachmentHelper.getEntry(entryName, attachmentData);
            if (data.length > 0) {
                return "data:image/svg+xml;base64," + Base64.getEncoder().encodeToString(data);
            }
            return "data:image/svg+xml,";
        }
        catch (IOException e) {
            return "data:image/svg+xml,";
        }
    }

    public static String getPngDataUri(InputStream attachmentData) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            AttachmentHelper.write(attachmentData, byteArrayOutputStream);
            byte[] data = byteArrayOutputStream.toByteArray();
            if (data.length > 0) {
                return "data:image/png;base64," + Base64.getEncoder().encodeToString(data);
            }
            return "data:image/png,";
        }
        catch (IOException e) {
            return "data:image/png,";
        }
    }

    private static String writePng(InputStream svgInputStream, double imageWidth, double imageHeight) throws IOException {
        float height;
        float width;
        ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
        double ratio = imageWidth / imageHeight;
        if (imageWidth >= imageHeight) {
            width = 2048.0f;
            height = (float)((double)width / ratio);
        } else {
            height = 2048.0f;
            width = (float)((double)height * ratio);
        }
        try {
            PNGTranscoder transcoder = new PNGTranscoder();
            transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
            transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
            transcoder.transcode(new TranscoderInput(svgInputStream), new TranscoderOutput((OutputStream)pngOutputStream));
            return Base64.getEncoder().encodeToString(pngOutputStream.toByteArray());
        }
        catch (TranscoderException e) {
            throw new IOException("Unable to convert svg string to image");
        }
    }

    public static byte[] readAttachmentData(InputStream attachmentData) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AttachmentHelper.write(attachmentData, baos);
        return baos.toByteArray();
    }

    private static final class Guard
    extends OutputStream {
        private final OutputStream os;

        Guard(OutputStream os) {
            this.os = os;
        }

        @Override
        public void write(int b) throws IOException {
            this.os.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.os.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

