/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.mail.ConfluenceMailServerManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.Group;
import com.atlassian.user.impl.DefaultGroup;
import com.yworks.plugins.confluence.AdminAction;
import com.yworks.plugins.confluence.SaveDiagramServlet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendErrorReportServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SaveDiagramServlet.class);
    private final BandanaManager bandanaManager;
    private final UserAccessor userAccessor;
    private final LocalNotificationService notificationService;

    public SendErrorReportServlet(@ComponentImport BandanaManager bandanaManager, @ComponentImport UserAccessor userAccessor, @ComponentImport LocalNotificationService notificationService) {
        this.bandanaManager = bandanaManager;
        this.userAccessor = userAccessor;
        this.notificationService = notificationService;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String message = req.getParameter("message");
        if (this.shouldSendEmail()) {
            this.sendEmail(message);
        }
        if (this.shouldSendNotifications()) {
            this.sendNotifications(message);
        }
    }

    private boolean shouldSendEmail() {
        HashMap<String, String> adminSettings = AdminAction.getAdminSettings(this.bandanaManager);
        String property = adminSettings.get("errorReportingEmail");
        return Boolean.parseBoolean(property);
    }

    private void sendEmail(String message) {
        Object component = ContainerManager.getComponent((String)"mailServerManager");
        ConfluenceMailServerManager mailServerManager = (ConfluenceMailServerManager)component;
        SMTPMailServer mailServer = mailServerManager.getDefaultSMTPMailServer();
        if (mailServer != null) {
            ArrayList<String> emailAddresses = this.getEmailAddresses();
            for (String emailAddress : emailAddresses) {
                Email email = new Email(emailAddress);
                if (message != null) {
                    email.setSubject("Error Report: Graphity - Diagram editor plugin for Confluence");
                    email.setBody(message);
                } else {
                    log.error("Empty error message");
                }
                try {
                    mailServer.send(email);
                }
                catch (MailException e) {
                    log.error(e.getMessage());
                }
            }
        } else {
            log.error("No mail server specified");
        }
    }

    private ArrayList<String> getEmailAddresses() {
        HashMap<String, String> adminSettings = AdminAction.getAdminSettings(this.bandanaManager);
        String emailAddresses = adminSettings.get("errorReportingEmailAddresses");
        String[] addresses = new String[]{};
        if (emailAddresses != null) {
            addresses = emailAddresses.split(",");
        }
        ArrayList<String> validEmailAddresses = new ArrayList<String>();
        for (String emailAddress : addresses) {
            if (SendErrorReportServlet.isValidEmailAddress(emailAddress = emailAddress.trim())) {
                validEmailAddresses.add(emailAddress);
                continue;
            }
            log.error("Invalid email address");
        }
        return validEmailAddresses;
    }

    private static boolean isValidEmailAddress(String emailAddress) {
        Pattern pattern = Pattern.compile("^((([^<>()[\\\\]\\.,;:\\s@\"]+(\\.[^<>()[\\\\]\\.,;:\\s@\"]+)*)|(\".+\"))@(([[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}])|(([a-zA-Z0-9]+\\.)+[a-zA-Z]{2,})))$");
        Matcher matcher = pattern.matcher(emailAddress);
        return matcher.matches();
    }

    private boolean shouldSendNotifications() {
        HashMap<String, String> adminSettings = AdminAction.getAdminSettings(this.bandanaManager);
        String property = adminSettings.get("errorReportingNotifications");
        return Boolean.parseBoolean(property);
    }

    private void sendNotifications(String message) {
        List<String> memberNames = this.getUserNames();
        for (String memberName : memberNames) {
            try {
                this.notificationService.createOrUpdate(memberName, new NotificationBuilder().application("com.yworks.plugins.confluence.graphity").title("Error Report: Graphity").itemTitle("Error Report: Graphity").description(message).groupingId("com.yworks.plugins.confluence.graphity.notification").createNotification()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error(e.getMessage());
            }
        }
    }

    private List<String> getUserNames() {
        String userNames;
        HashMap<String, String> adminSettings = AdminAction.getAdminSettings(this.bandanaManager);
        if (Boolean.parseBoolean(adminSettings.get("errorReportingNotificationsAllAdmins"))) {
            return this.userAccessor.getMemberNamesAsList((Group)new DefaultGroup("confluence-administrators"));
        }
        if (Boolean.parseBoolean(adminSettings.get("errorReportingNotificationsSomeAdmins")) && (userNames = adminSettings.get("errorReportingNotificationsAdminNames[]")).length() > 2) {
            userNames = userNames.substring(1, userNames.length() - 1);
            userNames = userNames.replaceAll("\\s", "");
            return Arrays.asList(userNames.split(","));
        }
        return Collections.emptyList();
    }
}

