/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.content.render.xhtml.editor.macro.DefaultMacroIdSupplier;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.User;
import com.yworks.plugins.confluence.RequestData;
import com.yworks.plugins.confluence.data.GraphityMacroBody;
import com.yworks.plugins.confluence.helper.AttachmentHelper;
import com.yworks.plugins.confluence.helper.LicenseHelper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SaveDiagramServlet
extends HttpServlet {
    private static final Pattern NAMED_MACRO_PATTERN = Pattern.compile("(?xs) # we need DOTALL (?s) since the macro may be on multiple lines\n<ac:(structured-)?macro # allow both <ac:macro and <ac:structured-macro\n[^>]+ac:name=[\"'](graphity|ydiagram)[\"']\n.*? # skip forward to parameter with name='name'\n<ac:parameter[^>]ac:name=[\"']name[\"']>\n(?<diagramName>[^<]*) # capture the diagram name to compare against the one to delete\n.*? # capture the rest lazily\n(?<endTag></ac:\\1macro>) # matching end tag", 36);
    private static final Pattern MACRO_PATTERN = Pattern.compile("(?xs) # we need DOTALL (?s) since the macro may be on multiple lines\n<ac:(structured-)?macro # allow both <ac:macro and <ac:structured-macro\n[^>]+ac:name=[\"'](graphity|ydiagram)[\"']\n.*? # skip forward to parameter with name='name'\n<ac:parameter[^>]ac:name=[\"']diagramId[\"']>\n(?<diagramId>[^<]*).*?.*? # capture the rest lazily\n(?<endTag></ac:\\1macro>) # matching end tag", 36);
    private static final Pattern VERSION_PARAMETER_PATTERN = Pattern.compile("(?<attachmentVersion><ac:parameter[^>]ac:name=[\"']version[\"']>[^<]*</ac:parameter>)");
    private static final Pattern DIAGRAM_ID_PARAMETER_PATTERN = Pattern.compile("(?<diagramId><ac:parameter[^>]ac:name=[\"']diagramId[\"']>[^<]*</ac:parameter>)");
    private static final Logger log = LoggerFactory.getLogger(SaveDiagramServlet.class);
    private final AttachmentManager attachmentManager;
    private final PageManager pageManager;
    private final ContentEntityManager contentEntityManager;
    private final PermissionManager permissionManager;
    private final PluginLicenseManager pluginLicenseManager;
    private final LabelManager labelManager;
    private final TransactionTemplate transactionTemplate;
    private final Cache<String, RequestData> saveRequests;
    private final Cache<String, String> imageChunks;
    private final Cache<String, String> dataChunks;
    private final AccessModeService accessModeService;

    public SaveDiagramServlet(@ComponentImport AttachmentManager attachmentManager, @ComponentImport PageManager pageManager, @ComponentImport PermissionManager permissionManager, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport LabelManager labelManager, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport CacheManager cacheManager, @ComponentImport AccessModeService accessModeService) {
        this.attachmentManager = attachmentManager;
        this.pageManager = pageManager;
        this.contentEntityManager = pageManager;
        this.permissionManager = permissionManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.labelManager = labelManager;
        this.transactionTemplate = transactionTemplate;
        this.saveRequests = cacheManager.getCache(SaveDiagramServlet.class.getName() + ".request-data.cache", null, new CacheSettingsBuilder().unflushable().expireAfterWrite(10L, TimeUnit.MINUTES).build());
        this.imageChunks = cacheManager.getCache(SaveDiagramServlet.class.getName() + ".image-chunk.cache", null, new CacheSettingsBuilder().unflushable().expireAfterWrite(10L, TimeUnit.MINUTES).build());
        this.dataChunks = cacheManager.getCache(SaveDiagramServlet.class.getName() + ".data-chunk.cache", null, new CacheSettingsBuilder().unflushable().expireAfterWrite(10L, TimeUnit.MINUTES).build());
        this.accessModeService = accessModeService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LicenseHelper licenseHelper = new LicenseHelper(this.pluginLicenseManager);
        if (!licenseHelper.isValidLicense()) {
            this.sendResponse(resp, "error", "License Error: " + licenseHelper.getErrorString(), null);
            return;
        }
        String requestId = req.getParameter("requestId");
        String requestType = req.getParameter("type");
        if ("CLONE".equalsIgnoreCase(requestType)) {
            RequestData data = this.initializeRequestData(req);
            this.cloneDiagram(data, resp);
            return;
        }
        if ("CONFLICTS".equalsIgnoreCase(requestType)) {
            RequestData data = this.initializeRequestData(req);
            this.checkForConflicts(data, resp);
            return;
        }
        if ("HEADER".equalsIgnoreCase(requestType) || "ALL".equalsIgnoreCase(requestType)) {
            RequestData data = this.initializeRequestData(req);
            if ("ALL".equalsIgnoreCase(requestType)) {
                String graphmlParam = req.getParameter("graph");
                String imageParam = req.getParameter("image");
                if (graphmlParam == null || imageParam == null || data.name == null || data.id == null) {
                    this.sendResponse(resp, "error", "The diagram was not received. Probably the POST limit was exceeded.", null);
                    return;
                }
                this.finalizeSave(data, graphmlParam, imageParam, resp);
            } else {
                this.saveRequests.put((Object)requestId, (Object)data);
                this.sendResponse(resp, "success", "Header accepted", "\"requestId\": \"" + requestId + "\"");
            }
        } else if ("graphData".equalsIgnoreCase(requestType) || "imageData".equalsIgnoreCase(requestType)) {
            try {
                this.processChunk(req, resp, requestId, requestType);
            }
            catch (Throwable e) {
                RequestData data = this.getRequestData(requestId);
                Cache<String, String> graphBuffer = this.getChunkBuffer(true);
                Cache<String, String> imageBuffer = this.getChunkBuffer(false);
                SaveDiagramServlet.emptyCache(data.graphChunks, requestId, graphBuffer);
                SaveDiagramServlet.emptyCache(data.imageChunks, requestId, imageBuffer);
                this.saveRequests.remove((Object)requestId);
                throw e;
            }
        } else if ("FOOTER".equalsIgnoreCase(requestType)) {
            RequestData data = this.getRequestData(requestId);
            if (data == null) {
                this.sendResponse(resp, "error", "Request data for " + requestId + " missing", null);
                return;
            }
            Cache<String, String> graphBuffer = this.getChunkBuffer(true);
            Cache<String, String> imageBuffer = this.getChunkBuffer(false);
            try {
                this.finalizeSave(data, this.combineChunks(graphBuffer, requestId, data.graphChunks), this.combineChunks(imageBuffer, requestId, data.imageChunks), resp);
            }
            catch (Exception e) {
                this.sendResponse(resp, "error", e.getMessage(), null);
            }
            finally {
                SaveDiagramServlet.emptyCache(data.graphChunks, requestId, graphBuffer);
                SaveDiagramServlet.emptyCache(data.imageChunks, requestId, imageBuffer);
                this.saveRequests.remove((Object)requestId);
            }
        } else {
            this.sendResponse(resp, "error", "Unknown request type " + requestType, null);
        }
    }

    private static void emptyCache(int maxIndex, String requestId, Cache<String, String> cache) {
        for (int index = 0; index < maxIndex; ++index) {
            String key = requestId + "||" + index;
            cache.remove((Object)key);
        }
    }

    private void cloneDiagram(RequestData requestData, HttpServletResponse response) {
        String oldDiagramId = requestData.diagramId;
        if (oldDiagramId == null || oldDiagramId.isEmpty()) {
            this.sendResponse(response, "error", "No diagram id to clone.", null);
            return;
        }
        long idLong = Long.parseLong(requestData.id);
        ContentEntityObject ceo = this.contentEntityManager.getById(idLong);
        if (this.checkPermissionDenied(response, ceo)) {
            return;
        }
        String zipFileName = oldDiagramId + ".zip";
        this.transactionTemplate.execute(() -> {
            try {
                String newDiagramId = SaveDiagramServlet.generateDiagramId();
                Attachment newAttachment = null;
                String macroId = requestData.macroId;
                Attachment attachment = this.attachmentManager.getAttachment(ceo, zipFileName, requestData.version);
                if (attachment != null) {
                    byte[] data = IOUtils.toByteArray((InputStream)this.attachmentManager.getAttachmentData(attachment));
                    newAttachment = new Attachment();
                    ceo.addAttachment(newAttachment);
                    newAttachment.setVersionComment(requestData.name + " (Graphity Diagram)");
                    newAttachment.setMediaType("application/zip");
                    newAttachment.setContainer(ceo);
                    newAttachment.setFileName(newDiagramId + ".zip");
                    newAttachment.setFileSize((long)data.length);
                    this.labelManager.addLabel((Labelable)newAttachment, new Label("Graphity"));
                    this.attachmentManager.saveAttachment(newAttachment, null, (InputStream)new ByteArrayInputStream(data));
                }
                int version = newAttachment != null ? newAttachment.getVersion() : 0;
                this.updateAttachmentDiagramIdAndVersion(requestData.id, macroId, newDiagramId, version);
                this.sendSuccess(response, newDiagramId, version);
            }
            catch (Exception e) {
                this.sendResponse(response, "error", "Cloning the diagram failed: " + e.getMessage(), null);
            }
            return null;
        });
    }

    private void checkForConflicts(RequestData requestData, HttpServletResponse response) {
        this.sendResponse(response, "success", "number of duplicates", "\"duplicates\": \"" + this.findDuplicates(requestData.id, requestData.diagramId) + "\"");
    }

    private boolean checkPermissionDenied(HttpServletResponse response, ContentEntityObject ceo) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled() || !this.permissionManager.hasCreatePermission((User)AuthenticatedUserThreadLocal.get(), (Object)ceo, Attachment.class)) {
            this.sendResponse(response, "error", "You don't have write permissions.", null);
            return true;
        }
        return false;
    }

    private String combineChunks(Cache<String, String> buffer, String requestId, int maxIndex) throws Exception {
        int chunkSize = 524288;
        StringBuilder builder = new StringBuilder(chunkSize * (maxIndex + 1));
        for (int index = 0; index < maxIndex; ++index) {
            String key = requestId + "||" + index;
            String chunk = (String)buffer.get((Object)key);
            if (chunk == null) {
                throw new Exception("Chunk " + index + "missing");
            }
            builder.append(chunk);
            buffer.remove((Object)key);
        }
        return builder.toString();
    }

    private void finalizeSave(RequestData data, String graphmlParam, String imageParam, HttpServletResponse response) {
        try {
            this.updateMacroAndAttachment(data, graphmlParam, imageParam, response);
        }
        catch (Exception e) {
            log.error("Could not save Graphity data", (Throwable)e);
            this.sendResponse(response, "error", "<![CDATA[" + e.getMessage() + "]]>", null);
        }
    }

    private void processChunk(HttpServletRequest req, HttpServletResponse resp, String requestId, String requestType) {
        try {
            String chunk = req.getParameter("data");
            int index = Integer.parseInt(req.getParameter("index"));
            if (chunk == null) {
                this.sendResponse(resp, "error", "Chunk not accepted.", "\"reason\": \"No chunk data sent for " + requestType + ", index: " + index + "\"");
                return;
            }
            boolean isData = "graphData".equalsIgnoreCase(requestType);
            Cache<String, String> data = this.getChunkBuffer(isData);
            RequestData requestData = this.getRequestData(requestId);
            if (requestData == null) {
                this.sendResponse(resp, "error", "Chunk not accepted.", "\"reason\": \"Request data for " + requestId + " missing\"");
                return;
            }
            if (index < 0 || index >= (isData ? requestData.graphChunks : requestData.imageChunks)) {
                this.sendResponse(resp, "error", "Chunk not accepted.", "\"reason\": \"Invalid chunk index sent for " + requestType + ", index: " + index + "\"");
                return;
            }
            data.put((Object)(requestId + "||" + index), (Object)chunk);
            this.sendResponse(resp, "success", "Chunk accepted", "\"index\": \"" + index + "\"");
        }
        catch (Exception e) {
            this.sendResponse(resp, "error", "Chunk not accepted.", "\"reason\": \"" + e.getMessage() + "\"");
        }
    }

    private void updateMacroAndAttachment(RequestData data, String graphmlParam, String imageParam, HttpServletResponse response) {
        this.transactionTemplate.execute(() -> {
            boolean hasId = data.diagramId != null && !data.diagramId.isEmpty() && !data.diagramId.endsWith("migrated");
            String diagramId = hasId ? data.diagramId : SaveDiagramServlet.generateDiagramId();
            String macroId = data.macroId;
            if ((macroId == null || macroId.isEmpty()) && data.addDiagram) {
                macroId = new DefaultMacroIdSupplier().get().getId();
            }
            String graphml = "";
            String image = "";
            try {
                graphml = this.inflate(this.decodeBase64(graphmlParam));
                image = this.inflate(this.decodeBase64(imageParam));
            }
            catch (IOException e) {
                this.sendResponse(response, "error", "The sent data is not valid.", null);
                return null;
            }
            long idLong = Long.parseLong(data.id);
            ContentEntityObject ceo = this.contentEntityManager.getById(idLong);
            if (this.checkPermissionDenied(response, ceo)) {
                return null;
            }
            String zipFileName = diagramId + ".zip";
            Attachment attachment = this.attachmentManager.getAttachment(ceo, zipFileName);
            if (data.addDiagram && !data.overwrite && attachment != null) {
                this.sendResponse(response, "exists", zipFileName, null);
                return null;
            }
            if (!hasId && !data.addDiagram) {
                String encodedName = AttachmentHelper.getValidFileName(data.name);
                String oldZipFileName = encodedName + ".zip";
                Attachment oldAttachment = this.attachmentManager.getAttachment(ceo, oldZipFileName);
                this.addIdToMacro(data.id, data.name, diagramId);
                if (oldAttachment != null) {
                    this.attachmentManager.moveAttachment(oldAttachment, zipFileName, oldAttachment.getContainer());
                }
            }
            String macroProperties = "backgroundColor=" + data.backgroundColor + "\nwidth=" + data.imageWidth + "\nheight=" + data.imageHeight;
            byte[] zipData = new byte[]{};
            try {
                zipData = AttachmentHelper.getZipData(graphml, image, data.customData, data.palettes, macroProperties);
            }
            catch (Exception e) {
                log.error("Could not save Graphity data", (Throwable)e);
                this.sendResponse(response, "error", "<![CDATA[" + e.getMessage() + "]]>", null);
            }
            byte[] finalZipData = zipData;
            int attachmentVersion = -1;
            if (finalZipData.length > 0) {
                try {
                    attachment = this.saveAttachment(zipFileName, ceo, zipData, data.name + " (Graphity Diagram)", "application/zip");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                attachmentVersion = attachment.getVersion();
            }
            if (data.addDiagram) {
                GraphityMacroBody macro = new GraphityMacroBody(data.name);
                macro.setDiagramIdParam(diagramId);
                macro.setAlignParam(data.align);
                macro.setFloatParam(data.floating);
                macro.setWidthParam(data.width);
                macro.setHeightParam(data.height);
                macro.setMaxWidthParam(data.maxWidth);
                macro.setMaxHeightParam(data.maxHeight);
                macro.setDisplayFormatParam(data.displayFormat);
                macro.setLinksParam(data.links);
                macro.setLinksInNewWindowParam(data.linksInNewWindow);
                macro.setViewportGesturesParam(data.viewportGestures);
                macro.setTooltipsParam(data.tooltips);
                macro.setToolbarParam(data.toolbar);
                macro.setThemeParam(data.theme);
                macro.setDisplayNameParam(data.displayName);
                macro.setAttachmentVersionParam(attachmentVersion);
                try {
                    this.addMacroToPage(macro, macroId, idLong, data.addToBottom);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            } else if (macroId == null || macroId.isEmpty()) {
                this.updateAttachmentVersion(data.id, diagramId, attachmentVersion);
            } else {
                this.updateAttachmentDiagramIdAndVersion(data.id, macroId, diagramId, attachmentVersion);
            }
            this.sendSuccess(response, diagramId, attachment.getVersion());
            return null;
        });
    }

    private RequestData getRequestData(String requestId) {
        return (RequestData)this.saveRequests.get((Object)requestId);
    }

    private Cache<String, String> getChunkBuffer(boolean isData) {
        return isData ? this.dataChunks : this.imageChunks;
    }

    private RequestData initializeRequestData(HttpServletRequest req) {
        String viewportGestures;
        String toolbar;
        String tooltips;
        String linksInNewWindow;
        String overwrite;
        String graphChunks = req.getParameter("graphChunks");
        String imageChunks = req.getParameter("imageChunks");
        RequestData data = new RequestData();
        if (graphChunks != null) {
            data.graphChunks = Integer.parseInt(graphChunks);
        }
        if (imageChunks != null) {
            data.imageChunks = Integer.parseInt(imageChunks);
        }
        data.diagramId = req.getParameter("diagramId");
        data.id = req.getParameter("pageId");
        data.name = req.getParameter("name");
        data.customData = req.getParameter("customData");
        data.palettes = req.getParameter("palettes");
        String addDiagram = req.getParameter("addDiagram");
        if (addDiagram != null) {
            data.addDiagram = "true".equals(addDiagram);
        }
        if ((overwrite = req.getParameter("overwrite")) != null) {
            data.overwrite = "true".equals(overwrite);
        }
        data.backgroundColor = req.getParameter("backgroundColor");
        data.imageWidth = req.getParameter("imageWidth");
        data.imageHeight = req.getParameter("imageHeight");
        String append = req.getParameter("append");
        if (append != null) {
            data.addToBottom = "bottom".equals(append);
        }
        data.align = req.getParameter("align");
        String floating = req.getParameter("float");
        if (floating != null) {
            data.floating = "true".equals(floating);
        }
        data.width = req.getParameter("width");
        data.height = req.getParameter("height");
        data.maxWidth = req.getParameter("maxWidth");
        data.maxHeight = req.getParameter("maxHeight");
        data.displayFormat = req.getParameter("displayFormat");
        String links = req.getParameter("links");
        if (links != null) {
            boolean bl = data.links = !"false".equals(links);
        }
        if ((linksInNewWindow = req.getParameter("linksInNewWindow")) != null) {
            boolean bl = data.linksInNewWindow = !"false".equals(linksInNewWindow);
        }
        if ((tooltips = req.getParameter("tooltips")) != null) {
            boolean bl = data.tooltips = !"false".equals(tooltips);
        }
        if ((toolbar = req.getParameter("toolbar")) != null) {
            data.toolbar = "true".equals(toolbar);
        }
        if ((viewportGestures = req.getParameter("viewportGestures")) != null) {
            data.viewportGestures = "true".equals(viewportGestures);
        }
        data.theme = req.getParameter("theme");
        String displayName = req.getParameter("displayName");
        if (displayName != null) {
            data.displayName = !"false".equals(displayName);
        }
        data.macroId = req.getParameter("macroId");
        String version = req.getParameter("version");
        try {
            data.version = Integer.parseInt(version);
        }
        catch (NumberFormatException e) {
            data.version = 0;
        }
        return data;
    }

    public static String generateDiagramId() {
        return "graphity-" + new Date().getTime() + "-" + (int)(Math.random() * 1000.0);
    }

    private void addIdToMacro(String pageId, String name, String diagramId) {
        Page page = this.pageManager.getPage(Long.parseLong(pageId));
        Page originalPage = (Page)page.clone();
        String content = page.getBodyAsString();
        Matcher matcher = NAMED_MACRO_PATTERN.matcher(content);
        while (matcher.find()) {
            if (!name.equals(StringEscapeUtils.unescapeHtml((String)matcher.group("diagramName")))) continue;
            String newContent = matcher.group();
            String idParameter = "<ac:parameter ac:name=\"diagramId\">" + diagramId + "</ac:parameter>";
            newContent = newContent.replace(matcher.group("endTag"), idParameter + matcher.group("endTag"));
            content = content.replaceAll(Pattern.quote(matcher.group()), newContent);
        }
        page.setBodyAsString(content);
        this.pageManager.saveContentEntity((ContentEntityObject)page, (ContentEntityObject)originalPage, null);
    }

    private int findDuplicates(String pageId, String diagramId) {
        if (diagramId == null || diagramId.isEmpty()) {
            return 0;
        }
        Page page = this.pageManager.getPage(Long.parseLong(pageId));
        String content = page.getBodyAsString();
        Matcher matcher = MACRO_PATTERN.matcher(content);
        int count = 0;
        while (matcher.find()) {
            if (!diagramId.equals(StringEscapeUtils.unescapeHtml((String)matcher.group("diagramId")))) continue;
            ++count;
        }
        return count;
    }

    private void updateAttachmentDiagramIdAndVersion(String pageId, String macroId, String diagramId, long attachmentVersion) {
        String macroIdAttribute = "(?xs).*ac:macro-id=[\"']" + macroId + "[\"'].*";
        Page page = this.pageManager.getPage(Long.parseLong(pageId));
        String content = page.getBodyAsString();
        Matcher matcher = MACRO_PATTERN.matcher(content);
        boolean needsSave = false;
        while (matcher.find()) {
            String macroBody = matcher.group();
            if (!macroBody.matches(macroIdAttribute)) continue;
            needsSave = true;
            String attachmentVersionParameter = "<ac:parameter ac:name=\"version\">" + attachmentVersion + "</ac:parameter>";
            Matcher innerMatcher = VERSION_PARAMETER_PATTERN.matcher(macroBody);
            macroBody = innerMatcher.find() ? macroBody.replace(innerMatcher.group("attachmentVersion"), attachmentVersionParameter) : macroBody.replace(matcher.group("endTag"), attachmentVersionParameter + matcher.group("endTag"));
            String diagramIdParameter = "<ac:parameter ac:name=\"diagramId\">" + diagramId + "</ac:parameter>";
            innerMatcher = DIAGRAM_ID_PARAMETER_PATTERN.matcher(macroBody);
            macroBody = innerMatcher.find() ? macroBody.replace(innerMatcher.group("diagramId"), diagramIdParameter) : macroBody.replace(matcher.group("endTag"), diagramIdParameter + matcher.group("endTag"));
            content = content.replaceAll(Pattern.quote(matcher.group()), macroBody);
        }
        if (needsSave) {
            Page originalPage = (Page)page.clone();
            page.setBodyAsString(content);
            this.pageManager.saveContentEntity((ContentEntityObject)page, (ContentEntityObject)originalPage, null);
        }
    }

    private void updateAttachmentVersion(String pageId, String diagramId, long attachmentVersion) {
        String macroIdAttribute = "(?xs).*ac:macro-id=.*";
        Page page = this.pageManager.getPage(Long.parseLong(pageId));
        String content = page.getBodyAsString();
        Matcher matcher = MACRO_PATTERN.matcher(content);
        boolean needsSave = false;
        while (matcher.find()) {
            if (!diagramId.equals(StringEscapeUtils.unescapeHtml((String)matcher.group("diagramId")))) continue;
            String macroBody = matcher.group();
            needsSave = true;
            String attachmentVersionParameter = "<ac:parameter ac:name=\"version\">" + attachmentVersion + "</ac:parameter>";
            Matcher versionParameterMatcher = VERSION_PARAMETER_PATTERN.matcher(macroBody);
            if (!(macroBody = versionParameterMatcher.find() ? macroBody.replace(versionParameterMatcher.group("attachmentVersion"), attachmentVersionParameter) : macroBody.replace(matcher.group("endTag"), attachmentVersionParameter + matcher.group("endTag"))).matches("(?xs).*ac:macro-id=.*")) {
                String macroId = new DefaultMacroIdSupplier().get().getId();
                macroBody = macroBody.replace("ac:name=", "ac:macro-id=\"" + macroId + "\" ac:name=");
            }
            content = content.replaceAll(Pattern.quote(matcher.group()), macroBody);
        }
        if (needsSave) {
            Page originalPage = (Page)page.clone();
            page.setBodyAsString(content);
            this.pageManager.saveContentEntity((ContentEntityObject)page, (ContentEntityObject)originalPage, null);
        }
    }

    private byte[] decodeBase64(String base64String) {
        return Base64.getDecoder().decode(base64String.getBytes());
    }

    private String inflate(byte[] bytes) throws IOException {
        String result = "";
        try (GZIPInputStream gzipStream = new GZIPInputStream(new ByteArrayInputStream(bytes));){
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)gzipStream, StandardCharsets.UTF_8));
            String line = bufferedReader.readLine();
            while (line != null) {
                stringBuilder.append(line).append('\n');
                line = bufferedReader.readLine();
            }
            result = stringBuilder.toString();
        }
        return result;
    }

    private void sendResponse(HttpServletResponse resp, String result, String cause, String additionalInformation) {
        try {
            ServletOutputStream outputStream = resp.getOutputStream();
            StringBuilder response = new StringBuilder();
            response.append("{\"result\":\"").append(result).append("\"");
            if (cause != null) {
                response.append(", \"cause\":\"").append(cause).append("\"");
            }
            if (additionalInformation != null) {
                response.append(", ").append(additionalInformation);
            }
            response.append("}");
            outputStream.print(response.toString());
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            log.error("Could not send response", (Throwable)e);
        }
    }

    private void sendSuccess(HttpServletResponse resp, String diagramId, int version) {
        try {
            ServletOutputStream outputStream = resp.getOutputStream();
            String response = "{\"result\":\"success\", \"diagramId\":\"" + diagramId + "\", \"version\":\"" + version + "\"}";
            outputStream.print(response);
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            log.error("Could not send success response", (Throwable)e);
        }
    }

    private void addMacroToPage(GraphityMacroBody macro, String macroId, long pageId, boolean bottom) throws IllegalAccessException {
        Page page = this.pageManager.getPage(pageId);
        Page originalPage = (Page)page.clone();
        String contentToAdd3 = macro.getConfluence6String(macroId);
        String bodyAsString = page.getBodyAsString();
        String content3 = this.createPageContent(bottom, bodyAsString, contentToAdd3);
        page.setBodyAsString(content3);
        this.pageManager.saveContentEntity((ContentEntityObject)page, (ContentEntityObject)originalPage, null);
    }

    private String createPageContent(boolean bottom, String body, String macro) {
        if (body.startsWith("<ac:layout>")) {
            String section = "<ac:layout-section ac:type=\"single\"><ac:layout-cell><p>" + macro + "</p></ac:layout-cell></ac:layout-section>";
            if (bottom) {
                return body.replace("</ac:layout>", section + "</ac:layout>");
            }
            return body.replace("<ac:layout>", "<ac:layout>" + section);
        }
        return bottom ? body + macro : macro + body;
    }

    private Attachment saveAttachment(String name, ContentEntityObject ceo, byte[] data, String comment, String contentType) throws IOException {
        Attachment attachment;
        Attachment previousVersion = this.attachmentManager.getAttachment(ceo, name);
        if (previousVersion != null) {
            attachment = previousVersion;
            previousVersion = (Attachment)previousVersion.clone();
        } else {
            attachment = new Attachment();
            ceo.addAttachment(attachment);
        }
        attachment.setVersionComment(comment);
        attachment.setMediaType(contentType);
        attachment.setContainer(ceo);
        attachment.setFileName(name);
        attachment.setFileSize((long)data.length);
        this.labelManager.addLabel((Labelable)attachment, new Label("Graphity"));
        this.attachmentManager.saveAttachment(attachment, previousVersion, (InputStream)new ByteArrayInputStream(data));
        return attachment;
    }
}

