/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.confluence.content.render.xhtml.editor.macro.DefaultMacroIdSupplier;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.MacroUsageQuery;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.User;
import com.yworks.plugins.confluence.SaveDiagramServlet;
import com.yworks.plugins.confluence.helper.AttachmentHelper;
import com.yworks.plugins.confluence.helper.LicenseHelper;
import com.yworks.plugins.confluence.helper.PageUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationServlet
extends HttpServlet {
    private static final String MODE_MIGRATE = "migrate";
    private static final String MODE_REVERT = "revert";
    private static final String MODE_UPDATE = "update";
    private static final String ENTRY_DIAGRAM_SVG = "diagram.svg";
    private static final String ENTRY_DIAGRAM_GRAPHML = "diagram.graphml";
    private static final String ENTRY_CUSTOM_DATA_JSON = "CustomData.json";
    private static final String ENTRY_PALETTES_JSON = "Palettes.json";
    private static final String ENTRY_META_INF_MARCO_PROPERTIES = "META-INF/macro.properties";
    private static final String ENTRY_META_INF_VERSION_PROPERTIES = "META-INF/version.properties";
    private final SearchManager searchManager;
    private SettingsManager settingsManager;
    private final PageManager pageManager;
    private final AttachmentManager attachmentManager;
    private final LabelManager labelManager;
    private final PluginLicenseManager pluginLicenseManager;
    private final PermissionManager permissionManager;
    private final List<String> errors = new ArrayList<String>();
    private final TransactionTemplate transactionTemplate;
    private boolean processing = false;
    private double pageCount;
    private double processedPagesCount;
    private double processedMacrosCount;
    private double allMacrosCount;
    static final String INSUFFICIENT_PERMISSIONS_FOR_MIGRATION = "You must be a Confluence Administrator to perform or revert a migration";
    private static final Logger log = LoggerFactory.getLogger(MigrationServlet.class);
    private String baseUrl;

    public MigrationServlet(@ComponentImport SearchManager searchManager, @ComponentImport SettingsManager settingsManager, @ComponentImport PageManager pageManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport LabelManager labelManager, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PermissionManager permissionManager, @ComponentImport TransactionTemplate transactionTemplate) {
        this.searchManager = searchManager;
        this.settingsManager = settingsManager;
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.labelManager = labelManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.permissionManager = permissionManager;
        this.transactionTemplate = transactionTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LicenseHelper licenseHelper = new LicenseHelper(this.pluginLicenseManager);
        if (!licenseHelper.isValidLicense()) {
            this.sendError(resp, "License Error: " + licenseHelper.getErrorString());
            return;
        }
        this.baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            this.sendError(resp, INSUFFICIENT_PERMISSIONS_FOR_MIGRATION);
            return;
        }
        if (this.processing) {
            this.sendUpdate(resp);
            return;
        }
        this.processing = true;
        try {
            String mode = req.getParameter("mode");
            this.pageCount = 0.0;
            this.processedPagesCount = 0.0;
            this.allMacrosCount = 0.0;
            this.processedMacrosCount = 0.0;
            this.errors.clear();
            if (MODE_MIGRATE.equals(mode)) {
                this.transactionTemplate.execute(() -> {
                    this.migratePages();
                    return null;
                });
            } else if (MODE_REVERT.equals(mode)) {
                this.transactionTemplate.execute(() -> {
                    this.revertMigration();
                    return null;
                });
            } else if (MODE_UPDATE.equals(mode)) {
                this.sendUpdate(resp);
            }
            this.sendSuccess(resp);
        }
        catch (Exception e) {
            this.sendError(resp, e.getMessage());
        }
        finally {
            this.processing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void migratePages() {
        Label pageLabel = this.labelManager.getLabel("page-graphity-migrated-to-cloud");
        if (pageLabel != null) {
            this.labelManager.deleteLabel(pageLabel);
        }
        HashSet<Page> pages = new HashSet<Page>();
        try {
            PageUtils.findPages(this.searchManager, (SearchQuery)new MacroUsageQuery("graphity"), new CreatedSort(SearchSort.Order.ASCENDING), pages);
            PageUtils.findPages(this.searchManager, (SearchQuery)new MacroUsageQuery("ydiagram"), new CreatedSort(SearchSort.Order.ASCENDING), pages);
        }
        catch (InvalidSearchException e) {
            log.error("Invalid search for macro", (Throwable)e);
        }
        ArrayList<MacroDescriptor> macros = new ArrayList<MacroDescriptor>();
        this.pageCount = pages.size();
        for (Page page : pages) {
            log.info("Migrating page " + page.getId());
            macros.clear();
            try {
                this.collectMacrosInPage(macros, page);
                for (MacroDescriptor macro : macros) {
                    this.removeAttachment(macro.diagramId, page);
                    this.migrateAttachment(macro, page);
                    this.processedMacrosCount += 1.0;
                }
                this.addMissingIdsAndParameters(macros, page);
            }
            catch (Exception e) {
                long id = page.getId();
                this.errors.add("<a href='" + this.baseUrl + "/pages/viewpage.action?pageId=" + id + "'>Page " + id + "</a>: " + e.getMessage());
            }
            finally {
                this.allMacrosCount += 1.0;
            }
            this.labelManager.addLabel((Labelable)page, new Label("page-graphity-migrated-to-cloud"));
            this.processedPagesCount += 1.0;
        }
    }

    private void collectMacrosInPage(List<MacroDescriptor> macros, Page page) {
        String pageContent = page.getBodyAsString();
        HashSet<String> diagramIds = new HashSet<String>();
        Pattern pattern = Pattern.compile("(?xs) # we need DOTALL (?s) since the macro may be on multiple lines\n<ac:(structured-)?macro # allow both <ac:macro and <ac:structured-macro\n[^>]+ac:name=[\"']graphity[\"']\n.*? # skip forward to parameter with name='name'\n<ac:parameter[^>]ac:name=[\"']diagramId[\"']>\n(?<diagramId>[^<]*) # capture the diagram name to compare against the one to delete\n.*? # capture the rest lazily\n</ac:\\1macro> # matching end tag", 36);
        Matcher matcher = pattern.matcher(pageContent);
        while (matcher.find()) {
            String diagramId = StringEscapeUtils.unescapeHtml((String)matcher.group("diagramId"));
            Pattern diagramNamePattern = Pattern.compile("<ac:parameter[^>]ac:name=[\"']name[\"']>(?<diagramName>[^<]*)");
            Matcher diagramNameMatcher = diagramNamePattern.matcher(matcher.group());
            String diagramName = "";
            if (diagramNameMatcher.find()) {
                diagramName = StringEscapeUtils.unescapeHtml((String)diagramNameMatcher.group("diagramName"));
            }
            if (!diagramIds.add(diagramId)) continue;
            macros.add(new MacroDescriptor(diagramId, diagramName, matcher.group(), !this.hasMacroId(matcher.group()), false));
        }
        pattern = Pattern.compile("(?xs) # we need DOTALL (?s) since the macro may be on multiple lines\n<ac:(structured-)?macro # allow both <ac:macro and <ac:structured-macro\n[^>]+ac:name=[\"']ydiagram[\"']\n.*? # skip forward to parameter with name='name'\n<ac:parameter[^>]ac:name=[\"']name[\"']>\n(?<diagramName>[^<]*) # capture the diagram name to compare against the one to delete\n.*? # capture the rest lazily\n</ac:\\1macro> # matching end tag", 36);
        matcher = pattern.matcher(pageContent);
        while (matcher.find()) {
            String diagramName = StringEscapeUtils.unescapeHtml((String)matcher.group("diagramName"));
            String diagramId = this.getDiagramId(matcher.group());
            boolean addDiagramId = false;
            if (diagramId == null) {
                diagramId = SaveDiagramServlet.generateDiagramId();
                addDiagramId = true;
            }
            if (!diagramIds.add(diagramId)) continue;
            macros.add(new MacroDescriptor(diagramId, diagramName, matcher.group(), !this.hasMacroId(matcher.group()), addDiagramId));
        }
    }

    private boolean hasMacroId(String macroSource) {
        Pattern pattern = Pattern.compile("(?xs)ac:macro-id=\"[^\"]*\"");
        Matcher matcher = pattern.matcher(macroSource);
        return matcher.find();
    }

    private void addMissingIdsAndParameters(List<MacroDescriptor> macros, Page page) {
        String pageContent;
        String newPageContent = pageContent = page.getBodyAsString();
        for (MacroDescriptor macro : macros) {
            String newMacroSource = macro.macroSource;
            if (macro.addMacroId) {
                newMacroSource = this.addMacroId(newMacroSource);
            }
            HashMap<String, String> server2cloud = new HashMap<String, String>();
            server2cloud.put("diagramId", "graphityMacroId");
            server2cloud.put("name", "graphityMacroName");
            server2cloud.put("displayName", "graphityDisplayName");
            server2cloud.put("version", "graphityVersion");
            server2cloud.put("toolbar", "graphityShowToolbar");
            server2cloud.put("tooltips", "graphityDisplayTooltips");
            server2cloud.put("links", "graphityEnableLinks");
            server2cloud.put("linksInNewWindow", "graphityOpenLinksInWindow");
            server2cloud.put("viewportGestures", "graphityViewportGestures");
            server2cloud.put("display-format", "graphityDisplayFormat");
            for (Map.Entry entry : server2cloud.entrySet()) {
                newMacroSource = this.addParameter(newMacroSource, macro, (String)entry.getKey(), (String)entry.getValue());
            }
            if (macro.macroSource.equals(newMacroSource)) continue;
            newPageContent = newPageContent.replace(macro.macroSource, newMacroSource);
        }
        if (!pageContent.equals(newPageContent)) {
            Page originalPage = (Page)page.clone();
            page.setBodyAsString(newPageContent);
            this.pageManager.saveContentEntity((ContentEntityObject)page, (ContentEntityObject)originalPage, null);
        }
    }

    private String addParameter(String macroSource, MacroDescriptor macro, String nameServer, String nameCloud) {
        String parameterValue;
        Pattern pattern = Pattern.compile("<ac:parameter[^>]ac:name=[\"']" + nameServer + "[\"']>(?<value>[^<]*)");
        Matcher matcher = pattern.matcher(macroSource);
        if (matcher.find()) {
            parameterValue = matcher.group("value");
            if ("display-format".equals(nameServer) && "image".equals(parameterValue)) {
                parameterValue = "static";
            }
        } else {
            parameterValue = "display-format".equals(nameServer) ? "interactive" : ("diagramId".equals(nameServer) ? macro.diagramId : ("version".equals(nameServer) ? String.valueOf(macro.version) : "true"));
        }
        String parameter = "<ac:parameter ac:name=\"" + nameCloud + "\">" + parameterValue + "</ac:parameter>";
        pattern = Pattern.compile("<ac:parameter[^>]ac:name=[\"']" + nameCloud + "[\"']>(?<value>[^<]*)");
        matcher = pattern.matcher(macroSource);
        if (matcher.find()) {
            return macroSource.replace(matcher.group(), parameter);
        }
        pattern = Pattern.compile("<ac:(structured-)?macro.*?>");
        matcher = pattern.matcher(macroSource);
        if (matcher.find()) {
            return macroSource.substring(0, matcher.end()) + parameter + macroSource.substring(matcher.end());
        }
        return macroSource;
    }

    private String addMacroId(String macroSource) {
        Pattern pattern = Pattern.compile("<ac:structured-macro ac:name=\"[^\"]*\"");
        Matcher matcher = pattern.matcher(macroSource);
        if (matcher.find()) {
            MacroId macroId = new DefaultMacroIdSupplier().get();
            return macroSource.substring(0, matcher.end()) + " ac:macro-id=\"" + macroId.getId() + "\"" + macroSource.substring(matcher.end());
        }
        return macroSource;
    }

    private String getDiagramId(String macroSource) {
        Pattern pattern = Pattern.compile("<ac:parameter[^>]ac:name=[\"']diagramId[\"']>(?<diagramId>[^<]*)");
        Matcher matcher = pattern.matcher(macroSource);
        if (matcher.find()) {
            return matcher.group("diagramId");
        }
        return null;
    }

    private void migrateAttachment(MacroDescriptor macro, Page page) throws IOException {
        Attachment attachment;
        if (macro.addDiagramId) {
            this.createZipAttachmentWithId(macro, page);
        }
        if ((attachment = this.attachmentManager.getAttachment((ContentEntityObject)page, macro.diagramId + ".zip")) != null) {
            List allVersions = this.attachmentManager.getAllVersions(attachment);
            Collections.reverse(allVersions);
            macro.version = allVersions.size();
            for (Attachment attachmentVersion : allVersions) {
                StringBuilder jsonBuilder = new StringBuilder();
                log.debug("Migrating attachment " + attachment.getId() + ", version " + attachmentVersion);
                String graphityVersion = this.getGraphityVersion(attachmentVersion, page.getId());
                jsonBuilder.append("{\"version\": \"Migrated from Graphity for Confluence Server ").append(graphityVersion).append("\",");
                byte[] svgData = AttachmentHelper.getEntry(ENTRY_DIAGRAM_SVG, this.getAttachmentData(attachmentVersion, page.getId()));
                if (svgData.length <= 0) {
                    throw new IOException("Could not migrate attachment: " + attachmentVersion.getFileName() + " (page-id: " + page.getId() + ")");
                }
                String svgString = this.createEscapedString(svgData);
                jsonBuilder.append("\"svg\": \"").append(svgString).append("\",");
                byte[] macroProperties = AttachmentHelper.getEntry(ENTRY_META_INF_MARCO_PROPERTIES, this.getAttachmentData(attachmentVersion, page.getId()));
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(macroProperties));
                String backgroundColor = properties.getProperty("backgroundColor");
                jsonBuilder.append("\"backgroundColor\": \"").append(backgroundColor != null ? backgroundColor : "#FFF").append("\",");
                jsonBuilder.append("\"width\": ").append(properties.getProperty("width")).append(",");
                jsonBuilder.append("\"height\": ").append(properties.getProperty("height")).append(",");
                byte[] customData = AttachmentHelper.getEntry(ENTRY_CUSTOM_DATA_JSON, this.getAttachmentData(attachmentVersion, page.getId()));
                jsonBuilder.append("\"data\": ");
                if (customData.length > 0) {
                    String data = new String(customData);
                    Pattern pattern = Pattern.compile("\\{\"svgTransform\":\".*?\"\\},?", 36);
                    Matcher matcher = pattern.matcher(data);
                    if (matcher.find()) {
                        String match = matcher.group();
                        data = data.replace(match, "");
                        jsonBuilder.append(data).append(",").append(match, match.indexOf("{") + 1, match.lastIndexOf("}")).append(",");
                    } else {
                        jsonBuilder.append(data).append(",");
                    }
                } else {
                    jsonBuilder.append("[],");
                }
                byte[] palettes = AttachmentHelper.getEntry(ENTRY_PALETTES_JSON, this.getAttachmentData(attachmentVersion, page.getId()));
                jsonBuilder.append("\"palettes\": ");
                if (palettes.length > 0) {
                    jsonBuilder.append(new String(palettes));
                } else {
                    jsonBuilder.append("[]");
                }
                jsonBuilder.append("}");
                this.saveAttachment(macro.diagramId + ".json", (ContentEntityObject)page, jsonBuilder.toString().getBytes(StandardCharsets.UTF_8), macro.diagramName + " (Graphity Diagram)", "application/json");
                byte[] graphmlData = AttachmentHelper.getEntry(ENTRY_DIAGRAM_GRAPHML, this.getAttachmentData(attachmentVersion, page.getId()));
                if (graphmlData.length > 0) {
                    this.saveAttachment(macro.diagramId + ".graphml", (ContentEntityObject)page, graphmlData, macro.diagramName + " (Graphity Diagram)", "application/xml");
                    continue;
                }
                throw new IOException("Could not migrate attachment: " + attachmentVersion.getFileName() + " (page-id: " + page.getId() + ")");
            }
            if (macro.addDiagramId) {
                this.attachmentManager.removeAttachmentFromServer(attachment);
            }
        } else {
            attachment = this.attachmentManager.getAttachment((ContentEntityObject)page, macro.diagramName + ".png");
            if (attachment != null) {
                List allVersions = this.attachmentManager.getAllVersions(attachment);
                Collections.reverse(allVersions);
                for (Attachment attachmentVersion : allVersions) {
                    StringBuilder jsonBuilder = new StringBuilder();
                    jsonBuilder.append("{\"version\": \"Migrated from Graphity for Confluence Server\",");
                    String svgString = AttachmentHelper.getPngDataUri(this.getAttachmentData(attachmentVersion, page.getId()));
                    BufferedImage image = ImageIO.read(this.getAttachmentData(attachmentVersion, page.getId()));
                    int imageWidth = image.getWidth();
                    int imageHeight = image.getHeight();
                    jsonBuilder.append("\"svg\": \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" xmlns:xlink=\\\"http://www.w3.org/1999/xlink\\\" width=\\\"").append(imageWidth).append("\\\" height=\\\"").append(imageHeight).append("\\\" viewBox=\\\"0 0 ").append(imageWidth).append(" ").append(imageHeight).append("\\\" style=\\\"overflow: hidden; display: block; width: ").append(imageWidth).append("px; height: ").append(imageHeight).append("px;\\\"><rect width=\\\"").append(imageWidth).append("px\\\" height=\\\"").append(imageHeight).append("px\\\" fill=\\\"#FFF\\\"/>").append("<image x=\\\"0\\\" y=\\\"0\\\" width=\\\"").append(imageWidth).append("px\\\" height=\\\"").append(imageHeight).append("px\\\" xlink:href=\\\"").append(svgString).append("\\\"></image>").append("</svg>\",");
                    jsonBuilder.append("\"backgroundColor\": \"#FFF\",");
                    jsonBuilder.append("\"width\": ").append(imageWidth).append(",");
                    jsonBuilder.append("\"height\": ").append(imageHeight).append(",");
                    jsonBuilder.append("\"data\": [], \"palettes\": [] }");
                    this.saveAttachment(macro.diagramId + ".json", (ContentEntityObject)page, jsonBuilder.toString().getBytes(StandardCharsets.UTF_8), macro.diagramName + " (Graphity Diagram)", "application/json");
                    InputStream attachmentData = this.attachmentManager.getAttachmentData(this.attachmentManager.getAttachment((ContentEntityObject)page, macro.diagramName + ".graphml"));
                    byte[] graphmlData = AttachmentHelper.readAttachmentData(attachmentData);
                    this.saveAttachment(macro.diagramId + ".graphml", (ContentEntityObject)page, graphmlData, macro.diagramName + " (Graphity Diagram)", "application/xml");
                }
            }
        }
    }

    private String createEscapedString(byte[] svgData) {
        String escaped = new String(svgData);
        escaped = escaped.replace("\\", "\\\\");
        escaped = escaped.replace("\"", "\\\"");
        escaped = escaped.replace("\b", "\\b");
        escaped = escaped.replace("\f", "\\f");
        escaped = escaped.replace("\n", "\\n");
        escaped = escaped.replace("\r", "\\r");
        escaped = escaped.replace("\t", "\\t");
        return escaped;
    }

    private void createZipAttachmentWithId(MacroDescriptor macro, Page page) throws IOException {
        String diagramName = AttachmentHelper.getValidFileName(macro.diagramName);
        Attachment oldAttachment = this.attachmentManager.getAttachment((ContentEntityObject)page, diagramName + ".zip");
        if (oldAttachment != null) {
            List allOldVersions = this.attachmentManager.getAllVersions(oldAttachment);
            Collections.reverse(allOldVersions);
            for (Attachment oldVersion : allOldVersions) {
                if (this.attachmentManager.getAttachmentData(oldVersion) == null) continue;
                String graphml = new String(AttachmentHelper.getEntry(diagramName + ".graphml", this.attachmentManager.getAttachmentData(oldVersion)));
                String image = new String(AttachmentHelper.getEntry(diagramName + ".svg", this.attachmentManager.getAttachmentData(oldVersion)));
                String customData = new String(AttachmentHelper.getEntry(ENTRY_CUSTOM_DATA_JSON, this.attachmentManager.getAttachmentData(oldVersion)));
                String palettes = new String(AttachmentHelper.getEntry(ENTRY_PALETTES_JSON, this.attachmentManager.getAttachmentData(oldVersion)));
                String macroProperties = new String(AttachmentHelper.getEntry(ENTRY_META_INF_MARCO_PROPERTIES, this.attachmentManager.getAttachmentData(oldVersion)));
                byte[] data = AttachmentHelper.getZipData(graphml, image, customData, palettes, macroProperties);
                this.saveAttachment(macro.diagramId + ".zip", (ContentEntityObject)page, data, macro.diagramName + " (Graphity Diagram)", "application/zip");
            }
        }
    }

    private InputStream getAttachmentData(Attachment attachmentVersion, long pageId) throws IOException {
        InputStream attachmentData = this.attachmentManager.getAttachmentData(attachmentVersion);
        if (attachmentData == null) {
            throw new IOException("Could not migrate attachment: " + attachmentVersion.getFileName() + " (page-id: " + pageId + ")");
        }
        return attachmentData;
    }

    private String getGraphityVersion(Attachment attachmentVersion, long pageId) throws IOException {
        InputStream attachmentData = this.getAttachmentData(attachmentVersion, pageId);
        byte[] versionProperties = AttachmentHelper.getEntry(ENTRY_META_INF_VERSION_PROPERTIES, attachmentData);
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(versionProperties));
        return properties.getProperty("version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revertMigration() {
        Label pageLabel = this.labelManager.getLabel("page-graphity-migrated-to-cloud");
        Label graphityLabel = this.labelManager.getLabel("Graphity");
        Label migrationLabel = this.labelManager.getLabel("migrated");
        List migratedPages = this.labelManager.getContentForLabel(0, Integer.MAX_VALUE, pageLabel).getList();
        ArrayList<Page> pages = new ArrayList<Page>();
        for (ContentEntityObject entity : migratedPages) {
            if (!(entity instanceof Page)) continue;
            Page page = (Page)entity;
            pages.add(page);
        }
        this.pageCount = pages.size();
        for (Page page : pages) {
            try {
                this.revertMigration(pageLabel, graphityLabel, migrationLabel, page);
            }
            catch (Exception e) {
                long id = page.getId();
                this.errors.add("<a href='" + this.baseUrl + "/pages/viewpage.action?pageId=" + id + "'>Page " + id + "</a>: " + e.getMessage());
            }
            finally {
                this.allMacrosCount += 1.0;
            }
            this.processedPagesCount += 1.0;
        }
    }

    private void revertMigration(Label pageLabel, Label graphityLabel, Label migrationLabel, Page page) {
        log.info("Reverting page " + page.getId());
        String pageContent = page.getBodyAsString();
        String newPageContent = pageContent.replaceAll("<ac:parameter[^>]ac:name=[\"'](graphityMacroId|graphityMacroName|graphityDisplayName|graphityVersion|graphityShowToolbar|graphityDisplayTooltips|graphityEnableLinks|graphityOpenLinksInWindow|graphityDisplayFormat)[\"']>.*?</ac:parameter>", "");
        if (!pageContent.equals(newPageContent)) {
            Page originalPage = (Page)page.clone();
            page.setBodyAsString(newPageContent);
            this.pageManager.saveContentEntity((ContentEntityObject)page, (ContentEntityObject)originalPage, null);
        }
        for (Attachment attachment : this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page)) {
            List attachmentLabels = attachment.getLabels();
            if (!attachmentLabels.contains(graphityLabel) || !attachmentLabels.contains(migrationLabel)) continue;
            log.debug("Reverting attachment " + attachment.getId());
            this.attachmentManager.removeAttachmentFromServer(attachment);
        }
        this.labelManager.removeLabel((Labelable)page, pageLabel);
    }

    private void removeAttachment(String diagramId, Page page) {
        Attachment attachment = this.attachmentManager.getAttachment((ContentEntityObject)page, diagramId + ".zip");
        if (attachment != null) {
            Attachment json;
            Attachment graphml = this.attachmentManager.getAttachment((ContentEntityObject)page, diagramId + ".graphml");
            if (graphml != null) {
                this.attachmentManager.removeAttachmentFromServer(graphml);
            }
            if ((json = this.attachmentManager.getAttachment((ContentEntityObject)page, diagramId + ".json")) != null) {
                this.attachmentManager.removeAttachmentFromServer(json);
            }
        } else {
            Attachment json;
            attachment = this.attachmentManager.getAttachment((ContentEntityObject)page, diagramId + ".png");
            if (attachment != null && (json = this.attachmentManager.getAttachment((ContentEntityObject)page, diagramId + ".json")) != null) {
                this.attachmentManager.removeAttachmentFromServer(json);
            }
        }
    }

    private void saveAttachment(String name, ContentEntityObject ceo, byte[] data, String comment, String contentType) throws IOException {
        Attachment attachment;
        Attachment previousVersion = this.attachmentManager.getAttachment(ceo, name);
        if (previousVersion != null) {
            attachment = previousVersion;
            previousVersion = (Attachment)previousVersion.clone();
        } else {
            attachment = new Attachment();
            ceo.addAttachment(attachment);
        }
        attachment.setVersionComment(comment);
        attachment.setMediaType(contentType);
        attachment.setContainer(ceo);
        attachment.setFileName(name);
        attachment.setFileSize((long)data.length);
        this.labelManager.addLabel((Labelable)attachment, new Label("graphity"));
        this.labelManager.addLabel((Labelable)attachment, new Label("migrated"));
        this.attachmentManager.saveAttachment(attachment, previousVersion, (InputStream)new ByteArrayInputStream(data));
    }

    private void sendUpdate(HttpServletResponse response) throws IOException {
        this.sendResponse(response, "progress", null, String.valueOf((int)(this.processedPagesCount / this.pageCount * 100.0)));
    }

    private void sendSuccess(HttpServletResponse response) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"progress\":").append(this.processedPagesCount / this.pageCount * 100.0).append(", \"pages\":").append(this.pageCount).append(", \"macros\":").append(this.allMacrosCount).append(", \"processedMacros\":").append(this.processedMacrosCount).append(", \"errors\": [");
        boolean first = true;
        for (String error : this.errors) {
            if (first) {
                builder.append("\"").append(error).append("\"");
                first = false;
                continue;
            }
            builder.append(", \"").append(error).append("\"");
        }
        builder.append("]}");
        this.sendResponse(response, "success", null, builder.toString());
    }

    private void sendError(HttpServletResponse response, String cause) throws IOException {
        this.sendResponse(response, "error", cause, null);
    }

    private void sendResponse(HttpServletResponse resp, String result, String cause, String data) throws IOException {
        ServletOutputStream outputStream = resp.getOutputStream();
        StringBuilder builder = new StringBuilder();
        builder.append("{\"result\": \"").append(result).append("\"");
        if (cause != null) {
            builder.append(", \"cause\": \"").append(cause).append("\"");
        }
        if (data != null) {
            builder.append(", \"data\": ").append(data);
        }
        builder.append("}");
        outputStream.print(builder.toString());
        outputStream.flush();
        outputStream.close();
    }

    private static final class MacroDescriptor {
        final String diagramId;
        final String diagramName;
        final String macroSource;
        final boolean addMacroId;
        final boolean addDiagramId;
        public int version = 0;

        public MacroDescriptor(String diagramId, String diagramName, String macroSource, boolean addMacroId, boolean addDiagramId) {
            this.diagramId = diagramId;
            this.diagramName = diagramName;
            this.macroSource = macroSource;
            this.addMacroId = addMacroId;
            this.addDiagramId = addDiagramId;
        }
    }
}

