/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.User;
import com.yworks.plugins.confluence.AdminAction;
import com.yworks.plugins.confluence.helper.LicenseHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;

public class LoadTemplateGraphsServlet
extends HttpServlet {
    private final BandanaManager bandanaManager;
    private final PageManager pageManager;
    private final AttachmentManager attachmentManager;
    private final PluginLicenseManager pluginLicenseManager;
    private final PermissionManager permissionManager;
    private final LocaleManager localeManager;

    public LoadTemplateGraphsServlet(@ComponentImport BandanaManager bandanaManager, @ComponentImport PageManager pageManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport LocaleManager localeManager, @ComponentImport PermissionManager permissionManager) {
        this.bandanaManager = bandanaManager;
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.localeManager = localeManager;
        this.permissionManager = permissionManager;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LicenseHelper licenseHelper = new LicenseHelper(this.pluginLicenseManager);
        if (!licenseHelper.isValidLicense()) {
            try (PrintWriter out = resp.getWriter();){
                out.println("{\"error\":\"License Error\":\"" + licenseHelper.getErrorString() + "\"}");
            }
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Pattern findMacroInBody = Pattern.compile("(?xs) # we need DOTALL (?s) since the macro may be on multiple lines\n<ac:(structured-)?macro # allow both <ac:macro and <ac:structured-macro\n[^>]+ac:name=[\"']graphity[\"']\n.*? # skip forward to parameter with name='name'\n(?<endTag></ac:\\1macro>) # matching end tag", 36);
        Pattern findId = Pattern.compile("<ac:parameter[^>]ac:name=[\"']diagramId[\"']>(?<diagramId>[^<]*)", 32);
        Pattern findName = Pattern.compile("<ac:parameter[^>]ac:name=[\"']name[\"']>(?<diagramName>[^<]*)", 32);
        Pattern findVersion = Pattern.compile("<ac:parameter[^>]ac:name=[\"']version[\"']>(?<diagramVersion>[^<]*)", 32);
        boolean pageFound = false;
        List<Page> pages = AdminAction.getTemplateGraphPagesStatic(this.bandanaManager, this.pageManager);
        for (Page page : pages) {
            if (page == null || !this.hasReadPermission(user, page) || "deleted".equals(page.getContentStatus())) continue;
            pageFound = true;
            builder.append("{\"title\": \"");
            builder.append(page.getDisplayTitle());
            builder.append("\", \"pageId\": \"");
            builder.append(page.getId());
            builder.append("\", \"samples\": [");
            String content = page.getBodyAsString();
            Matcher macroMatcher = findMacroInBody.matcher(content);
            boolean matched = false;
            while (macroMatcher.find()) {
                String result = macroMatcher.group();
                Matcher idMatcher = findId.matcher(result);
                Matcher nameMatcher = findName.matcher(result);
                Matcher versionMatcher = findVersion.matcher(result);
                if (!idMatcher.find() || !nameMatcher.find()) continue;
                String diagramId = idMatcher.group("diagramId");
                String diagramName = nameMatcher.group("diagramName");
                String diagramVersion = versionMatcher.find() ? versionMatcher.group("diagramVersion") : "0";
                if ("0".equals(diagramVersion) || this.attachmentManager.getAttachment((ContentEntityObject)page, diagramId + ".zip") == null) continue;
                matched = true;
                builder.append("{\"diagramId\": \"").append(StringEscapeUtils.unescapeHtml((String)diagramId)).append("\", ");
                builder.append("\"diagramName\": \"").append(StringEscapeUtils.unescapeHtml((String)diagramName)).append("\",");
                builder.append("\"version\": \"").append(StringEscapeUtils.unescapeHtml((String)diagramVersion)).append("\"},");
            }
            if (matched && builder.length() > 0) {
                builder.replace(builder.length() - 1, builder.length(), "");
            }
            builder.append("]},");
        }
        if (pageFound && builder.length() > 0) {
            builder.replace(builder.length() - 1, builder.length(), "");
        }
        builder.append("]");
        try (ServletOutputStream outputStream = resp.getOutputStream();){
            outputStream.print(builder.toString());
            outputStream.flush();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doPost(req, resp);
    }

    private boolean hasReadPermission(ConfluenceUser user, Page page) {
        return this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)page);
    }
}

