/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.gson.Gson;
import com.yworks.plugins.confluence.helper.LicenseHelper;
import com.yworks.plugins.confluence.helper.PalettesManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GlobalPalettesServlet
extends HttpServlet {
    private static final String ADD_GLOBAL_PALETTE = "add-global-palette";
    private static final String REMOVE_GLOBAL_PALETTE = "remove-global-palette";
    private static final String GET_GLOBAL_PALETTE = "get-global-palette";
    private static final String GET_GLOBAL_PALETTES = "get-global-palette-names";
    private static final String GET_CREATE_PERMISSION = "get-create-permission";
    private static final String GET_BUILT_IN_PALETTES = "get-built-in-palettes";
    private final BandanaManager bandanaManager;
    private final PalettesManager palettesManager;
    private final PluginLicenseManager pluginLicenseManager;
    private final Gson gson;

    public GlobalPalettesServlet(@ComponentImport BandanaManager bandanaManager, @ComponentImport PermissionManager permissionManager, @ComponentImport PluginLicenseManager pluginLicenseManager) {
        this.bandanaManager = bandanaManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.palettesManager = new PalettesManager(bandanaManager, permissionManager);
        this.gson = new Gson();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LicenseHelper licenseHelper = new LicenseHelper(this.pluginLicenseManager);
        if (!licenseHelper.isValidLicense()) {
            this.sendError(resp, "License Error: " + licenseHelper.getErrorString());
            return;
        }
        String idParam = req.getParameter("id");
        String nameParam = req.getParameter("name");
        String graphmlParam = req.getParameter("graphml");
        String actionParam = req.getParameter("action");
        if (this.bandanaManager == null) {
            this.sendError(resp, "Failed to persist global palettes.");
            return;
        }
        if (ADD_GLOBAL_PALETTE.equals(actionParam)) {
            try {
                HashMap<String, String> palette = this.palettesManager.addGlobalPalette(idParam, nameParam, graphmlParam);
                HashMap<String, String> response = new HashMap<String, String>();
                response.put("id", idParam);
                response.put("name", palette.get("name"));
                response.put("graphml", palette.get("graphml"));
                response.put("canEdit", "true");
                response.put("owner", palette.get("ownerName"));
                this.sendSuccess(resp, response);
            }
            catch (Exception exception) {
                this.sendError(resp, exception.getMessage());
            }
        } else if (REMOVE_GLOBAL_PALETTE.equals(actionParam)) {
            try {
                this.palettesManager.removeGlobalPalette(idParam);
            }
            catch (Exception exception) {
                this.sendError(resp, exception.getMessage());
            }
        } else if (GET_GLOBAL_PALETTE.equals(actionParam)) {
            HashMap<String, String> properties = this.palettesManager.getGlobalPalette(idParam);
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("id", idParam);
            response.put("name", properties.get("name"));
            response.put("graphml", properties.get("graphml"));
            response.put("canEdit", this.palettesManager.canEditGlobalPalette(idParam) ? "true" : "false");
            response.put("owner", properties.get("ownerName"));
            this.sendSuccess(resp, response);
        } else if (GET_GLOBAL_PALETTES.equals(actionParam)) {
            List<HashMap<String, String>> globalPalettes = this.palettesManager.getGlobalPalettes();
            ArrayList paletteBuilder = new ArrayList();
            for (HashMap<String, String> palette : globalPalettes) {
                HashMap<String, String> entry = new HashMap<String, String>();
                String id = palette.get("id");
                entry.put("id", id);
                entry.put("name", palette.get("name"));
                entry.put("canEdit", this.palettesManager.canEditGlobalPalette(id) ? "true" : "false");
                entry.put("owner", palette.get("ownerName"));
                paletteBuilder.add(entry);
            }
            this.sendSuccess(resp, paletteBuilder);
        } else if (GET_CREATE_PERMISSION.equals(actionParam)) {
            String hasCreatePermission = this.palettesManager.canManageGlobalPalettes() ? "true" : "false";
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("createGlobalPalettePermission", hasCreatePermission);
            this.sendSuccess(resp, entry);
        } else if (GET_BUILT_IN_PALETTES.equals(actionParam)) {
            HashMap<String, String> palettesSettings = this.palettesManager.getBuiltInPalettesSettings();
            HashMap<String, String> response = new HashMap<String, String>();
            for (String name : palettesSettings.keySet()) {
                response.put(name, palettesSettings.get(name));
            }
            this.sendSuccess(resp, response);
        } else {
            this.sendError(resp, "GlobalPalettesServlet: Invalid Request");
        }
    }

    private void sendSuccess(HttpServletResponse response, Object data) throws IOException {
        this.sendResponse(response, "success", null, data);
    }

    private void sendError(HttpServletResponse response, String cause) throws IOException {
        this.sendResponse(response, "error", cause, null);
    }

    private void sendResponse(HttpServletResponse resp, String result, String cause, Object data) throws IOException {
        ServletOutputStream outputStream = resp.getOutputStream();
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("result", result);
        responseMap.put("cause", cause);
        responseMap.put("data", data);
        outputStream.print(this.gson.toJson(responseMap));
        outputStream.flush();
        outputStream.close();
    }
}

