/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.yworks.plugins.confluence.helper.LicenseHelper;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentVersionServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AttachmentVersionServlet.class);
    private final AttachmentManager attachmentManager;
    private final PageManager pageManager;
    private final PluginLicenseManager pluginLicenseManager;

    public AttachmentVersionServlet(@ComponentImport AttachmentManager attachmentManager, @ComponentImport PageManager pageManager, @ComponentImport PluginLicenseManager pluginLicenseManager) {
        this.attachmentManager = attachmentManager;
        this.pageManager = pageManager;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean hasId;
        resp.setContentType("text/plain");
        LicenseHelper licenseHelper = new LicenseHelper(this.pluginLicenseManager);
        if (!licenseHelper.isValidLicense()) {
            this.sendResponse(resp, "error", "License Error: " + licenseHelper.getErrorString());
            return;
        }
        String name = req.getParameter("name");
        String pageId = req.getParameter("pageId");
        String diagramId = req.getParameter("diagramId");
        if (pageId == null) {
            this.sendResponse(resp, "error", "No filename or page specified.");
            return;
        }
        Page page = this.pageManager.getPage(Long.parseLong(pageId));
        Attachment attachment = this.attachmentManager.getAttachment((ContentEntityObject)page, ((hasId = diagramId != null && !diagramId.isEmpty()) ? diagramId : name) + ".zip");
        if (attachment == null) {
            this.sendResponse(resp, "error", "Attachment not found.");
            return;
        }
        this.sendSuccess(resp, attachment.getVersion());
    }

    private void sendResponse(HttpServletResponse resp, String result, String cause) throws IOException {
        ServletOutputStream outputStream = resp.getOutputStream();
        StringBuilder response = new StringBuilder();
        response.append("{\"result\":\"").append(result).append("\"");
        if (cause != null) {
            response.append(", \"cause\":\"").append(cause).append("\"");
        }
        response.append("}");
        outputStream.print(response.toString());
        outputStream.flush();
        outputStream.close();
    }

    private void sendSuccess(HttpServletResponse resp, int version) throws IOException {
        ServletOutputStream outputStream = resp.getOutputStream();
        String response = "{\"result\":\"success\", \"version\":\"" + version + "\"}";
        outputStream.print(response);
        outputStream.flush();
        outputStream.close();
    }
}

