/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.yworks.plugins.confluence.helper.LicenseHelper;
import com.yworks.plugins.confluence.helper.PalettesManager;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApplicationDataServlet
extends HttpServlet {
    private static final String APP_STATES_KEY = "com.yworks.plugins.confluence.ManageAppStateServlet.APP_STATES_KEY";
    private static final String CUSTOM_PALETTES_KEY = "com.yworks.plugins.confluence.ManageAppStateServlet.CUSTOM_PALETTES_KEY";
    private static final String MODE_STORE_APP_STATE = "storeAppState";
    private static final String MODE_LOAD_APP_STATE = "loadAppState";
    private static final String MODE_DELETE_APP_STATE = "deleteAppState";
    private static final String MODE_STORE_CUSTOM_PALETTE = "storeCustomPalette";
    private static final String MODE_LOAD_CUSTOM_PALETTE = "loadCustomPalette";
    private static final String MODE_DELETE_CUSTOM_PALETTE = "deleteCustomPalette";
    private final BandanaManager bandanaManager;
    private final PluginLicenseManager pluginLicenseManager;

    public ApplicationDataServlet(@ComponentImport BandanaManager bandanaManager, @ComponentImport PluginLicenseManager pluginLicenseManager) {
        this.bandanaManager = bandanaManager;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LicenseHelper licenseHelper = new LicenseHelper(this.pluginLicenseManager);
        if (!licenseHelper.isValidLicense()) {
            this.sendResponse(resp, "error", "License Error: " + licenseHelper.getErrorString());
            return;
        }
        HashMap<String, String> appStates = PalettesManager.getStoredStrings(APP_STATES_KEY, this.bandanaManager);
        HashMap<String, HashMap<String, String>> customPalettes = PalettesManager.getStoredMaps(CUSTOM_PALETTES_KEY, this.bandanaManager);
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser == null) {
            this.sendResponse(resp, "error", "anonymous user");
            return;
        }
        String userKey = confluenceUser.getKey().getStringValue();
        String modeParam = req.getParameter("mode");
        String dataParam = req.getParameter("data");
        String idParam = req.getParameter("id");
        switch (modeParam) {
            case "storeAppState": {
                if (dataParam != null) {
                    appStates.put(userKey, dataParam);
                    this.sendSuccess(resp);
                    break;
                }
                this.sendResponse(resp, "error", "The app state data was not received.");
                break;
            }
            case "loadAppState": {
                String appState = appStates.get(userKey);
                this.sendResponse(resp, "success", appState);
                break;
            }
            case "deleteAppState": {
                appStates.remove(userKey);
                this.sendSuccess(resp);
                break;
            }
            case "storeCustomPalette": {
                HashMap<String, String> palettes = customPalettes.get(userKey);
                if (palettes == null) {
                    palettes = new HashMap();
                }
                palettes.put(idParam, dataParam == null ? "" : dataParam);
                customPalettes.put(userKey, palettes);
                this.sendSuccess(resp);
                break;
            }
            case "loadCustomPalette": {
                HashMap<String, String> palettes = customPalettes.get(userKey);
                if (palettes != null) {
                    String palette = palettes.get(idParam);
                    this.sendResponse(resp, "success", palette);
                    break;
                }
                this.sendSuccess(resp);
                break;
            }
            case "deleteCustomPalette": {
                HashMap<String, String> palettes = customPalettes.get(userKey);
                if (palettes != null) {
                    palettes.remove(idParam);
                    customPalettes.put(userKey, palettes);
                    this.sendSuccess(resp);
                    break;
                }
                this.sendSuccess(resp);
                break;
            }
            default: {
                this.sendResponse(resp, "error", "The data was not received. Probably the POST limit was exceeded.");
            }
        }
        PalettesManager.setStoredStrings(APP_STATES_KEY, this.bandanaManager, appStates);
        PalettesManager.setStoredMaps(CUSTOM_PALETTES_KEY, this.bandanaManager, customPalettes);
    }

    private void sendSuccess(HttpServletResponse resp) throws IOException {
        this.sendResponse(resp, "success", null);
    }

    private void sendResponse(HttpServletResponse resp, String result, String data) throws IOException {
        ServletOutputStream outputStream = resp.getOutputStream();
        StringBuilder response = new StringBuilder();
        response.append("{\"result\":\"").append(result).append("\"");
        if (data != null) {
            response.append(", \"data\":\"").append(data).append("\"");
        }
        response.append("}");
        outputStream.print(response.toString());
        outputStream.flush();
        outputStream.close();
    }
}

