/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.User;
import com.atlassian.xwork.ParameterSafe;
import com.yworks.plugins.confluence.helper.LicenseHelper;
import com.yworks.plugins.confluence.helper.URLEncoder;
import java.io.UnsupportedEncodingException;

public class AddDiagramAction
extends ConfluenceActionSupport
implements PageAware {
    private final PluginAccessor pluginManager;
    private final ConfluenceUser confluenceUser;
    private final AttachmentManager attachmentManager;
    private final PluginLicenseManager pluginLicenseManager;
    private final GlobalSettingsManager myGlobalSettingsManager;
    public static final String INSUFFICIENT_PERMISSIONS = "com.yworks.plugins.confluence.graphity.insufficientpermissions";
    private AbstractPage page;
    private boolean licenseValid;
    protected String diagramName;
    protected String macroId;
    protected String diagramId;
    protected String mode;
    protected String resourceRoot;
    protected String confluenceRoot;
    protected String servletRoot;
    private String failureReason = null;

    public AddDiagramAction(@ComponentImport PluginAccessor pluginManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport UserAccessor userAccessor) {
        this.pluginManager = pluginManager;
        this.attachmentManager = attachmentManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.userAccessor = userAccessor;
        this.confluenceUser = userAccessor.getUserByName(AuthenticatedUserThreadLocal.getUsername());
        this.myGlobalSettingsManager = (GlobalSettingsManager)ComponentLocator.getComponent(GlobalSettingsManager.class);
    }

    @ParameterSafe
    public AbstractPage getPage() {
        return this.page;
    }

    @ParameterSafe
    public void setPage(AbstractPage page) {
        this.page = page;
    }

    @ParameterSafe
    public boolean isPageRequired() {
        return true;
    }

    @ParameterSafe
    public boolean isLatestVersionRequired() {
        return true;
    }

    @ParameterSafe
    public boolean isViewPermissionRequired() {
        return true;
    }

    private Plugin getPlugin() {
        return this.pluginManager.getPlugin("com.yworks.plugins.confluence.graphity");
    }

    public String execute() throws Exception {
        if (this.page == null || !this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)this.page)) {
            this.failureReason = INSUFFICIENT_PERMISSIONS;
            return "error";
        }
        LicenseHelper licenseHelper = new LicenseHelper(this.pluginLicenseManager);
        this.licenseValid = licenseHelper.isValidLicense();
        if (this.licenseValid) {
            this.failureReason = null;
            return "success";
        }
        this.failureReason = licenseHelper.getErrorString();
        return "error";
    }

    @ParameterSafe
    public String getBaseUrl() {
        return this.myGlobalSettingsManager.getGlobalSettings().getBaseUrl();
    }

    @ParameterSafe
    public String getResourceRoot() {
        return this.resourceRoot;
    }

    @ParameterSafe
    public void setResourceRoot(String resourceRoot) {
        this.resourceRoot = resourceRoot;
    }

    @ParameterSafe
    public String getConfluenceRoot() {
        return this.confluenceRoot;
    }

    @ParameterSafe
    public void setConfluenceRoot(String confluenceRoot) {
        this.confluenceRoot = confluenceRoot;
    }

    @ParameterSafe
    public String getServletRoot() {
        return this.servletRoot;
    }

    @ParameterSafe
    public void setServletRoot(String servletRoot) {
        this.servletRoot = servletRoot;
    }

    @ParameterSafe
    public String getUserId() {
        return AuthenticatedUserThreadLocal.getUsername();
    }

    @ParameterSafe
    public void setUserId(String userId) {
    }

    @ParameterSafe
    public String getConfluenceUsername() {
        return this.confluenceUser != null ? this.confluenceUser.getName() : "Anonymous";
    }

    @ParameterSafe
    public String getConfluenceUserFullName() {
        return this.confluenceUser != null ? this.confluenceUser.getFullName() : "Anonymous user";
    }

    @ParameterSafe
    public String getConfluenceUserMail() {
        return this.confluenceUser != null ? this.confluenceUser.getEmail() : "";
    }

    @ParameterSafe
    public String getConfluenceProfilePicture() {
        if (this.confluenceUser != null) {
            return this.userAccessor.getUserProfilePicture((User)this.confluenceUser).getUriReference();
        }
        return this.confluenceRoot + "/download/resources/com.yworks.plugins.confluence.graphity/icons/anonymous.svg";
    }

    @ParameterSafe
    public String getPageId() {
        return this.page.getIdAsString();
    }

    @ParameterSafe
    public String getPageUrl() {
        return this.page.getUrlPath();
    }

    @ParameterSafe
    public boolean isLicenseValid() {
        return this.licenseValid;
    }

    @ParameterSafe
    public String getDiagramName() {
        return this.diagramName;
    }

    @ParameterSafe
    public String getMacroId() {
        return this.macroId;
    }

    @ParameterSafe
    public String getDiagramId() {
        return this.diagramId;
    }

    @ParameterSafe
    public String getMode() {
        return this.mode;
    }

    @ParameterSafe
    public String getEncodedDiagramName() {
        return URLEncoder.encode(this.diagramName);
    }

    @ParameterSafe
    public void setDiagramName(String name) {
        try {
            String decodedName = new String(name.getBytes("ISO-8859-1"), "UTF-8");
            if (!decodedName.contains("\ufffd")) {
                name = decodedName;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.diagramName = name;
    }

    @ParameterSafe
    public void setDiagramId(String id) {
        this.diagramId = id;
    }

    @ParameterSafe
    public void setMacroId(String id) {
        this.macroId = id;
    }

    @ParameterSafe
    public void setMode(String mode) {
        this.mode = mode;
    }

    @ParameterSafe
    public String getFailureReason() {
        return this.failureReason;
    }

    public String getPalettes() {
        String diagramName = this.getDiagramName();
        if (diagramName == null || diagramName == "") {
            return "";
        }
        String fileName = diagramName + "_palettes.json";
        Attachment attachment = this.attachmentManager.getAttachment((ContentEntityObject)this.page, fileName);
        if (attachment != null) {
            return this.getBaseUrl() + this.attachmentManager.getAttachmentDownloadPath((ContentEntityObject)this.page, fileName);
        }
        return "";
    }

    @ParameterSafe
    public String getYedLiveRoot() {
        return this.getBaseUrl() + "/download/resources/com.yworks.plugins.confluence.graphity/yedlive/";
    }
}

