/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence.helper;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.yworks.plugins.confluence.AdminAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class PalettesManager {
    public static final String BUILT_IN_PALETTES_KEY = "com.yworks.plugins.confluence.helper.PalettesHelper.BUILT_IN_PALETTES_KEY";
    private static final String GLOBAL_PALETTES_KEY = "com.yworks.plugins.confluence.helper.PalettesHelper.GLOBAL_PALETTES_KEY";
    private final BandanaManager bandanaManager;
    private final PermissionManager permissionManager;
    private String[] builtInPalettes;
    private HashMap<String, String> builtInPaletteNames;

    public PalettesManager(BandanaManager bandanaManager, PermissionManager permissionManager) {
        this.bandanaManager = bandanaManager;
        this.permissionManager = permissionManager;
    }

    public HashMap<String, String> addGlobalPalette(String paletteId, String name, String graphml) {
        String id;
        if (!this.canManageGlobalPalettes()) {
            throw new RuntimeException("The current user has no rights to add global palettes.");
        }
        HashMap<String, String> palette = null;
        if (paletteId != null) {
            id = paletteId;
            HashMap<String, String> oldPalette = this.getGlobalPalette(id);
            if (oldPalette != null) {
                oldPalette.put("graphml", graphml);
                oldPalette.put("name", name);
                palette = oldPalette;
            }
        } else {
            id = String.valueOf(System.currentTimeMillis());
        }
        if (palette == null) {
            palette = new HashMap<String, String>();
            palette.put("graphml", graphml);
            palette.put("id", id);
            palette.put("name", name);
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            if (confluenceUser != null) {
                UserKey key = confluenceUser.getKey();
                palette.put("ownerKey", key.getStringValue());
                palette.put("ownerName", confluenceUser.getName());
            } else {
                palette.put("ownerKey", null);
                palette.put("ownerName", "anonymous");
            }
        }
        HashMap<String, HashMap<String, String>> globalPalettes = PalettesManager.getStoredMaps(GLOBAL_PALETTES_KEY, this.bandanaManager);
        globalPalettes.put(id, palette);
        PalettesManager.setStoredMaps(GLOBAL_PALETTES_KEY, this.bandanaManager, globalPalettes);
        return palette;
    }

    public void removeGlobalPalette(String paletteId) {
        if (!this.canEditGlobalPalette(paletteId)) {
            throw new RuntimeException("The current user has no edit rights for this palette");
        }
        HashMap<String, HashMap<String, String>> globalPalettes = PalettesManager.getStoredMaps(GLOBAL_PALETTES_KEY, this.bandanaManager);
        globalPalettes.remove(paletteId);
        PalettesManager.setStoredMaps(GLOBAL_PALETTES_KEY, this.bandanaManager, globalPalettes);
    }

    public HashMap<String, String> getGlobalPalette(String paletteId) {
        HashMap<String, HashMap<String, String>> globalPalettes = PalettesManager.getStoredMaps(GLOBAL_PALETTES_KEY, this.bandanaManager);
        return globalPalettes.get(paletteId);
    }

    public List<HashMap<String, String>> getGlobalPalettes() {
        HashMap<String, HashMap<String, String>> globalPalettes = PalettesManager.getStoredMaps(GLOBAL_PALETTES_KEY, this.bandanaManager);
        ArrayList<HashMap<String, String>> palettes = new ArrayList<HashMap<String, String>>();
        Set<String> paletteIds = globalPalettes.keySet();
        for (String paletteId : paletteIds) {
            HashMap<String, String> palette = globalPalettes.get(paletteId);
            palettes.add(palette);
        }
        return palettes;
    }

    public Set<String> getGlobalPalettesIds() {
        HashMap<String, HashMap<String, String>> globalPalettes = PalettesManager.getStoredMaps(GLOBAL_PALETTES_KEY, this.bandanaManager);
        return globalPalettes.keySet();
    }

    public boolean canManageGlobalPalettes() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (this.permissionManager.isConfluenceAdministrator((User)user)) {
            return true;
        }
        HashMap<String, String> adminSettings = AdminAction.getAdminSettings(this.bandanaManager);
        String property = adminSettings.get("createGlobalPalettePermissions");
        return "AllUsers".equals(property);
    }

    public boolean canEditGlobalPalette(String paletteId) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return false;
        }
        if (this.permissionManager.isConfluenceAdministrator((User)user)) {
            return true;
        }
        HashMap<String, HashMap<String, String>> globalPalettes = PalettesManager.getStoredMaps(GLOBAL_PALETTES_KEY, this.bandanaManager);
        HashMap<String, String> palette = globalPalettes.get(paletteId);
        String ownerKey = palette.get("ownerKey");
        HashMap<String, String> adminSettings = AdminAction.getAdminSettings(this.bandanaManager);
        String property = adminSettings.get("createGlobalPalettePermissions");
        return "AllUsers".equals(property) && ownerKey.equals(user.getKey().getStringValue());
    }

    public HashMap<String, String> getBuiltInPalettesSettings() {
        HashMap<String, String> builtInPalettes = PalettesManager.getStoredStrings(BUILT_IN_PALETTES_KEY, this.bandanaManager);
        if (builtInPalettes.isEmpty()) {
            for (String builtInPalette : this.getBuiltInPalettes()) {
                builtInPalettes.put(builtInPalette, "true");
            }
        }
        return builtInPalettes;
    }

    public String[] getBuiltInPalettes() {
        if (this.builtInPalettes == null) {
            this.builtInPalettes = new String[]{"recently-used", "shape-nodes", "shiny-nodes", "flowchart-nodes", "mind-map", "network-nodes", "people", "groups", "uml", "bpmn", "entity-relationship", "table-nodes", "edges", "straight-line-edges", "font-awesome-alert", "font-awesome-arrows", "font-awesome-automotive", "font-awesome-buildings", "font-awesome-business", "font-awesome-chat", "font-awesome-clothing", "font-awesome-code", "font-awesome-communication", "font-awesome-computers", "font-awesome-currency", "font-awesome-datetime", "font-awesome-editors", "font-awesome-education", "font-awesome-emoji", "font-awesome-files", "font-awesome-finance", "font-awesome-household", "font-awesome-interfaces", "font-awesome-logistics", "font-awesome-maritime", "font-awesome-marketing", "font-awesome-mathematics", "font-awesome-medical", "font-awesome-music", "font-awesome-shopping", "font-awesome-pharmacy", "font-awesome-political", "font-awesome-science", "font-awesome-security", "font-awesome-social", "font-awesome-sports", "font-awesome-status", "font-awesome-travel", "font-awesome-people", "font-awesome-vehicles", "font-awesome-weather", "aws-application-integration", "ar-vr", "aws-cost-management", "aws-blockchain", "aws-business-applications", "aws-compute", "aws-customer-enablement", "aws-customer-engagement", "aws-database", "aws-developer-tools", "aws-end-user-computing", "aws-game-tech-icons", "aws-internet-of-things", "aws-machine-learning", "aws-management-governance", "aws-media-services", "aws-migration-transfer", "aws-mobile", "aws-networking-content-delivery", "aws-robotics", "aws-satellite", "aws-security-identity-compliance", "aws-storage", "cisco-network-topology-icons"};
        }
        return this.builtInPalettes;
    }

    public HashMap<String, String> getBuiltInPaletteNames() {
        if (this.builtInPaletteNames == null) {
            this.builtInPaletteNames = new HashMap();
            this.builtInPaletteNames.put("recently-used", "Recently Used");
            this.builtInPaletteNames.put("shape-nodes", "Shape Nodes");
            this.builtInPaletteNames.put("shiny-nodes", "Shiny Nodes");
            this.builtInPaletteNames.put("flowchart-nodes", "Flowchart Nodes");
            this.builtInPaletteNames.put("mind-map", "Mind Map");
            this.builtInPaletteNames.put("network-nodes", "Network Nodes");
            this.builtInPaletteNames.put("people", "People");
            this.builtInPaletteNames.put("groups", "Groups");
            this.builtInPaletteNames.put("uml", "UML");
            this.builtInPaletteNames.put("bpmn", "BPMN");
            this.builtInPaletteNames.put("entity-relationship", "Entity Relationship");
            this.builtInPaletteNames.put("table-nodes", "Table Nodes");
            this.builtInPaletteNames.put("edges", "Edges");
            this.builtInPaletteNames.put("straight-line-edges", "Straight-line Edges");
            this.builtInPaletteNames.put("font-awesome-alert", "Font Awesome Alert");
            this.builtInPaletteNames.put("font-awesome-arrows", "Font Awesome Arrows");
            this.builtInPaletteNames.put("font-awesome-automotive", "Font Awesome Automotive");
            this.builtInPaletteNames.put("font-awesome-buildings", "Font Awesome Buildings");
            this.builtInPaletteNames.put("font-awesome-business", "Font Awesome Business");
            this.builtInPaletteNames.put("font-awesome-chat", "Font Awesome Chat");
            this.builtInPaletteNames.put("font-awesome-clothing", "Font Awesome Clothing");
            this.builtInPaletteNames.put("font-awesome-code", "Font Awesome Code");
            this.builtInPaletteNames.put("font-awesome-communication", "Font Awesome Communication");
            this.builtInPaletteNames.put("font-awesome-computers", "Font Awesome Computers");
            this.builtInPaletteNames.put("font-awesome-currency", "Font Awesome Currency");
            this.builtInPaletteNames.put("font-awesome-datetime", "Font Awesome Date-Time");
            this.builtInPaletteNames.put("font-awesome-editors", "Font Awesome Editors");
            this.builtInPaletteNames.put("font-awesome-education", "Font Awesome Education");
            this.builtInPaletteNames.put("font-awesome-emoji", "Font Awesome Emoji");
            this.builtInPaletteNames.put("font-awesome-files", "Font Awesome Files");
            this.builtInPaletteNames.put("font-awesome-finance", "Font Awesome Finance");
            this.builtInPaletteNames.put("font-awesome-household", "Font Awesome Household");
            this.builtInPaletteNames.put("font-awesome-interfaces", "Font Awesome Interfaces");
            this.builtInPaletteNames.put("font-awesome-logistics", "Font Awesome Logistics");
            this.builtInPaletteNames.put("font-awesome-maritime", "Font Awesome Maritime");
            this.builtInPaletteNames.put("font-awesome-marketing", "Font Awesome Marketing");
            this.builtInPaletteNames.put("font-awesome-mathematics", "Font Awesome Mathematics");
            this.builtInPaletteNames.put("font-awesome-medical", "Font Awesome Medical");
            this.builtInPaletteNames.put("font-awesome-music", "Font Awesome Music");
            this.builtInPaletteNames.put("font-awesome-shopping", "Font Awesome Shopping");
            this.builtInPaletteNames.put("font-awesome-pharmacy", "Font Awesome Pharmacy");
            this.builtInPaletteNames.put("font-awesome-political", "Font Awesome Political");
            this.builtInPaletteNames.put("font-awesome-science", "Font Awesome Science");
            this.builtInPaletteNames.put("font-awesome-security", "Font Awesome Security");
            this.builtInPaletteNames.put("font-awesome-social", "Font Awesome Social");
            this.builtInPaletteNames.put("font-awesome-sports", "Font Awesome Sports");
            this.builtInPaletteNames.put("font-awesome-status", "Font Awesome Status");
            this.builtInPaletteNames.put("font-awesome-travel", "Font Awesome Travel");
            this.builtInPaletteNames.put("font-awesome-people", "Font Awesome People");
            this.builtInPaletteNames.put("font-awesome-vehicles", "Font Awesome Vehicles");
            this.builtInPaletteNames.put("font-awesome-weather", "Font Awesome Weather");
            this.builtInPaletteNames.put("aws-analytics", "AWS Analytics");
            this.builtInPaletteNames.put("aws-application-integration", "AWS Application Integration");
            this.builtInPaletteNames.put("ar-vr", "AWS AR & VR");
            this.builtInPaletteNames.put("aws-cost-management", "AWS Cost Management");
            this.builtInPaletteNames.put("aws-blockchain", "AWS Blockchain");
            this.builtInPaletteNames.put("aws-business-applications", "AWS Business Applications");
            this.builtInPaletteNames.put("aws-compute", "AWS Compute");
            this.builtInPaletteNames.put("aws-customer-enablement", "AWS Customer Enablement");
            this.builtInPaletteNames.put("aws-customer-engagement", "AWS Customer Engagement");
            this.builtInPaletteNames.put("aws-database", "AWS Database");
            this.builtInPaletteNames.put("aws-developer-tools", "AWS Developer Tools");
            this.builtInPaletteNames.put("aws-end-user-computing", "AWS End User Computing");
            this.builtInPaletteNames.put("aws-game-tech-icons", "AWS Game Tech");
            this.builtInPaletteNames.put("aws-internet-of-things", "AWS Internet of Things");
            this.builtInPaletteNames.put("aws-machine-learning", "AWS Machine Learning");
            this.builtInPaletteNames.put("aws-management-governance", "AWS Management & Governance");
            this.builtInPaletteNames.put("aws-media-services", "AWS Media Services");
            this.builtInPaletteNames.put("aws-migration-transfer", "AWS Migration & Transfer");
            this.builtInPaletteNames.put("aws-mobile", "AWS Mobile");
            this.builtInPaletteNames.put("aws-networking-content-delivery", "AWS Networking & Content Delivery");
            this.builtInPaletteNames.put("aws-robotics", "AWS Robotics");
            this.builtInPaletteNames.put("aws-satellite", "AWS Satellite");
            this.builtInPaletteNames.put("aws-security-identity-compliance", "AWS Security, Identity, & Compliance");
            this.builtInPaletteNames.put("aws-storage", "AWS Storage");
            this.builtInPaletteNames.put("cisco-network-topology-icons", "Cisco Network Topology Icons");
        }
        return this.builtInPaletteNames;
    }

    public static HashMap<String, String> getStoredStrings(String key, BandanaManager bandanaManager) {
        if (bandanaManager != null) {
            Object o = bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), key);
            if (o instanceof HashMap) {
                return (HashMap)o;
            }
            if (o instanceof Properties) {
                Properties properties = (Properties)o;
                Set<String> propertyNames = properties.stringPropertyNames();
                HashMap<String, String> map = new HashMap<String, String>();
                for (String propertyName : propertyNames) {
                    map.put(propertyName, properties.getProperty(propertyName));
                }
                return map;
            }
        }
        return new HashMap<String, String>();
    }

    public static HashMap<String, HashMap<String, String>> getStoredMaps(String key, BandanaManager bandanaManager) {
        Object o;
        if (bandanaManager != null && (o = bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), key)) instanceof HashMap) {
            return (HashMap)o;
        }
        return new HashMap<String, HashMap<String, String>>();
    }

    public static void setStoredStrings(String key, BandanaManager bandanaManager, HashMap<String, String> strings) {
        bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), key, strings);
    }

    public static void setStoredMaps(String key, BandanaManager bandanaManager, HashMap<String, HashMap<String, String>> maps) {
        bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), key, maps);
    }
}

