/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence.helper;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.yworks.plugins.confluence.helper.PageUtilsV7;
import com.yworks.plugins.confluence.helper.PageUtilsV8;
import java.util.List;
import java.util.Set;

public class PageUtils {
    public static void findPages(SearchManager searchManager, SearchQuery query, CreatedSort createdSort, Set<Page> pages) throws InvalidSearchException {
        ContentSearch search = PageUtils.createContentSearch(query, (SearchSort)createdSort, Integer.MAX_VALUE, false);
        List entities = searchManager.searchEntities((ISearch)search, SearchManager.EntityVersionPolicy.LATEST_VERSION);
        if (entities != null) {
            entities.forEach(s -> {
                if (s instanceof Page) {
                    pages.add((Page)s);
                }
            });
        }
    }

    public static ContentSearch createContentSearch(SearchQuery query, SearchSort createdSort, int maxResults, boolean filterSpacePermissions) throws InvalidSearchException {
        try {
            return PageUtilsV7.createContentSearch(query, createdSort, maxResults, filterSpacePermissions);
        }
        catch (InvalidSearchException e) {
            return PageUtilsV8.createContentSearch(query, createdSort, maxResults, filterSpacePermissions);
        }
    }
}

