/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence.helper;

import com.atlassian.confluence.license.validator.LicenseValidator;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseHelper {
    private static final boolean LICENSING_ENABLED = true;
    private static final Logger log = LoggerFactory.getLogger(LicenseValidator.class);
    public static final String LICENSE_ERROR_NO_LICENSE = "com.yworks.plugins.confluence.graphity.license.error.no_license";
    public static final String LICENSE_ERROR_EXPIRED = "com.yworks.plugins.confluence.graphity.license.error.expired";
    public static final String LICENSE_ERROR_TYPE_MISMATCH = "com.yworks.plugins.confluence.graphity.license.error.type_mismatch";
    public static final String LICENSE_ERROR_USER_MISMATCH = "com.yworks.plugins.confluence.graphity.license.error.user_mismatch";
    public static final String LICENSE_ERROR_EDITION_MISMATCH = "com.yworks.plugins.confluence.graphity.license.error.edition_mismatch";
    public static final String LICENSE_ERROR_ROLE_EXCEEDED = "com.yworks.plugins.confluence.graphity.license.error.role_exceeded";
    public static final String LICENSE_ERROR_ROLE_UNDEFINED = "com.yworks.plugins.confluence.graphity.license.error.role_undefined";
    public static final String LICENSE_ERROR_VERSION_MISMATCH = "com.yworks.plugins.confluence.graphity.license.error.version_mismatch";
    public static final String LICENSE_ERROR_GENERIC = "com.yworks.plugins.confluence.graphity.license.error.generic";
    private final PluginLicenseManager licenseManager;

    public LicenseHelper(PluginLicenseManager pluginLicenseManager) {
        this.licenseManager = pluginLicenseManager;
    }

    public boolean isValidLicense() {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.licenseManager.getLicense().get();
            return !license.getError().isDefined();
        }
        return false;
    }

    public Option<LicenseError> getErrorCondition() {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.licenseManager.getLicense().get();
            Option error = license.getError();
            if (error.isDefined()) {
                return error;
            }
            return null;
        }
        return null;
    }

    public String getErrorString() {
        Option<LicenseError> condition = this.getErrorCondition();
        if (condition == null) {
            return LICENSE_ERROR_NO_LICENSE;
        }
        switch ((LicenseError)condition.get()) {
            case EXPIRED: {
                return LICENSE_ERROR_EXPIRED;
            }
            case TYPE_MISMATCH: {
                return LICENSE_ERROR_TYPE_MISMATCH;
            }
            case USER_MISMATCH: {
                return LICENSE_ERROR_USER_MISMATCH;
            }
            case EDITION_MISMATCH: {
                return LICENSE_ERROR_EDITION_MISMATCH;
            }
            case ROLE_EXCEEDED: {
                return LICENSE_ERROR_ROLE_EXCEEDED;
            }
            case ROLE_UNDEFINED: {
                return LICENSE_ERROR_ROLE_UNDEFINED;
            }
            case VERSION_MISMATCH: {
                return LICENSE_ERROR_VERSION_MISMATCH;
            }
        }
        return LICENSE_ERROR_GENERIC;
    }
}

