/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence.data;

import org.apache.commons.lang.StringEscapeUtils;

public class GraphityMacroBody {
    private String name;
    private String diagramId;
    private String alignParam;
    private boolean floatParam;
    private String widthParam;
    private String heightParam;
    private String maxWidthParam;
    private String maxHeightParam;
    private String displayFormatParam;
    private boolean linksParam;
    private boolean linksInNewWindowParam;
    private boolean tooltipsParam;
    private boolean toolbarParam;
    private boolean overviewParam;
    private boolean navigationParam;
    private String theme;
    private boolean displayNameParam;
    private int attachmentVersion;

    public GraphityMacroBody(String name) {
        this.name = name;
    }

    public String getConfluence6String(String macroId) {
        String name = StringEscapeUtils.escapeHtml((String)this.name);
        StringBuilder macro = new StringBuilder("<ac:structured-macro ac:name=\"graphity\" ac:schema-version=\"1\" ac:macro-id=\"" + macroId + "\"> <ac:parameter ac:name=\"name\">" + name + "</ac:parameter>");
        if (this.alignParam != null && this.alignParam.length() > 0 && !"left".equals(this.alignParam)) {
            macro.append("<ac:parameter ac:name=\"align\">").append(this.alignParam).append("</ac:parameter>");
        }
        if (this.floatParam) {
            macro.append("<ac:parameter ac:name=\"float\">").append(this.floatParam).append("</ac:parameter>");
        }
        if (this.widthParam != null && this.widthParam.length() > 0) {
            macro.append("<ac:parameter ac:name=\"width\">").append(this.widthParam).append("</ac:parameter>");
        }
        if (this.heightParam != null && this.heightParam.length() > 0) {
            macro.append("<ac:parameter ac:name=\"height\">").append(this.heightParam).append("</ac:parameter>");
        }
        if (this.maxWidthParam != null && this.maxWidthParam.length() > 0 && !"100%".equals(this.maxWidthParam)) {
            macro.append("<ac:parameter ac:name=\"max-width\">").append(this.maxWidthParam).append("</ac:parameter>");
        }
        if (this.maxHeightParam != null && this.maxHeightParam.length() > 0) {
            macro.append("<ac:parameter ac:name=\"max-height\">").append(this.maxHeightParam).append("</ac:parameter>");
        }
        if ("interactive".equals(this.displayFormatParam)) {
            macro.append("<ac:parameter ac:name=\"display-format\">interactive</ac:parameter>");
            macro.append("<ac:parameter ac:name=\"links\">").append(String.valueOf(this.linksParam)).append("</ac:parameter>");
            macro.append("<ac:parameter ac:name=\"linksInNewWindow\">").append(String.valueOf(this.linksInNewWindowParam)).append("</ac:parameter>");
            macro.append("<ac:parameter ac:name=\"tooltips\">").append(String.valueOf(this.tooltipsParam)).append("</ac:parameter>");
            macro.append("<ac:parameter ac:name=\"toolbar\">").append(String.valueOf(this.toolbarParam)).append("</ac:parameter>");
            macro.append("<ac:parameter ac:name=\"overview\">").append(String.valueOf(this.overviewParam)).append("</ac:parameter>");
            macro.append("<ac:parameter ac:name=\"navigation\">").append(String.valueOf(this.navigationParam)).append("</ac:parameter>");
        } else {
            macro.append("<ac:parameter ac:name=\"display-format\">image</ac:parameter>");
        }
        if (!this.displayNameParam) {
            macro.append("<ac:parameter ac:name=\"displayName\">false</ac:parameter>");
        }
        if (this.theme != null) {
            macro.append("<ac:parameter ac:name=\"theme\">").append(this.theme).append("</ac:parameter>");
        }
        macro.append("<ac:parameter ac:name=\"diagramId\">").append(this.diagramId).append("</ac:parameter>");
        macro.append("<ac:parameter ac:name=\"version\">").append(this.attachmentVersion).append("</ac:parameter>");
        macro.append("</ac:structured-macro>");
        return macro.toString();
    }

    public void setDiagramIdParam(String diagramId) {
        this.diagramId = diagramId;
    }

    public void setAlignParam(String alignParam) {
        this.alignParam = alignParam;
    }

    public void setFloatParam(boolean floatParam) {
        this.floatParam = floatParam;
    }

    public void setWidthParam(String widthParam) {
        this.widthParam = widthParam;
    }

    public void setHeightParam(String heightParam) {
        this.heightParam = heightParam;
    }

    public void setMaxWidthParam(String maxWidthParam) {
        this.maxWidthParam = maxWidthParam;
    }

    public void setMaxHeightParam(String maxHeightParam) {
        this.maxHeightParam = maxHeightParam;
    }

    public void setDisplayFormatParam(String displayFormatParam) {
        this.displayFormatParam = displayFormatParam;
    }

    public void setLinksParam(boolean linksParam) {
        this.linksParam = linksParam;
    }

    public void setLinksInNewWindowParam(boolean linksInNewWindowParam) {
        this.linksInNewWindowParam = linksInNewWindowParam;
    }

    public void setTooltipsParam(boolean tooltipsParam) {
        this.tooltipsParam = tooltipsParam;
    }

    public void setToolbarParam(boolean toolbarParam) {
        this.toolbarParam = toolbarParam;
    }

    public void setDisplayNameParam(boolean displayNameParam) {
        this.displayNameParam = displayNameParam;
    }

    public void setOverviewParam(boolean overviewParam) {
        this.overviewParam = overviewParam;
    }

    public void setNavigationParam(boolean navigationParam) {
        this.navigationParam = navigationParam;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setThemeParam(String theme) {
        this.theme = theme;
    }

    public void setAttachmentVersionParam(int version) {
        this.attachmentVersion = version;
    }
}

