/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.User;
import com.yworks.plugins.confluence.AdminAction;
import com.yworks.plugins.confluence.helper.LicenseHelper;
import java.util.HashMap;
import java.util.Map;

public class ShowNewDiagramItemInPageMenuCondition
extends BaseConfluenceCondition {
    private final PluginLicenseManager pluginLicenseManager;
    private final PermissionManager permissionManager;
    private final BandanaManager bandanaManager;
    private final AccessModeService accessModeService;

    public ShowNewDiagramItemInPageMenuCondition(@ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PermissionManager permissionManager, @ComponentImport BandanaManager bandanaManager, @ComponentImport AccessModeService accessModeService) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.permissionManager = permissionManager;
        this.bandanaManager = bandanaManager;
        this.accessModeService = accessModeService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    protected boolean shouldDisplay(WebInterfaceContext webInterfaceContext) {
        HashMap<String, String> adminSettings = AdminAction.getAdminSettings(this.bandanaManager);
        if (!Boolean.parseBoolean(adminSettings.get("showAddDiagramInPageMenu"))) {
            return false;
        }
        Space space = webInterfaceContext.getSpace();
        AbstractPage page = webInterfaceContext.getPage();
        ConfluenceUser user = webInterfaceContext.getCurrentUser();
        LicenseHelper helper = new LicenseHelper(this.pluginLicenseManager);
        boolean validLicense = helper.isValidLicense();
        boolean canCreatePage = this.permissionManager.hasCreatePermission((User)user, (Object)space, Page.class);
        boolean canCreateAttachment = this.permissionManager.hasCreatePermission((User)user, (Object)page, Attachment.class);
        return validLicense && canCreatePage && canCreateAttachment && !this.accessModeService.isReadOnlyAccessModeEnabled();
    }
}

