/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import bucket.core.persistence.hibernate.HibernateHandle;
import com.atlassian.bonnie.Handle;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.DefaultSearchResults;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.MultiTextFieldQuery;
import com.atlassian.confluence.search.v2.sort.ModifiedSort;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.gson.Gson;
import com.yworks.plugins.confluence.helper.LicenseHelper;
import com.yworks.plugins.confluence.helper.PageUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SearchServlet
extends HttpServlet {
    private final SearchManager searchManager;
    private final PageManager pageManager;
    private final AttachmentManager attachmentManager;
    private final PluginLicenseManager pluginLicenseManager;
    private final Gson gson;

    public SearchServlet(@ComponentImport SearchManager searchManager, @ComponentImport PageManager pageManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport PluginLicenseManager pluginLicenseManager) {
        this.searchManager = searchManager;
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.gson = new Gson();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LicenseHelper licenseHelper = new LicenseHelper(this.pluginLicenseManager);
        if (!licenseHelper.isValidLicense()) {
            ServletOutputStream outputStream = resp.getOutputStream();
            outputStream.print("{\"error\":\"License Error\":\"" + licenseHelper.getErrorString() + "\"}");
            outputStream.flush();
            outputStream.close();
            return;
        }
        String mode = req.getParameter("mode");
        String searchString = req.getParameter("searchString");
        String pageId = req.getParameter("pageId");
        ContentTypeQuery query = null;
        String responseString = "{\"results\":[]}";
        if ("attachments".equals(mode)) {
            Page page = this.pageManager.getPage(Long.parseLong(pageId));
            if (page != null) {
                List attachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page);
                MySearchResults results = new MySearchResults();
                for (Attachment attachment : attachments) {
                    HashMap<String, String> singleSearchResult = new HashMap<String, String>();
                    singleSearchResult.put("type", "attachment");
                    singleSearchResult.put("title", attachment.getDisplayTitle());
                    singleSearchResult.put("space", attachment.getSpace().getDisplayTitle());
                    singleSearchResult.put("url", SearchServlet.getUrlPath(attachment));
                    singleSearchResult.put("size", attachment.getNiceFileSize());
                    singleSearchResult.put("comment", attachment.getVersionComment() != null ? attachment.getVersionComment() : "");
                    results.results.add(singleSearchResult);
                }
                responseString = this.gson.toJson((Object)results);
            }
        } else {
            if ("search".equals(mode) && searchString != null) {
                HashSet<String> fields = new HashSet<String>();
                fields.add("title");
                fields.add("contentBody");
                fields.add("label");
                fields.add("labelText");
                fields.add("space-name");
                fields.add("spacekey");
                ArrayList<ContentTypeEnum> contentTypes = new ArrayList<ContentTypeEnum>();
                contentTypes.add(ContentTypeEnum.PAGE);
                contentTypes.add(ContentTypeEnum.SPACE);
                contentTypes.add(ContentTypeEnum.SPACE_DESCRIPTION);
                query = BooleanQuery.andQuery((SearchQuery[])new SearchQuery[]{new MultiTextFieldQuery(searchString + "*", fields, BooleanOperator.OR), new ContentTypeQuery(contentTypes)});
            } else if ("recently-viewed".equals(mode)) {
                ArrayList<ContentTypeEnum> contentTypes = new ArrayList<ContentTypeEnum>();
                contentTypes.add(ContentTypeEnum.PAGE);
                contentTypes.add(ContentTypeEnum.SPACE);
                contentTypes.add(ContentTypeEnum.SPACE_DESCRIPTION);
                query = new ContentTypeQuery(contentTypes);
            }
            if (query != null) {
                DefaultSearchResults searchResults;
                ModifiedSort sort = new ModifiedSort(SearchSort.Order.DESCENDING);
                try {
                    ContentSearch search = PageUtils.createContentSearch(query, (SearchSort)sort, 50, true);
                    searchResults = this.searchManager.search((ISearch)search);
                }
                catch (InvalidSearchException e) {
                    searchResults = new DefaultSearchResults(Collections.emptyList(), 0);
                }
                MySearchResults results = new MySearchResults();
                for (SearchResult searchResult : searchResults.getAll()) {
                    HashMap<String, Object> singleSearchResult = new HashMap<String, Object>();
                    singleSearchResult.put("type", searchResult.getType());
                    singleSearchResult.put("title", searchResult.getDisplayTitle());
                    singleSearchResult.put("space", searchResult.getSpaceName());
                    singleSearchResult.put("url", SearchServlet.getUrlPath(searchResult));
                    singleSearchResult.put("home", searchResult.isHomePage());
                    singleSearchResult.put("modified", new SimpleDateFormat("yyyy-MM-dd").format(searchResult.getLastModificationDate()));
                    results.results.add(singleSearchResult);
                }
                responseString = this.gson.toJson((Object)results);
            }
        }
        resp.setContentType("text/html; charset=UTF-8");
        PrintWriter outputStream = resp.getWriter();
        outputStream.print(responseString);
        outputStream.flush();
        outputStream.close();
    }

    private static String getUrlPath(SearchResult searchResult) {
        Handle handle;
        String urlPath = searchResult.getUrlPath();
        if (!urlPath.contains("viewpage.action?") && (handle = searchResult.getHandle()) instanceof HibernateHandle) {
            long pageId = ((HibernateHandle)handle).getId();
            return "/pages/viewpage.action?pageId=" + pageId;
        }
        return urlPath;
    }

    private static String getUrlPath(Attachment attachment) {
        ContentEntityObject container = attachment.getContainer();
        String urlPath = attachment.getUrlPath();
        if (container != null && urlPath != null && !urlPath.contains("viewpage.action?")) {
            long pageId = container.getId();
            return "/pages/viewpage.action?pageId=" + pageId + "&preview=/" + pageId + "/" + attachment.getId() + "/" + attachment.getFileName();
        }
        return urlPath;
    }

    private static class MySearchResults {
        public List<HashMap<String, Object>> results = new ArrayList<HashMap<String, Object>>();

        private MySearchResults() {
        }
    }
}

