/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.atlassian.xwork.ParameterSafe;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class RemoveDiagramAction
extends ConfluenceActionSupport {
    private PageManager pageManager;
    private String diagramId;
    private String diagramName;
    private String pageUrl;
    private String pageId;

    public RemoveDiagramAction(@ComponentImport PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public String execute() throws Exception {
        Page page = this.pageManager.getPage(Long.parseLong(this.pageId));
        if (page != null) {
            if (this.accessModeService.isReadOnlyAccessModeEnabled() || this.diagramId == null || !this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)page)) {
                return "error";
            }
            if (this.removeContentFromPage()) {
                return "success";
            }
        }
        return "error";
    }

    private boolean removeContentFromPage() {
        Page page = this.pageManager.getPage(Long.parseLong(this.pageId));
        Page originalPage = (Page)page.clone();
        String content = page.getBodyAsString();
        boolean matched = false;
        Pattern pattern = Pattern.compile("(?xs) # we need DOTALL (?s) since the macro may be on multiple lines\n<ac:(structured-)?macro # allow both <ac:macro and <ac:structured-macro\n[^>]+ac:name=[\"']graphity[\"']\n.*? # skip forward to parameter with name='name'\n<ac:parameter[^>]ac:name=[\"']diagramId[\"']>\n(?<diagramId>[^<]*) # capture the diagram name to compare against the one to delete\n.*? # capture the rest lazily\n</ac:\\1macro> # matching end tag", 36);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            if (!this.diagramId.equals(StringEscapeUtils.unescapeHtml((String)matcher.group("diagramId")))) continue;
            content = content.replaceAll(Pattern.quote(matcher.group()), "");
            matched = true;
        }
        if (!matched) {
            pattern = Pattern.compile("(?xs) # we need DOTALL (?s) since the macro may be on multiple lines\n<ac:(structured-)?macro # allow both <ac:macro and <ac:structured-macro\n[^>]+ac:name=[\"']ydiagram[\"']\n.*? # skip forward to parameter with name='name'\n<ac:parameter[^>]ac:name=[\"']name[\"']>\n(?<diagramName>[^<]*) # capture the diagram name to compare against the one to delete\n.*? # capture the rest lazily\n</ac:\\1macro> # matching end tag", 36);
            matcher = pattern.matcher(content);
            while (matcher.find()) {
                if (!this.diagramName.equals(StringEscapeUtils.unescapeHtml((String)matcher.group("diagramName")))) continue;
                content = content.replaceAll(Pattern.quote(matcher.group()), "");
            }
        }
        page.setBodyAsString(content);
        this.pageManager.saveContentEntity((ContentEntityObject)page, (ContentEntityObject)originalPage, null);
        return true;
    }

    @ParameterSafe
    public String getDiagramId() {
        return this.diagramId;
    }

    @ParameterSafe
    public void setDiagramId(String diagramId) {
        this.diagramId = diagramId;
    }

    @ParameterSafe
    public String getDiagramName() {
        return this.diagramName;
    }

    @ParameterSafe
    public void setDiagramName(String diagramName) {
        this.diagramName = diagramName;
    }

    @ParameterSafe
    public String getPageUrl() {
        return this.pageUrl;
    }

    @ParameterSafe
    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    @ParameterSafe
    public String getPageId() {
        return this.pageId;
    }

    @ParameterSafe
    public void setPageId(String pageId) {
        this.pageId = pageId;
    }
}

