/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.User;
import com.google.gson.Gson;
import com.yworks.plugins.confluence.AdminAction;
import com.yworks.plugins.confluence.helper.LicenseHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoadAdminSettingsServlet
extends HttpServlet {
    private final BandanaManager bandanaManager;
    private final PluginLicenseManager pluginLicenseManager;
    private LocaleManager localeManager;
    private final Gson gson;

    public LoadAdminSettingsServlet(@ComponentImport BandanaManager bandanaManager, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport LocaleManager localeManager) {
        this.bandanaManager = bandanaManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.localeManager = localeManager;
        this.gson = new Gson();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Locale locale;
        LicenseHelper licenseHelper = new LicenseHelper(this.pluginLicenseManager);
        if (!licenseHelper.isValidLicense()) {
            PrintWriter out = resp.getWriter();
            out.println("{\"error\":\"License Error\":\"" + licenseHelper.getErrorString() + "\"}");
            out.close();
            return;
        }
        HashMap<String, String> adminSettings = new HashMap<String, String>(AdminAction.getAdminSettings(this.bandanaManager));
        adminSettings.remove("setting1");
        String privateKey = adminSettings.get("collaborationServerSecretPrivateKey");
        if (privateKey != null && privateKey.length() > 0) {
            String[] strings = LoadAdminSettingsServlet.splitEqually(privateKey, 128);
            for (int i = 0; i < strings.length; ++i) {
                adminSettings.put("k_" + i, LoadAdminSettingsServlet.rot13(strings[strings.length - 1 - i]));
            }
        }
        adminSettings.remove("collaborationServerSecretPrivateKey");
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser != null && (locale = this.localeManager.getLocale((User)currentUser)) != null) {
            adminSettings.put("confluenceUserLocale", locale.toLanguageTag());
        }
        PrintWriter out = resp.getWriter();
        out.println(this.gson.toJson(adminSettings));
        out.close();
    }

    private static String[] splitEqually(String text, int size) {
        String[] ret = new String[(text.length() + size - 1) / size];
        int start = 0;
        int i = 0;
        while (start < text.length()) {
            ret[i] = text.substring(start, Math.min(text.length(), start + size));
            start += size;
            ++i;
        }
        return ret;
    }

    private static String rot13(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= 'a' && c <= 'm') {
                c = (char)(c + 13);
            } else if (c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z') {
                c = (char)(c - 13);
            } else if (c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doPost(req, resp);
    }
}

