/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.User;
import com.yworks.plugins.confluence.SaveDiagramServlet;
import com.yworks.plugins.confluence.helper.LicenseHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.util.Base64;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportAttachmentServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SaveDiagramServlet.class);
    private AttachmentManager attachmentManager;
    private ContentEntityManager contentEntityManager;
    private PermissionManager permissionManager;
    private PluginLicenseManager pluginLicenseManager;
    private LabelManager labelManager;

    public ExportAttachmentServlet(@ComponentImport AttachmentManager attachmentManager, @ComponentImport PageManager pageManager, @ComponentImport PermissionManager permissionManager, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport LabelManager labelManager) {
        this.attachmentManager = attachmentManager;
        this.contentEntityManager = pageManager;
        this.permissionManager = permissionManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.labelManager = labelManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LicenseHelper licenseHelper = new LicenseHelper(this.pluginLicenseManager);
        if (!licenseHelper.isValidLicense()) {
            this.sendResponse(resp, "error", "License Error: " + licenseHelper.getErrorString());
            return;
        }
        String fileNameParam = req.getParameter("filename");
        String fileContentParam = req.getParameter("content");
        String idParam = req.getParameter("pageId");
        if (fileNameParam == null || fileContentParam == null || idParam == null) {
            this.sendResponse(resp, "error", "The file was not received. Probably the POST limit was exceeded.");
            return;
        }
        long idLong = Long.parseLong(idParam);
        ContentEntityObject ceo = this.contentEntityManager.getById(idLong);
        if (!this.permissionManager.hasCreatePermission((User)AuthenticatedUserThreadLocal.get(), (Object)ceo, Attachment.class)) {
            this.sendResponse(resp, "error", "You don't have write permissions.");
            return;
        }
        try {
            byte[] fileContent = this.decodeBase64(fileContentParam);
            this.saveAttachment(fileNameParam, ceo, fileContent, "Graphity Export", this.getContentType(fileNameParam));
            this.sendResponse(resp, "success", null);
        }
        catch (Exception e) {
            log.error("Could not save Graphity for Confluence attachment", (Throwable)e);
            this.sendResponse(resp, "error", "<![CDATA[" + e.getMessage() + "]]>");
        }
    }

    private String getContentType(String fileName) {
        String format;
        String[] split = fileName.split("\\.");
        String fileExtension = split[split.length - 1];
        switch (format = fileExtension.toLowerCase()) {
            case "png": {
                return "image/png";
            }
            case "pdf": {
                return "text/plain; charset=x-user-defined";
            }
            case "svg": {
                return "image/svg+xml";
            }
            case "graphml": {
                return "application/xml";
            }
        }
        throw new InvalidParameterException("");
    }

    private byte[] decodeBase64(String base64String) {
        return Base64.getDecoder().decode(base64String.getBytes());
    }

    private void sendResponse(HttpServletResponse resp, String result, String cause) throws IOException {
        ServletOutputStream outputStream = resp.getOutputStream();
        StringBuilder response = new StringBuilder();
        response.append("{\"result\":\"").append(result).append("\"");
        if (cause != null) {
            response.append(", \"cause\":\"").append(cause).append("\"");
        }
        response.append("}");
        outputStream.print(response.toString());
        outputStream.flush();
        outputStream.close();
    }

    private void saveAttachment(String name, ContentEntityObject ceo, byte[] data, String comment, String contentType) throws IOException {
        Attachment attachment;
        Attachment previousVersion = this.attachmentManager.getAttachment(ceo, name);
        if (previousVersion != null) {
            attachment = previousVersion;
            previousVersion = (Attachment)previousVersion.clone();
        } else {
            attachment = new Attachment();
            ceo.addAttachment(attachment);
        }
        attachment.setVersionComment(comment);
        attachment.setMediaType(contentType);
        attachment.setContainer(ceo);
        attachment.setFileName(name);
        attachment.setFileSize((long)data.length);
        this.labelManager.addLabel((Labelable)attachment, new Label("Graphity"));
        this.attachmentManager.saveAttachment(attachment, previousVersion, (InputStream)new ByteArrayInputStream(data));
    }
}

