/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.MacroUsageQuery;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultGroup;
import com.google.gson.Gson;
import com.yworks.plugins.confluence.helper.LicenseHelper;
import com.yworks.plugins.confluence.helper.PageUtils;
import com.yworks.plugins.confluence.helper.PalettesManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(AdminAction.class);
    private static final String ADMIN_SETTINGS_KEY = "com.yworks.plugins.confluence.graphity.ydiagram.admin.settings";
    private static final String TEMPLATE_GRAPHS_KEY = "com.yworks.plugins.confluence.graphity.ydiagram.admin.template_graphs";
    private static final String ACTION_SAVE_GENERAL_SETTINGS = "submit-save-general-settings";
    private static final String ACTION_SAVE_TEMPLATE_GRAPHS = "submit-save-template-graphs";
    private static final String ACTION_SAVE_BUILT_IN_PALETTES = "submit-save-built-in-palettes";
    private static final String ACTION_ADD_GLOBAL_PALETTE = "submit-add-global-palette";
    private static final String ACTION_REMOVE_GLOBAL_PALETTES = "submit-remove-global-palettes";
    private static final String ACTION_COLLABORATION_GENERATE_TOKEN = "generate-collaboration-server-token";
    private static final String ACTION_SCAN_FOR_TEMPLATE_PAGES = "scanForTemplatePages";
    private static final String ACTION_SAVE_COLLABORATION_SETTINGS = "submit-collaboration-server-settings";
    public static final String KEY_COLLABORATION_ENABLED = "collaborationEnabled";
    public static final String KEY_COLLABORATION_EXTERNAL_URL = "collaborationExternalURL";
    public static final String KEY_COLLABORATION_SECRET_PRIVATE_KEY = "collaborationServerSecretPrivateKey";
    public static final String KEY_COLLABORATION_SECRET_PUBLIC_KEY = "collaborationServerSecretPublicKey";
    public static final String KEY_COLLABORATION_SERVER_TOKEN = "collaborationServerToken";
    private final BandanaManager bandanaManager;
    private final UserAccessor userAccessor;
    private SearchManager searchManager;
    private final SettingsManager settingsManager;
    private final PageManager pageManager;
    private final PluginLicenseManager pluginLicenseManager;
    private final PalettesManager palettesManager;
    private String failureReason;
    private boolean paletteAdded;
    private final Gson gson = new Gson();

    public AdminAction(@ComponentImport BandanaManager bandanaManager, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport UserAccessor userAccessor, @ComponentImport PermissionManager permissionManager, @ComponentImport PageManager pageManager, @ComponentImport SearchManager searchManager, @ComponentImport SettingsManager settingsManager) {
        this.bandanaManager = bandanaManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.userAccessor = userAccessor;
        this.searchManager = searchManager;
        this.settingsManager = settingsManager;
        this.palettesManager = new PalettesManager(bandanaManager, permissionManager);
        this.pageManager = pageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        block11: {
            String action;
            HttpServletResponse response;
            HttpServletRequest request;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                LicenseHelper licenseHelper = new LicenseHelper(this.pluginLicenseManager);
                                this.failureReason = !licenseHelper.isValidLicense() ? licenseHelper.getErrorString() : null;
                                this.paletteAdded = false;
                                request = ServletContextThreadLocal.getRequest();
                                response = ServletContextThreadLocal.getResponse();
                                if (request == null) break block11;
                                action = request.getParameter("action");
                                if (!ACTION_SAVE_GENERAL_SETTINGS.equals(action)) break block12;
                                this.updateSettings(request, ADMIN_SETTINGS_KEY);
                                break block11;
                            }
                            if (!ACTION_SAVE_COLLABORATION_SETTINGS.equals(action)) break block13;
                            this.updateCollaborationSettings(request, response);
                            break block11;
                        }
                        if (!ACTION_SAVE_TEMPLATE_GRAPHS.equals(action)) break block14;
                        this.updateSettings(request, TEMPLATE_GRAPHS_KEY);
                        break block11;
                    }
                    if (!ACTION_SAVE_BUILT_IN_PALETTES.equals(action)) break block15;
                    this.updateSettings(request, "com.yworks.plugins.confluence.helper.PalettesHelper.BUILT_IN_PALETTES_KEY");
                    break block11;
                }
                if (!ACTION_ADD_GLOBAL_PALETTE.equals(action)) break block16;
                String[] addGlobalPalette = request.getParameterValues("addGlobalPalette");
                if (addGlobalPalette == null || addGlobalPalette.length != 2 || "".equals(addGlobalPalette[0]) || "".equals(addGlobalPalette[1])) break block11;
                String id = Math.random() + "." + System.currentTimeMillis();
                int endIndex = addGlobalPalette[0].lastIndexOf(46);
                String name = endIndex >= 0 ? addGlobalPalette[0].substring(0, endIndex) : addGlobalPalette[0];
                this.palettesManager.addGlobalPalette(id, name, addGlobalPalette[1]);
                this.paletteAdded = true;
                break block11;
            }
            if (ACTION_REMOVE_GLOBAL_PALETTES.equals(action)) {
                String[] paletteIds;
                for (String paletteId : paletteIds = request.getParameterValues("removeGlobalPalettes")) {
                    this.palettesManager.removeGlobalPalette(paletteId);
                }
            } else if (ACTION_COLLABORATION_GENERATE_TOKEN.equals(action)) {
                HashMap<String, String> adminSettings = AdminAction.getAdminSettings(this.bandanaManager);
                String serverToken = AdminAction.initializeServerSecrets(adminSettings);
                PalettesManager.setStoredStrings(ADMIN_SETTINGS_KEY, this.bandanaManager, adminSettings);
                response.setStatus(200);
                response.setContentType("application/json");
                PrintWriter out = response.getWriter();
                out.println(serverToken);
                out.close();
            } else if (ACTION_SCAN_FOR_TEMPLATE_PAGES.equals(action)) {
                try (PrintWriter out = response.getWriter();){
                    HashSet<Page> templatePages = new HashSet<Page>(this.getTemplateGraphPages());
                    String json = this.gson.toJson(this.getConfluencePages().stream().map(page -> new PageData(page.getId(), page.getDisplayTitle(), templatePages.contains(page))).collect(Collectors.toList()));
                    response.setStatus(200);
                    response.setContentType("application/json");
                    out.println(json);
                }
            }
        }
        return "success";
    }

    public String getConfluenceRoot() {
        return this.settingsManager.getGlobalSettings().getBaseUrl();
    }

    public boolean getSupportCloudServices() {
        return this.getBooleanValue("cloudServices");
    }

    public boolean getSupportGitHubGist() {
        return this.getBooleanValue("gist");
    }

    public boolean getSupportGoogleDrive() {
        return this.getBooleanValue("GoogleDrive");
    }

    public boolean getSupportDropbox() {
        return this.getBooleanValue("Dropbox");
    }

    public boolean getSupportOneDrive() {
        return this.getBooleanValue("OneDrive");
    }

    public boolean getErrorReporting() {
        return this.getBooleanValue("errorReporting");
    }

    public boolean getShowFeedback() {
        return this.getBooleanValue("showFeedback");
    }

    public boolean getCollaborationEnabled() {
        return this.getBooleanValue(KEY_COLLABORATION_ENABLED);
    }

    public String getCollaborationExternalURL() {
        return this.getProperty(KEY_COLLABORATION_EXTERNAL_URL);
    }

    public String getCollaborationServerToken() {
        return this.getProperty(KEY_COLLABORATION_SERVER_TOKEN);
    }

    private SecretKey getSecretKey() {
        byte[] encryptionKey = Base64.getDecoder().decode(AdminAction.getAdminSettings(this.bandanaManager).get("setting1"));
        return new SecretKeySpec(encryptionKey, "AES");
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public boolean getErrorReportingEmail() {
        return this.getBooleanValue("errorReportingEmail");
    }

    public String getErrorReportingEmailAddresses() {
        return this.getProperty("errorReportingEmailAddresses");
    }

    public boolean getErrorReportingNotifications() {
        return this.getBooleanValue("errorReportingNotifications");
    }

    public Boolean getErrorReportingNotificationsAllAdmins() {
        return this.getBooleanValue("errorReportingNotificationsAllAdmins");
    }

    public Boolean getErrorReportingNotificationsSomeAdmins() {
        return this.getBooleanValue("errorReportingNotificationsSomeAdmins");
    }

    public Boolean getShowAddDiagramInPageMenu() {
        return this.getBooleanValue("showAddDiagramInPageMenu");
    }

    public List<String> getErrorReportingNotificationsAdminNames() {
        String adminNames = this.getProperty("errorReportingNotificationsAdminNames[]");
        if (adminNames.length() > 2) {
            adminNames = adminNames.substring(1, adminNames.length() - 1);
            adminNames = adminNames.replaceAll("\\s", "");
            return Arrays.asList(adminNames.split(","));
        }
        return null;
    }

    public List<Page> getTemplateGraphPages() {
        return AdminAction.getTemplateGraphPagesStatic(this.bandanaManager, this.pageManager);
    }

    public static List<Page> getTemplateGraphPagesStatic(BandanaManager bandanaManager, PageManager pageManager) {
        HashMap<String, String> settings = PalettesManager.getStoredStrings(TEMPLATE_GRAPHS_KEY, bandanaManager);
        String pages = settings.get("templateGraphPages[]");
        if (pages != null && pages.length() > 2) {
            pages = pages.substring(1, pages.length() - 1);
            pages = pages.replaceAll("\\s", "");
            List pageIds = Arrays.stream(pages.split(",")).map(s -> Long.parseLong(s)).collect(Collectors.toList());
            return pageManager.getPages(pageIds);
        }
        return new ArrayList<Page>();
    }

    public String getCreatePermissionsGlobalPalettes() {
        return this.getProperty("createGlobalPalettePermissions");
    }

    public Boolean getCreatePermissionsGlobalPalettesOnlyAdmins() {
        String property = this.getProperty("createGlobalPalettePermissions");
        return property == null || "OnlyAdmins".equals(property);
    }

    public Boolean getCreatePermissionsGlobalPalettesAllUsers() {
        String property = this.getProperty("createGlobalPalettePermissions");
        return property == null || "AllUsers".equals(property);
    }

    public boolean getPaletteAdded() {
        return this.paletteAdded;
    }

    public List<String> getAdminNames() {
        return this.userAccessor.getMemberNamesAsList((Group)new DefaultGroup("confluence-administrators"));
    }

    public Set<Page> getConfluencePages() {
        HashSet<Page> pages = new HashSet<Page>();
        try {
            PageUtils.findPages(this.searchManager, (SearchQuery)new MacroUsageQuery("graphity"), new CreatedSort(SearchSort.Order.ASCENDING), pages);
            PageUtils.findPages(this.searchManager, (SearchQuery)new MacroUsageQuery("ydiagram"), new CreatedSort(SearchSort.Order.ASCENDING), pages);
        }
        catch (InvalidSearchException e) {
            log.warn("Invalid search: " + e.getMessage());
        }
        return pages;
    }

    public Set<String> getSharedPalettes() {
        return this.palettesManager.getGlobalPalettesIds();
    }

    public String getPaletteText(String paletteId) {
        HashMap<String, String> palette = this.palettesManager.getGlobalPalette(paletteId);
        return palette.get("name") + " - " + this.getText("com.yworks.plugins.confluence.graphity.admin.page.settings.global-palettes.remove-palette.created") + " " + palette.get("ownerName");
    }

    public String[] getBuiltInPalettes() {
        return this.palettesManager.getBuiltInPalettes();
    }

    public String getBuiltInPaletteName(String key) {
        return this.palettesManager.getBuiltInPaletteNames().get(key);
    }

    public String getBuiltInPaletteValue(String key) {
        return this.palettesManager.getBuiltInPalettesSettings().get(key);
    }

    private void updateSettings(HttpServletRequest response, String key) {
        HashMap<String, String> prop = PalettesManager.getStoredStrings(key, this.bandanaManager);
        Enumeration settings = response.getParameterNames();
        ArrayList<String> settingsList = Collections.list(settings);
        for (String setting : settingsList) {
            Object parameter;
            if (setting.endsWith("[]")) {
                parameter = response.getParameterValues(setting);
                prop.put(setting, Arrays.toString((Object[])parameter));
                continue;
            }
            parameter = response.getParameter(setting);
            if (((String)parameter).startsWith("submit") || setting.endsWith("Radio")) continue;
            Object value = "on".equals(parameter) ? "true" : parameter;
            prop.put(setting, (String)value);
        }
        PalettesManager.setStoredStrings(key, this.bandanaManager, prop);
    }

    private void updateCollaborationSettings(HttpServletRequest request, HttpServletResponse response) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission((User)confluenceUser, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            response.setStatus(403);
            return;
        }
        HashMap<String, String> prop = PalettesManager.getStoredStrings(ADMIN_SETTINGS_KEY, this.bandanaManager);
        Enumeration settings = request.getParameterNames();
        ArrayList<String> settingsList = Collections.list(settings);
        for (String setting : settingsList) {
            Object newValue;
            Object parameter;
            if (setting.endsWith("[]")) {
                parameter = request.getParameterValues(setting);
                prop.put(setting, Arrays.toString((Object[])parameter));
                continue;
            }
            parameter = request.getParameter(setting);
            if (((String)parameter).startsWith("submit") || setting.endsWith("Radio")) continue;
            Object object = newValue = "on".equals(parameter) ? "true" : parameter;
            if (setting.equals(KEY_COLLABORATION_EXTERNAL_URL) && !this.isValidUrl((String)newValue)) {
                this.addFieldError(KEY_COLLABORATION_EXTERNAL_URL, this.getText("com.yworks.plugins.confluence.graphity.admin.page.settings.collaboration.externalUrl.invalid"));
                continue;
            }
            prop.put(setting, (String)newValue);
        }
        PalettesManager.setStoredStrings(ADMIN_SETTINGS_KEY, this.bandanaManager, prop);
    }

    private boolean isValidUrl(String value) {
        try {
            URI url = new URI(value);
            if (url.getPort() > 65535 || url.getHost() == null || url.getHost().isEmpty() || url.getScheme() == null || url.getScheme().isEmpty()) {
                return false;
            }
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    private boolean isValidPort(String value) {
        try {
            int port = Integer.parseInt(value, 10);
            if (port <= 0 || port > 65535) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private boolean isValidKeystoreLocation(String value) {
        File keyStoreFile = new File(value);
        return keyStoreFile.canRead();
    }

    private boolean isValidKeystorePassword(String value, String keystore) {
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(keystore), value.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            return false;
        }
        return true;
    }

    private String getProperty(String key) {
        HashMap<String, String> prop = AdminAction.getAdminSettings(this.bandanaManager);
        if (prop != null && prop.get(key) != null) {
            return prop.get(key);
        }
        return "";
    }

    private boolean getBooleanValue(String key) {
        return !this.getProperty(key).equals("") && !this.getProperty(key).equals("false");
    }

    public static HashMap<String, String> getAdminSettings(BandanaManager bandanaManager) {
        HashMap<String, String> adminSettings = PalettesManager.getStoredStrings(ADMIN_SETTINGS_KEY, bandanaManager);
        Set<String> keys = adminSettings.keySet();
        Properties defaultSettings = AdminAction.getDefaultAdminSettings();
        boolean needsUpdate = false;
        Set<String> defaultKeys = defaultSettings.stringPropertyNames();
        for (String string : defaultKeys) {
            if (keys.contains(string)) continue;
            adminSettings.put(string, defaultSettings.getProperty(string));
            needsUpdate = true;
        }
        if (!adminSettings.containsKey("setting1")) {
            SecureRandom secureRandom = new SecureRandom();
            byte[] byArray = new byte[16];
            secureRandom.nextBytes(byArray);
            adminSettings.put("setting1", Base64.getEncoder().encodeToString(byArray));
            needsUpdate = true;
        }
        if (needsUpdate) {
            PalettesManager.setStoredStrings(ADMIN_SETTINGS_KEY, bandanaManager, adminSettings);
        }
        return adminSettings;
    }

    static String initializeServerSecrets(HashMap<String, String> adminSettings) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(2048);
            KeyPair keyPair = kpg.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            String privKeyStr = Base64.getEncoder().encodeToString(privateKey.getEncoded());
            byte[] publicKeyEncoded = publicKey.getEncoded();
            String pubKeyStr = Base64.getEncoder().encodeToString(publicKeyEncoded);
            adminSettings.put(KEY_COLLABORATION_SECRET_PRIVATE_KEY, privKeyStr);
            adminSettings.put(KEY_COLLABORATION_SECRET_PUBLIC_KEY, pubKeyStr);
            String digest = DigestUtils.sha256Hex((byte[])publicKeyEncoded);
            String shortDigest = digest.substring(0, digest.length() / 2);
            adminSettings.put(KEY_COLLABORATION_SERVER_TOKEN, shortDigest);
            return shortDigest;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("No suitable algorithm to initialize keypair!", (Throwable)e);
            return null;
        }
    }

    private static Properties getDefaultAdminSettings() {
        Properties adminSettings = new Properties();
        adminSettings.setProperty("showFeedback", "true");
        adminSettings.setProperty("errorReporting", "false");
        adminSettings.setProperty("errorReportingEmail", "false");
        adminSettings.setProperty("errorReportingNotifications", "false");
        adminSettings.setProperty("errorReportingNotificationsAllAdmins", "false");
        adminSettings.setProperty("errorReportingNotificationsAdminNames", "[]");
        adminSettings.setProperty("errorReportingNotificationsAdmins", "false");
        adminSettings.setProperty("errorReportingNotificationsSomeAdmins", "false");
        adminSettings.setProperty("showAddDiagramInPageMenu", "true");
        adminSettings.setProperty("createGlobalPalettePermissions", "OnlyAdmins");
        adminSettings.setProperty(KEY_COLLABORATION_ENABLED, "false");
        adminSettings.setProperty(KEY_COLLABORATION_EXTERNAL_URL, "https://collaboration.graphity.com/graphity/rtc");
        adminSettings.setProperty(KEY_COLLABORATION_SERVER_TOKEN, "");
        return adminSettings;
    }

    static class PageData {
        public long id;
        public String text;
        public boolean selected;

        public PageData(long id, String text, boolean selected) {
            this.id = id;
            this.text = text;
            this.selected = selected;
        }
    }
}

