/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.Versioned;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.User;
import com.yworks.plugins.confluence.helper.AttachmentHelper;
import com.yworks.plugins.confluence.helper.LicenseHelper;
import com.yworks.plugins.confluence.helper.URLEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GraphityMacro
implements Macro {
    private static final String KEY_NAME = "name";
    private static final String MACRO_BODY_TEMPLATE = "templates/graphity-macro.vm";
    private static final String MACRO_BODY_MOBILE_TEMPLATE = "templates/graphity-macro-mobile.vm";
    private static final String MACRO_BODY_EXPORT_TEMPLATE = "templates/graphity-macro-export.vm";
    private static final String ERROR_BODY_TEMPLATE = "templates/graphity-macro-error.vm";
    private static final String EMPTY_BODY_TEMPLATE = "templates/graphity-macro-empty-diagram.vm";
    private static final String FILE_NOT_FOUND_ERROR = "com.yworks.plugins.confluence.graphity.graphity.macro.error.file_not_found";
    private static final String INVALID_LICENSE_ERROR = "com.yworks.plugins.confluence.graphity.ydiagram.macro.error.invalid_license";
    private static final String NO_FILE_NAME_ERROR = "com.yworks.plugins.confluence.graphity.graphity.macro.error.no_file_name";
    private final PluginLicenseManager pluginLicenseManager;
    private final PermissionManager permissionManager;
    private final SettingsManager settingsManager;
    private final AttachmentManager attachmentManager;
    private final AccessModeService accessModeService;

    public GraphityMacro(@ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PermissionManager permissionManager, @ComponentImport SettingsManager settingsManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport AccessModeService accessModeService) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.permissionManager = permissionManager;
        this.settingsManager = settingsManager;
        this.attachmentManager = attachmentManager;
        this.accessModeService = accessModeService;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        MacroContext macroContext = this.createMacroContext(params, conversionContext);
        switch (macroContext.outputType) {
            default: {
                return this.getDisplayTemplate(macroContext);
            }
            case "pdf": 
            case "html_export": 
            case "word": 
            case "email": 
        }
        return this.getExportTemplate(macroContext);
    }

    private String getDisplayTemplate(MacroContext macroContext) {
        boolean floats;
        Map templateContext = MacroUtils.defaultVelocityContext();
        LicenseHelper licenseHelper = new LicenseHelper(this.pluginLicenseManager);
        if (licenseHelper.isValidLicense()) {
            templateContext.put("validLicense", "true");
        } else {
            templateContext.put("failureReason", licenseHelper.getErrorString());
        }
        templateContext.put("pageId", macroContext.pageId);
        templateContext.put("pageUrl", macroContext.pageUrl);
        templateContext.put("confluenceRoot", macroContext.confluenceRoot);
        if (macroContext.interactive) {
            templateContext.put("displayFormat", "interactive");
            templateContext.put("links", macroContext.links);
            templateContext.put("linksInNewWindow", macroContext.linksInNewWindow);
            templateContext.put("tooltips", macroContext.tooltips);
            templateContext.put("showToolbar", macroContext.toolbar);
        }
        String align = macroContext.align;
        boolean bl = floats = macroContext.floats && !"center".equals(align);
        if (!floats || macroContext.mobile) {
            templateContext.put("align", align);
        } else {
            templateContext.put("float", align != null ? align : "left");
        }
        String diagramName = macroContext.diagramName;
        if (diagramName != null) {
            String diagramId = macroContext.diagramId;
            String diagramNameEncoded = URLEncoder.encode(diagramName);
            templateContext.put("diagramNameEnc", diagramNameEncoded);
            templateContext.put("diagramName", diagramName);
            templateContext.put("displayName", macroContext.displayName);
            templateContext.put("diagramId", macroContext.diagramId);
            templateContext.put("macroId", macroContext.generateMacroId());
            templateContext.put("confluenceMacroId", macroContext.confluenceMacroId);
            String width = macroContext.width;
            String height = macroContext.height;
            AttachmentDescriptor attachment = this.getAttachment(diagramId, diagramName, macroContext.entity, macroContext.attachmentVersion);
            AttachmentDescriptor latestAttachment = this.getAttachment(diagramId, diagramName, macroContext.entity, -1);
            this.addSizeInfo(templateContext, diagramName, width, height, attachment, macroContext.entity, macroContext.attachmentVersion);
            this.addImageInfo(templateContext, attachment);
            if (macroContext.entity instanceof Page) {
                if ("preview".equals(macroContext.outputType)) {
                    templateContext.put("showDescription", "true");
                } else {
                    ConfluenceUser user = AuthenticatedUserThreadLocal.get();
                    if (!this.accessModeService.isReadOnlyAccessModeEnabled() && this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)macroContext.entity)) {
                        if (attachment == null || this.permissionManager.hasPermission((User)user, Permission.REMOVE, (Object)attachment.attachment)) {
                            templateContext.put("hasRemovePermission", "true");
                        }
                        if (this.permissionManager.hasCreatePermission((User)user, (Object)macroContext.entity, Attachment.class)) {
                            templateContext.put("hasWritePermission", "true");
                        }
                    }
                    if (!templateContext.containsKey("hasWritePermission")) {
                        templateContext.put("hasReadPermission", "true");
                    }
                }
            }
            this.addDiagramUrl(templateContext, 0.0, 0.0, macroContext, attachment);
            templateContext.put("alt", macroContext.imageAlt == null ? diagramName : macroContext.imageAlt);
            if (!licenseHelper.isValidLicense()) {
                templateContext.put("error", INVALID_LICENSE_ERROR);
                templateContext.put("errorParams", new String[]{diagramName});
                return VelocityUtils.getRenderedTemplate((String)EMPTY_BODY_TEMPLATE, (Map)templateContext);
            }
            if (attachment == null) {
                if (macroContext.attachmentVersion > 0) {
                    templateContext.put("error", FILE_NOT_FOUND_ERROR);
                    return VelocityUtils.getRenderedTemplate((String)ERROR_BODY_TEMPLATE, (Map)templateContext);
                }
                templateContext.put("error", FILE_NOT_FOUND_ERROR);
                templateContext.put("errorParams", new String[]{diagramName});
                return VelocityUtils.getRenderedTemplate((String)EMPTY_BODY_TEMPLATE, (Map)templateContext);
            }
            templateContext.put("diagramVersion", macroContext.attachmentVersion);
            templateContext.put("latestDiagramVersion", latestAttachment.attachment.getVersion());
            if (macroContext.attachmentVersion >= 0 && attachment.attachment.getVersion() != macroContext.attachmentVersion) {
                templateContext.put("versionMismatch", macroContext.attachmentVersion);
            }
            if (macroContext.mobile) {
                return VelocityUtils.getRenderedTemplate((String)MACRO_BODY_MOBILE_TEMPLATE, (Map)templateContext);
            }
            return VelocityUtils.getRenderedTemplate((String)MACRO_BODY_TEMPLATE, (Map)templateContext);
        }
        templateContext.put("error", NO_FILE_NAME_ERROR);
        return VelocityUtils.getRenderedTemplate((String)ERROR_BODY_TEMPLATE, (Map)templateContext);
    }

    private String getExportTemplate(MacroContext macroContext) {
        String macroHeight;
        String macroWidth;
        String pngHeight;
        String pngWidth;
        boolean floats;
        LicenseHelper licenseHelper = new LicenseHelper(this.pluginLicenseManager);
        if (!licenseHelper.isValidLicense()) {
            return "";
        }
        String diagramName = macroContext.diagramName;
        if (diagramName == null) {
            return "";
        }
        AttachmentDescriptor attachmentDescriptor = this.getAttachment(macroContext.diagramId, diagramName, macroContext.entity, macroContext.attachmentVersion);
        if (attachmentDescriptor == null) {
            return "";
        }
        Map templateContext = MacroUtils.defaultVelocityContext();
        templateContext.put("diagramName", diagramName);
        templateContext.put("displayName", macroContext.displayName);
        String align = macroContext.align;
        boolean bl = floats = macroContext.floats && !"center".equals(align);
        if (floats) {
            templateContext.put("float", align != null ? align : "left");
        } else {
            templateContext.put("align", align);
        }
        String width = macroContext.width;
        String height = macroContext.height;
        this.addSizeInfo(templateContext, diagramName, width, height, attachmentDescriptor, macroContext.entity, macroContext.attachmentVersion);
        this.addImageInfo(templateContext, attachmentDescriptor);
        double imageWidth = Double.parseDouble(String.valueOf(templateContext.get("imageWidth")));
        double imageHeight = Double.parseDouble(String.valueOf(templateContext.get("imageHeight")));
        this.addDiagramUrl(templateContext, imageWidth, imageHeight, macroContext, attachmentDescriptor);
        width = String.valueOf(templateContext.get("macroContainerWidth"));
        height = String.valueOf(templateContext.get("macroContainerHeight"));
        double pngAspectRatio = imageWidth / imageHeight;
        if ("auto".equals(width) && "auto".equals(height) || width.contains("%") || height.contains("%")) {
            pngWidth = "100%";
            pngHeight = "auto";
            macroWidth = imageWidth + "px";
            macroHeight = "auto";
        } else if ("auto".equals(width)) {
            double userHeight = Double.parseDouble(height.replace("px", ""));
            pngWidth = "100%";
            pngHeight = "auto";
            macroWidth = userHeight * pngAspectRatio + "px";
            macroHeight = userHeight + "px";
        } else if ("auto".equals(height)) {
            double userWidth = Double.parseDouble(width.replace("px", ""));
            pngWidth = "100%";
            pngHeight = "auto";
            macroWidth = userWidth + "px";
            macroHeight = userWidth * pngAspectRatio + "px";
        } else {
            double userHeight;
            double userWidth = Double.parseDouble(width.replace("px", ""));
            double macroAspectRatio = userWidth / (userHeight = Double.parseDouble(height.replace("px", "")));
            if (pngAspectRatio >= macroAspectRatio) {
                pngWidth = "100%";
                pngHeight = "auto";
            } else {
                pngWidth = "auto";
                pngHeight = "100%";
            }
            macroWidth = width;
            macroHeight = height;
        }
        templateContext.put("macroContainerWidth", macroWidth);
        templateContext.put("macroContainerHeight", macroHeight);
        templateContext.put("imageWidth", pngWidth);
        templateContext.put("imageHeight", pngHeight);
        if ("word".equals(macroContext.outputType)) {
            templateContext.put("macroContainerWidth", "50px");
            templateContext.put("macroContainerHeight", "50px");
            templateContext.put("imageWidth", "0");
            templateContext.put("imageHeight", "0");
            templateContext.put("diagramUrl", "");
        }
        return VelocityUtils.getRenderedTemplate((String)MACRO_BODY_EXPORT_TEMPLATE, (Map)templateContext);
    }

    private AttachmentDescriptor getAttachment(String diagramId, String diagramName, ContentEntityObject entity, int attachmentVersion) {
        Attachment attachment = this.getAttachment(entity, diagramId + ".zip", attachmentVersion);
        String version = "1.2";
        if (attachment == null) {
            String diagramNameTruncated = AttachmentHelper.getValidFileName(diagramName);
            attachment = this.getAttachment(entity, diagramNameTruncated + ".zip", attachmentVersion);
            version = "1.1";
        }
        if (attachment == null) {
            attachment = this.getAttachment(entity, diagramName + ".png", attachmentVersion);
            version = "1.0";
        }
        return attachment != null ? new AttachmentDescriptor(attachment, version) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void addSizeInfo(Map<String, Object> templateContext, String diagramName, String macroWidth, String macroHeight, AttachmentDescriptor attachment, ContentEntityObject entity, int attachmentVersion) {
        block28: {
            String imageHeight;
            String imageWidth;
            block29: {
                Properties macroProperties;
                String entryName;
                block31: {
                    block30: {
                        imageWidth = "400";
                        imageHeight = "400";
                        if (attachment != null) break block30;
                        templateContext.put("imageWidth", imageWidth);
                        templateContext.put("imageHeight", imageHeight);
                        templateContext.put("macroContainerWidth", macroWidth != null ? macroWidth : "400px");
                        templateContext.put("macroContainerHeight", macroHeight != null ? macroHeight : "400px");
                        break block28;
                    }
                    if (!"1.0".equals(attachment.version)) break block31;
                    Attachment graphmlAttachment = this.getAttachment(entity, diagramName + ".graphml", attachmentVersion);
                    if (graphmlAttachment == null) break block28;
                    InputStream attachmentData = this.attachmentManager.getAttachmentData(attachment.attachment);
                    try {
                        BufferedImage image = ImageIO.read(attachmentData);
                        imageWidth = String.valueOf(image.getWidth());
                        imageHeight = String.valueOf(image.getHeight());
                        templateContext.put("imageWidth", imageWidth);
                    }
                    catch (IOException image) {
                        templateContext.put("imageWidth", imageWidth);
                        templateContext.put("imageHeight", imageHeight);
                        templateContext.put("macroContainerWidth", macroWidth != null ? macroWidth : "400px");
                        templateContext.put("macroContainerHeight", macroHeight != null ? macroHeight : "400px");
                        break block28;
                        catch (Throwable throwable) {
                            templateContext.put("imageWidth", imageWidth);
                            templateContext.put("imageHeight", imageHeight);
                            templateContext.put("macroContainerWidth", macroWidth != null ? macroWidth : "400px");
                            templateContext.put("macroContainerHeight", macroHeight != null ? macroHeight : "400px");
                            throw throwable;
                        }
                    }
                    templateContext.put("imageHeight", imageHeight);
                    templateContext.put("macroContainerWidth", macroWidth != null ? macroWidth : "400px");
                    templateContext.put("macroContainerHeight", macroHeight != null ? macroHeight : "400px");
                    break block28;
                }
                if ("1.1".equals(attachment.version)) {
                    String diagramNameTruncated = AttachmentHelper.getValidFileName(diagramName);
                    entryName = diagramNameTruncated + ".svg";
                } else {
                    entryName = "diagram.svg";
                }
                String macroVersion = this.getMacroVersion(attachment);
                if ("1.1".equals(macroVersion)) {
                    byte[] entry = AttachmentHelper.getEntry(entryName, this.attachmentManager.getAttachmentData(attachment.attachment));
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setValidating(false);
                    documentBuilderFactory.setNamespaceAware(true);
                    documentBuilderFactory.setFeature("http://xml.org/sax/features/namespaces", false);
                    documentBuilderFactory.setFeature("http://xml.org/sax/features/validation", false);
                    documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                    documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(new ByteArrayInputStream(entry));
                    Element element = document.getDocumentElement();
                    imageWidth = element.getAttribute("width").replace("px", "");
                    imageHeight = element.getAttribute("height").replace("px", "");
                } else {
                    String diagramHeight;
                    macroProperties = this.getMacroProperties(attachment);
                    String diagramWidth = macroProperties.getProperty("width");
                    if (diagramWidth != null) {
                        imageWidth = diagramWidth;
                    }
                    if ((diagramHeight = macroProperties.getProperty("height")) != null) {
                        imageHeight = diagramHeight;
                    }
                }
                if (macroWidth != null && macroHeight != null) break block29;
                try {
                    byte[] entry = AttachmentHelper.getEntry("META-INF/version.properties", this.attachmentManager.getAttachmentData(attachment.attachment));
                    macroProperties = new Properties();
                    macroProperties.load(new ByteArrayInputStream(entry));
                    String version = macroProperties.getProperty("version");
                    if (macroWidth == null) {
                        String string = macroWidth = "1.0".equals(version) ? null : "auto";
                    }
                    if (macroHeight == null) {
                        macroHeight = "1.0".equals(version) ? null : "auto";
                    }
                }
                catch (IOException entry) {
                    // empty catch block
                }
            }
            templateContext.put("imageWidth", imageWidth);
            templateContext.put("imageHeight", imageHeight);
            templateContext.put("macroContainerWidth", macroWidth != null ? macroWidth : "400px");
            templateContext.put("macroContainerHeight", macroHeight != null ? macroHeight : "400px");
            break block28;
            catch (IOException | ParserConfigurationException | SAXException entry) {
                if (macroWidth == null || macroHeight == null) {
                    try {
                        byte[] entry2 = AttachmentHelper.getEntry("META-INF/version.properties", this.attachmentManager.getAttachmentData(attachment.attachment));
                        Properties macroProperties2 = new Properties();
                        macroProperties2.load(new ByteArrayInputStream(entry2));
                        String version = macroProperties2.getProperty("version");
                        if (macroWidth == null) {
                            String string = macroWidth = "1.0".equals(version) ? null : "auto";
                        }
                        if (macroHeight == null) {
                            macroHeight = "1.0".equals(version) ? null : "auto";
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                templateContext.put("imageWidth", imageWidth);
                templateContext.put("imageHeight", imageHeight);
                templateContext.put("macroContainerWidth", macroWidth != null ? macroWidth : "400px");
                templateContext.put("macroContainerHeight", macroHeight != null ? macroHeight : "400px");
                catch (Throwable throwable) {
                    if (macroWidth == null || macroHeight == null) {
                        try {
                            byte[] entry3 = AttachmentHelper.getEntry("META-INF/version.properties", this.attachmentManager.getAttachmentData(attachment.attachment));
                            Properties macroProperties3 = new Properties();
                            macroProperties3.load(new ByteArrayInputStream(entry3));
                            String version = macroProperties3.getProperty("version");
                            if (macroWidth == null) {
                                String string = macroWidth = "1.0".equals(version) ? null : "auto";
                            }
                            if (macroHeight == null) {
                                macroHeight = "1.0".equals(version) ? null : "auto";
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    templateContext.put("imageWidth", imageWidth);
                    templateContext.put("imageHeight", imageHeight);
                    templateContext.put("macroContainerWidth", macroWidth != null ? macroWidth : "400px");
                    templateContext.put("macroContainerHeight", macroHeight != null ? macroHeight : "400px");
                    throw throwable;
                }
            }
        }
    }

    private void addImageInfo(Map<String, Object> templateContext, AttachmentDescriptor attachment) {
        if (attachment != null) {
            try {
                byte[] entry = AttachmentHelper.getEntry("META-INF/macro.properties", this.attachmentManager.getAttachmentData(attachment.attachment));
                Properties macroProperties = new Properties();
                macroProperties.load(new ByteArrayInputStream(entry));
                String backgroundColor = macroProperties.getProperty("backgroundColor", "#FFF");
                templateContext.put("backgroundColor", backgroundColor);
                templateContext.put("textColor", "#FFF".equals(backgroundColor.toUpperCase()) ? "black" : "white");
            }
            catch (IOException e) {
                templateContext.put("backgroundColor", "#FFF");
                templateContext.put("textColor", "black");
            }
        }
    }

    private void addDiagramUrl(Map<String, Object> templateContext, double imageWidth, double imageHeight, MacroContext macroContext, AttachmentDescriptor attachment) {
        String diagramUrl = "";
        if (attachment != null) {
            if ("display".equals(macroContext.outputType) || "preview".equals(macroContext.outputType)) {
                String name;
                String string = name = macroContext.diagramName != null ? URLEncoder.encode(macroContext.diagramName) : macroContext.diagramId;
                if ("1.0".equals(attachment.version)) {
                    diagramUrl = macroContext.confluenceRoot + this.attachmentManager.getAttachmentDownloadPath(macroContext.entity, macroContext.diagramName + ".png");
                } else {
                    diagramUrl = macroContext.baseUrl + "/plugins/servlet/graphity-diagram-data-service?pageId=" + macroContext.pageId + "&version=" + attachment.attachment.getVersion() + "&name=" + name + "&entryType=svg";
                    if (macroContext.diagramId != null) {
                        diagramUrl = diagramUrl + "&diagramId=" + macroContext.diagramId;
                    }
                }
                templateContext.put("diagramDataServlet", macroContext.baseUrl + "/plugins/servlet/graphity-diagram-data-service");
            } else if ("pdf".equals(macroContext.outputType) || "html_export".equals(macroContext.outputType) || "email".equals(macroContext.outputType)) {
                InputStream attachmentData = this.attachmentManager.getAttachmentData(attachment.attachment);
                if ("1.0".equals(attachment.version)) {
                    diagramUrl = AttachmentHelper.getPngDataUri(attachmentData);
                } else {
                    String entryName;
                    if ("1.1".equals(attachment.version)) {
                        String diagramNameTruncated = AttachmentHelper.getValidFileName(macroContext.diagramName);
                        entryName = diagramNameTruncated + ".svg";
                    } else {
                        entryName = "diagram.svg";
                    }
                    diagramUrl = AttachmentHelper.getPngDataUri(attachmentData, entryName, imageWidth, imageHeight);
                }
            }
        }
        templateContext.put("diagramUrl", diagramUrl);
    }

    private Properties getMacroProperties(AttachmentDescriptor attachment) throws IOException {
        byte[] entry = AttachmentHelper.getEntry("META-INF/macro.properties", this.attachmentManager.getAttachmentData(attachment.attachment));
        Properties macroProperties = new Properties();
        macroProperties.load(new ByteArrayInputStream(entry));
        return macroProperties;
    }

    private String getMacroVersion(AttachmentDescriptor attachment) throws IOException {
        byte[] entry = AttachmentHelper.getEntry("META-INF/version.properties", this.attachmentManager.getAttachmentData(attachment.attachment));
        Properties versionProperties = new Properties();
        versionProperties.load(new ByteArrayInputStream(entry));
        return versionProperties.getProperty("version");
    }

    private Attachment getAttachment(ContentEntityObject entity, String attachmentName, int attachmentVersion) {
        if (attachmentVersion < 0) {
            return this.attachmentManager.getAttachment(entity, attachmentName);
        }
        if (attachmentVersion > 0) {
            Attachment attachment = this.attachmentManager.getAttachment(entity, attachmentName, attachmentVersion);
            if (attachment != null) {
                return attachment;
            }
            return this.attachmentManager.getAttachment(entity, attachmentName);
        }
        return null;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private MacroContext createMacroContext(Map<String, String> params, ConversionContext conversionContext) {
        return new MacroContext(params, conversionContext, this.settingsManager);
    }

    private static class MacroContext {
        final String diagramId;
        final String diagramName;
        final String outputType;
        final PageContext pageContext;
        final String pageId;
        final String pageUrl;
        final ContentEntityObject entity;
        final String confluenceRoot;
        final String baseUrl;
        final boolean displayName;
        final String align;
        final boolean floats;
        final String width;
        final String height;
        final boolean mobile;
        final boolean interactive;
        final boolean links;
        final boolean linksInNewWindow;
        final boolean tooltips;
        final boolean toolbar;
        final String imageAlt;
        final int attachmentVersion;
        final String confluenceMacroId;

        public MacroContext(Map<String, String> params, ConversionContext conversionContext, SettingsManager settingsManager) {
            this.diagramId = params.getOrDefault("diagramId", "");
            this.diagramName = params.get(GraphityMacro.KEY_NAME);
            this.outputType = conversionContext.getOutputType();
            this.pageContext = conversionContext.getPageContext();
            Versioned latestVersion = this.pageContext.getEntity().getLatestVersion();
            this.entity = latestVersion instanceof ContentEntityObject ? (ContentEntityObject)latestVersion : this.pageContext.getEntity();
            this.pageId = this.entity.getIdAsString();
            this.pageUrl = this.entity.getUrlPath();
            this.confluenceRoot = this.pageContext.getSiteRoot();
            this.baseUrl = settingsManager.getGlobalSettings().getBaseUrl();
            this.displayName = !"false".equals(params.get("displayName"));
            this.align = params.get("align");
            this.floats = "true".equals(params.get("float"));
            this.width = params.get("width");
            this.height = params.get("height");
            this.mobile = "mobile".equals(conversionContext.getOutputDeviceType());
            this.interactive = !"image".equals(params.get("display-format"));
            this.links = !"false".equals(params.get("links"));
            this.linksInNewWindow = !"false".equals(params.get("linksInNewWindow"));
            this.tooltips = !"false".equals(params.get("tooltips"));
            this.toolbar = !"false".equals(params.get("toolbar"));
            this.imageAlt = params.get("alt");
            this.attachmentVersion = params.get("version") != null ? Integer.parseInt(params.get("version")) : -1;
            MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
            Optional macroIdentifier = macroDefinition.getMacroIdentifier();
            this.confluenceMacroId = macroIdentifier.isPresent() ? ((MacroId)macroIdentifier.get()).getId() : "";
        }

        public String generateMacroId() {
            return this.pageContext.getElementIdCreator().generateId();
        }
    }

    private class AttachmentDescriptor {
        Attachment attachment;
        String version;

        public AttachmentDescriptor(Attachment attachment, String version) {
            this.attachment = attachment;
            this.version = version;
        }
    }
}

