/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.yworks.plugins.confluence.helper.LicenseHelper;
import com.yworks.plugins.confluence.helper.PalettesManager;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GlobalPalettesServlet
extends HttpServlet {
    private static final String ADD_GLOBAL_PALETTE = "add-global-palette";
    private static final String REMOVE_GLOBAL_PALETTE = "remove-global-palette";
    private static final String GET_GLOBAL_PALETTE = "get-global-palette";
    private static final String GET_GLOBAL_PALETTES = "get-global-palette-names";
    private static final String GET_CREATE_PERMISSION = "get-create-permission";
    private static final String GET_BUILT_IN_PALETTES = "get-built-in-palettes";
    private final BandanaManager bandanaManager;
    private final PalettesManager palettesManager;
    private final PluginLicenseManager pluginLicenseManager;

    public GlobalPalettesServlet(@ComponentImport BandanaManager bandanaManager, @ComponentImport PermissionManager permissionManager, @ComponentImport PluginLicenseManager pluginLicenseManager) {
        this.bandanaManager = bandanaManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.palettesManager = new PalettesManager(bandanaManager, permissionManager);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LicenseHelper licenseHelper = new LicenseHelper(this.pluginLicenseManager);
        if (!licenseHelper.isValidLicense()) {
            this.sendError(resp, "License Error: " + licenseHelper.getErrorString());
            return;
        }
        String idParam = req.getParameter("id");
        String nameParam = req.getParameter("name");
        String graphmlParam = req.getParameter("graphml");
        String actionParam = req.getParameter("action");
        if (this.bandanaManager == null) {
            this.sendError(resp, "Failed to persist global palettes.");
            return;
        }
        if (ADD_GLOBAL_PALETTE.equals(actionParam)) {
            try {
                HashMap<String, String> palette = this.palettesManager.addGlobalPalette(idParam, nameParam, graphmlParam);
                this.sendSuccess(resp, "{\"id\": \"" + idParam + "\", \"name\": \"" + palette.get("name") + "\", \"graphml\": \"" + palette.get("graphml") + "\", \"canEdit\": \"true\", \"owner\": \"" + palette.get("ownerName") + "\"}");
            }
            catch (Exception exception) {
                this.sendError(resp, exception.getMessage());
            }
        } else if (REMOVE_GLOBAL_PALETTE.equals(actionParam)) {
            try {
                this.palettesManager.removeGlobalPalette(idParam);
            }
            catch (Exception exception) {
                this.sendError(resp, exception.getMessage());
            }
        } else if (GET_GLOBAL_PALETTE.equals(actionParam)) {
            HashMap<String, String> properties = this.palettesManager.getGlobalPalette(idParam);
            String palette = properties.get("graphml");
            String paletteName = properties.get("name");
            String canEdit = this.palettesManager.canEditGlobalPalette(idParam) ? "true" : "false";
            String owner = properties.get("ownerName");
            this.sendSuccess(resp, "{\"id\": \"" + idParam + "\", \"name\": \"" + paletteName + "\", \"graphml\": \"" + palette + "\", \"canEdit\": \"" + canEdit + "\", \"owner\": \"" + owner + "\"}");
        } else if (GET_GLOBAL_PALETTES.equals(actionParam)) {
            List<HashMap<String, String>> globalPalettes = this.palettesManager.getGlobalPalettes();
            StringBuilder palettes = new StringBuilder();
            palettes.append("[");
            for (int i = 0; i < globalPalettes.size(); ++i) {
                HashMap<String, String> palette = globalPalettes.get(i);
                String id = palette.get("id");
                String paletteName = palette.get("name");
                String canEdit = this.palettesManager.canEditGlobalPalette(id) ? "true" : "false";
                String owner = palette.get("ownerName");
                if (i > 0) {
                    palettes.append(", ");
                }
                palettes.append("{\"id\": \"").append(id).append("\", \"name\": \"").append(paletteName).append("\", \"canEdit\": \"").append(canEdit).append("\", \"owner\": \"").append(owner).append("\"}");
            }
            palettes.append("]");
            this.sendSuccess(resp, palettes.toString());
        } else if (GET_CREATE_PERMISSION.equals(actionParam)) {
            String hasCreatePermission = this.palettesManager.canManageGlobalPalettes() ? "true" : "false";
            this.sendSuccess(resp, "{\"createGlobalPalettePermission\":\"" + hasCreatePermission + "\"}");
        } else if (GET_BUILT_IN_PALETTES.equals(actionParam)) {
            HashMap<String, String> palettesSettings = this.palettesManager.getBuiltInPalettesSettings();
            Enumeration<String> names = Collections.enumeration(palettesSettings.keySet());
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                builder.append("\"").append(name).append("\": \"").append(palettesSettings.get(name)).append("\"");
                if (!names.hasMoreElements()) continue;
                builder.append(", ");
            }
            builder.append("}");
            this.sendSuccess(resp, builder.toString());
        } else {
            this.sendError(resp, "GlobalPalettesServlet: Invalid Request");
        }
    }

    private void sendSuccess(HttpServletResponse response, String data) throws IOException {
        this.sendResponse(response, "success", null, data);
    }

    private void sendError(HttpServletResponse response, String cause) throws IOException {
        this.sendResponse(response, "error", cause, null);
    }

    private void sendResponse(HttpServletResponse resp, String result, String cause, String data) throws IOException {
        ServletOutputStream outputStream = resp.getOutputStream();
        StringBuilder builder = new StringBuilder();
        builder.append("{\"result\": \"").append(result).append("\"");
        if (cause != null) {
            builder.append(", \"cause\": \"").append(cause).append("\"");
        }
        if (data != null) {
            builder.append(", \"data\": ").append(data);
        }
        builder.append("}");
        outputStream.print(builder.toString());
        outputStream.flush();
        outputStream.close();
    }
}

