/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.plugins.confluence;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.User;
import com.yworks.plugins.confluence.helper.AttachmentHelper;
import com.yworks.plugins.confluence.helper.LicenseHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DiagramDataServlet
extends HttpServlet {
    private final AttachmentManager attachmentManager;
    private final PageManager pageManager;
    private final PluginLicenseManager pluginLicenseManager;
    private final PermissionManager permissionManager;
    static final String INSUFFICIENT_PERMISSIONS_TO_VIEW_ATTACHMENT = "Insufficient permissions to view attachment";

    public DiagramDataServlet(@ComponentImport AttachmentManager attachmentManager, @ComponentImport PageManager pageManager, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PermissionManager permissionManager) {
        this.attachmentManager = attachmentManager;
        this.pageManager = pageManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.permissionManager = permissionManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean hasId;
        LicenseHelper licenseHelper = new LicenseHelper(this.pluginLicenseManager);
        boolean isValidLicense = licenseHelper.isValidLicense();
        String name = AttachmentHelper.getValidFileName(req.getParameter("name"));
        String diagramId = req.getParameter("diagramId");
        String pageId = req.getParameter("pageId");
        String entryType = req.getParameter("entryType");
        String entryName = req.getParameter("entryName");
        boolean bl = hasId = diagramId != null && !diagramId.isEmpty();
        if (entryName == null || entryName.isEmpty()) {
            entryName = (hasId ? "diagram" : name) + "." + entryType;
        }
        Page page = this.pageManager.getPage(Long.parseLong(pageId));
        resp.setContentType("text/plain");
        try (ServletOutputStream respOutputStream = resp.getOutputStream();){
            if (!isValidLicense) {
                AttachmentHelper.write(new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8)), (OutputStream)respOutputStream);
            } else {
                String attachmentVersionParam = req.getParameter("version");
                int attachmentVersion = attachmentVersionParam != null ? Integer.parseInt(attachmentVersionParam) : -1;
                Attachment attachment = this.getAttachment((ContentEntityObject)page, (hasId ? diagramId : name) + ".zip", attachmentVersion);
                if (attachment != null) {
                    if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)attachment)) {
                        AttachmentHelper.write(new ByteArrayInputStream(INSUFFICIENT_PERMISSIONS_TO_VIEW_ATTACHMENT.getBytes(StandardCharsets.UTF_8)), (OutputStream)respOutputStream);
                        respOutputStream.close();
                        return;
                    }
                    byte[] data = AttachmentHelper.getEntry(entryName, this.attachmentManager.getAttachmentData(attachment));
                    if (data.length > 0) {
                        resp.setContentType(DiagramDataServlet.getContentType(entryName));
                        AttachmentHelper.write(new ByteArrayInputStream(data), (OutputStream)respOutputStream);
                    } else {
                        AttachmentHelper.write(new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8)), (OutputStream)respOutputStream);
                    }
                } else {
                    attachment = this.getAttachment((ContentEntityObject)page, entryName, attachmentVersion);
                    if (attachment != null) {
                        if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)attachment)) {
                            AttachmentHelper.write(new ByteArrayInputStream(INSUFFICIENT_PERMISSIONS_TO_VIEW_ATTACHMENT.getBytes(StandardCharsets.UTF_8)), (OutputStream)respOutputStream);
                            respOutputStream.close();
                            return;
                        }
                        resp.setContentType(DiagramDataServlet.getContentType(entryName));
                        AttachmentHelper.write(this.attachmentManager.getAttachmentData(attachment), (OutputStream)respOutputStream);
                    }
                }
            }
        }
    }

    private Attachment getAttachment(ContentEntityObject entity, String attachmentName, int attachmentVersion) {
        if (attachmentVersion < 0) {
            return this.attachmentManager.getAttachment(entity, attachmentName);
        }
        if (attachmentVersion > 0) {
            return this.attachmentManager.getAttachment(entity, attachmentName, attachmentVersion);
        }
        return null;
    }

    private static String getContentType(String fileName) {
        String fileExtension;
        switch (fileExtension = fileName.substring(fileName.lastIndexOf("."))) {
            case ".svg": {
                return "image/svg+xml";
            }
            case ".png": {
                return "image/png";
            }
            case ".graphml": {
                return "application/xml";
            }
            case ".json": {
                return "application/json";
            }
        }
        return "text/plain";
    }
}

