/*
 * Decompiled with CFR 0.152.
 */
package com.xalt.confluence.adminui;

import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@Path(value="/")
public class ConfigResource {
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PluginSettingsFactory pluginSettingsFactory;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final PluginController pluginController;
    private final String groupIdPluginKey = "com.xalt.confluence.confluence-status-macro";
    private final String todo = "todo-macro";
    private final String inprogress = "inprogress-macro";
    private final String done = "done-macro";
    private final String[] moduleSet0 = new String[]{"todo-macro", "inprogress-macro", "done-macro"};
    private final String minor = "minor-macro";
    private final String major = "major-macro";
    private final String critical = "critical-macro";
    private final String[] moduleSet1 = new String[]{"minor-macro", "major-macro", "critical-macro"};
    private final String low = "low-macro";
    private final String medium = "medium-macro";
    private final String high = "high-macro";
    private final String[] moduleSet2 = new String[]{"low-macro", "medium-macro", "high-macro"};
    private final String newMacro = "new-macro";
    private final String ready = "ready-macro";
    private final String review = "review-macro";
    private final String[] moduleSet3 = new String[]{"new-macro", "ready-macro", "review-macro"};

    @Inject
    public ConfigResource(UserManager userManager, PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate, PluginController pluginController) {
        this.userManager = userManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.transactionTemplate = transactionTemplate;
        this.pluginController = pluginController;
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@Context HttpServletRequest request) {
        String username = this.userManager.getRemoteUsername(request);
        if (username == null || !this.userManager.isSystemAdmin(username)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok((Object)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                PluginSettings settings = ConfigResource.this.pluginSettingsFactory.createGlobalSettings();
                Config config = new Config();
                config.setStatusSet0(ConfigResource.this.getConfigSetting(settings, "statusSet0"));
                config.setStatusSet1(ConfigResource.this.getConfigSetting(settings, "statusSet1"));
                config.setStatusSet2(ConfigResource.this.getConfigSetting(settings, "statusSet2"));
                config.setStatusSet3(ConfigResource.this.getConfigSetting(settings, "statusSet3"));
                return config;
            }
        })).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response put(final Config config, @Context HttpServletRequest request) {
        String username = this.userManager.getRemoteUsername(request);
        if (username == null || !this.userManager.isSystemAdmin(username)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                PluginSettings pluginSettings = ConfigResource.this.pluginSettingsFactory.createGlobalSettings();
                if (config.getStatusSet0() != null) {
                    if (config.getStatusSet0().equals("enabled")) {
                        ConfigResource.this.enableModuleSet("statusSet0");
                    } else {
                        ConfigResource.this.disableModuleSet("statusSet0");
                    }
                    pluginSettings.put(Config.class.getName() + ".statusSet0", (Object)config.getStatusSet0());
                } else if (config.getStatusSet1() != null) {
                    if (config.getStatusSet1().equals("enabled")) {
                        ConfigResource.this.enableModuleSet("statusSet1");
                    } else {
                        ConfigResource.this.disableModuleSet("statusSet1");
                    }
                    pluginSettings.put(Config.class.getName() + ".statusSet1", (Object)config.getStatusSet1());
                } else if (config.getStatusSet2() != null) {
                    if (config.getStatusSet2().equals("enabled")) {
                        ConfigResource.this.enableModuleSet("statusSet2");
                    } else {
                        ConfigResource.this.disableModuleSet("statusSet2");
                    }
                    pluginSettings.put(Config.class.getName() + ".statusSet2", (Object)config.getStatusSet2());
                } else if (config.getStatusSet3() != null) {
                    if (config.getStatusSet3().equals("enabled")) {
                        ConfigResource.this.enableModuleSet("statusSet3");
                    } else {
                        ConfigResource.this.disableModuleSet("statusSet3");
                    }
                    pluginSettings.put(Config.class.getName() + ".statusSet3", (Object)config.getStatusSet3());
                }
                return null;
            }
        });
        return Response.noContent().build();
    }

    private Config initialConfig(Config config) {
        config.setStatusSet0("enabled");
        config.setStatusSet1("disabled");
        config.setStatusSet2("disabled");
        config.setStatusSet3("disabled");
        return config;
    }

    private void enableModuleSet(String statusSet) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (!statusSet.equals("statusSet0")) break block4;
                        for (String moduleKey : this.moduleSet0) {
                            this.pluginController.enablePluginModule("com.xalt.confluence.confluence-status-macro:" + moduleKey);
                        }
                        break block5;
                    }
                    if (!statusSet.equals("statusSet1")) break block6;
                    for (String moduleKey : this.moduleSet1) {
                        this.pluginController.enablePluginModule("com.xalt.confluence.confluence-status-macro:" + moduleKey);
                    }
                    break block5;
                }
                if (!statusSet.equals("statusSet2")) break block7;
                for (String moduleKey : this.moduleSet2) {
                    this.pluginController.enablePluginModule("com.xalt.confluence.confluence-status-macro:" + moduleKey);
                }
                break block5;
            }
            if (!statusSet.equals("statusSet3")) break block5;
            for (String moduleKey : this.moduleSet3) {
                this.pluginController.enablePluginModule("com.xalt.confluence.confluence-status-macro:" + moduleKey);
            }
        }
    }

    private void disableModuleSet(String statusSet) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (!statusSet.equals("statusSet0")) break block4;
                        for (String moduleKey : this.moduleSet0) {
                            this.pluginController.disablePluginModule("com.xalt.confluence.confluence-status-macro:" + moduleKey);
                        }
                        break block5;
                    }
                    if (!statusSet.equals("statusSet1")) break block6;
                    for (String moduleKey : this.moduleSet1) {
                        this.pluginController.disablePluginModule("com.xalt.confluence.confluence-status-macro:" + moduleKey);
                    }
                    break block5;
                }
                if (!statusSet.equals("statusSet2")) break block7;
                for (String moduleKey : this.moduleSet2) {
                    this.pluginController.disablePluginModule("com.xalt.confluence.confluence-status-macro:" + moduleKey);
                }
                break block5;
            }
            if (!statusSet.equals("statusSet3")) break block5;
            for (String moduleKey : this.moduleSet3) {
                this.pluginController.disablePluginModule("com.xalt.confluence.confluence-status-macro:" + moduleKey);
            }
        }
    }

    private String getConfigSetting(PluginSettings settings, String configSet) {
        String setting = (String)settings.get(Config.class.getName() + "." + configSet);
        if (StringUtils.isEmpty((CharSequence)setting)) {
            if ("statusSet0".equals(configSet)) {
                return "enabled";
            }
            return "disabled";
        }
        return setting;
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class Config {
        @XmlElement
        private String statusSet0;
        @XmlElement
        private String statusSet1;
        @XmlElement
        private String statusSet2;
        @XmlElement
        private String statusSet3;

        public String getStatusSet0() {
            return this.statusSet0;
        }

        public void setStatusSet0(String statusSet0) {
            this.statusSet0 = statusSet0;
        }

        public String getStatusSet1() {
            return this.statusSet1;
        }

        public void setStatusSet1(String statusSet1) {
            this.statusSet1 = statusSet1;
        }

        public String getStatusSet2() {
            return this.statusSet2;
        }

        public void setStatusSet2(String statusSet2) {
            this.statusSet2 = statusSet2;
        }

        public String getStatusSet3() {
            return this.statusSet3;
        }

        public void setStatusSet3(String statusSet3) {
            this.statusSet3 = statusSet3;
        }
    }
}

