/**
 * author: mark dl
 * admin.js handles js from admin.vm
 */
(function ($) {
    // this closure helps us keep our variables to ourselves.
    // This pattern is known as an "iife" - immediately invoked function expression

    var url = AJS.contextPath() + "/rest/xalt-status-macro-admin/1.0/";

    $(document).ready(function() {
        $.ajax({
            url: url,
            dataType: "json"
        }).done(function(config) {
            // ...populate the form.
            populateForm(config);
        });

        //will store the button element that was clicked. to be sent to updateConfig.
        var buttonPressed;
        $('.status-button').click(function(){
           buttonPressed = $(this);
        });

        //form submit
        AJS.$("#admin").submit(function(e) {
            e.preventDefault();
            updateConfig(buttonPressed);
        });
    });

})(AJS.$ || jQuery);

/**
 * populates the form from the config settings requested
 * adds style to buttons
 * @param config
 */
function populateForm(config){
    //set 0
    if(config.statusSet0 === 'disabled') {
        $("#statusSet0").val('Enable');
        $("#statusSet0").addClass('aui-button-primary');
    }
    else if(config.statusSet0 === 'enabled') {
        $("#statusSet0").val('Disable');
    }
    $("#statusSet0Text").text(config.statusSet0);

    //set 1
    if(config.statusSet1 === 'disabled') {
        $("#statusSet1").val('Enable');
        $("#statusSet1").addClass('aui-button-primary');
    }
    else if(config.statusSet1 === 'enabled') {
        $("#statusSet1").val('Disable');
    }
    $("#statusSet1Text").text(config.statusSet1);

    //set 2
    if(config.statusSet2 === 'disabled') {
        $("#statusSet2").val('Enable');
        $("#statusSet2").addClass('aui-button-primary');
    }
    else if(config.statusSet2 === 'enabled') {
        $("#statusSet2").val('Disable');
    }
    $("#statusSet2Text").text(config.statusSet2);

    //set 3
    if(config.statusSet3 === 'disabled') {
        $("#statusSet3").val('Enable');
        $("#statusSet3").addClass('aui-button-primary');
    }
    else if(config.statusSet3 === 'enabled') {
        $("#statusSet3").val('Disable');
    }
    $("#statusSet3Text").text(config.statusSet3);
}

/**
 * Does the PUT request and
 * Updates the button and text
 * @param buttonPressed
 */
function updateConfig(buttonPressed) {

    var statusSetId = buttonPressed.attr('id');
    var statusSetValue = buttonPressed.attr('value');

    var value;
    if(statusSetValue === 'Enable'){
        value = 'enabled';
        $("#"+statusSetId+"Text").text(value);
        $("#"+statusSetId).val('Disable');
        $("#"+statusSetId).removeClass('aui-button-primary');
    }
    else if(statusSetValue === 'Disable'){
        value = 'disabled';
        $("#"+statusSetId+"Text").text(value);
        $("#"+statusSetId).val('Enable');
        $("#"+statusSetId).addClass('aui-button-primary');
    }

    //TODO add wait time or loading... or disable pressing button again for a while.
    AJS.$.ajax({
        url: AJS.contextPath() + "/rest/xalt-status-macro-admin/1.0/",
        type: "PUT",
        contentType: "application/json",
        data: '{ "'+statusSetId+'": "' + value + '" }',
        processData: false,
        success: function() {
            console.log('{ "'+statusSetId+'": "' + value + '" }');
        }
    });

}