/*
 * Decompiled with CFR 0.152.
 */
package com.wombatscorp.confluence.tokens.servlet;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.wombatscorp.confluence.tokens.security.LicenseManager;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AdminServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AdminServlet.class);
    private static final String VELOCITY_TEMPLATE = "view/adminPage.vm";
    @ComponentImport
    private final TemplateRenderer templateRenderer;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final SettingsManager settingsManager;
    private final LicenseManager licenseManager;

    @Inject
    public AdminServlet(TemplateRenderer templateRenderer, SettingsManager settingsManager, PermissionManager permissionManager, LicenseManager licenseManager) {
        log.debug("Start of AdminServlet");
        this.permissionManager = permissionManager;
        this.licenseManager = licenseManager;
        this.templateRenderer = templateRenderer;
        this.settingsManager = settingsManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        log.info("AdminServlet doGet method");
        if (!this.isAdmin()) {
            try {
                resp.sendError(403, "Not enough permission");
            }
            catch (IOException e) {
                log.error("Unknown error occurred while sending 403 HTTP Status Code", (Throwable)e);
            }
            return;
        }
        Boolean isLicenseValid = this.licenseManager.isValid();
        resp.setContentType("text/html;charset=utf-8");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("license", isLicenseValid);
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        context.put("baseUrl", baseUrl);
        try {
            this.templateRenderer.render(VELOCITY_TEMPLATE, context, (Writer)resp.getWriter());
        }
        catch (RenderingException | IOException e) {
            log.error("Unexpected error occurred while rendering template", e);
        }
    }

    private boolean isAdmin() {
        return this.permissionManager.isConfluenceAdministrator(AuthenticatedUserThreadLocal.getUser());
    }
}

