/*
 * Decompiled with CFR 0.152.
 */
package com.wombatscorp.confluence.tokens.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.wombatscorp.confluence.tokens.dto.LabelPassPair;
import com.wombatscorp.confluence.tokens.dto.TokenBean;
import com.wombatscorp.confluence.tokens.persistance.Token;
import com.wombatscorp.confluence.tokens.persistance.TokenDAO;
import com.wombatscorp.confluence.tokens.security.LicenseManager;
import com.wombatscorp.confluence.tokens.security.TokensEncryption;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class REST {
    private static final Logger log = LoggerFactory.getLogger(REST.class);
    private final TokenDAO tokenDAO;
    private final LicenseManager licenseManager;
    @ComponentImport
    private final PluginSettingsFactory pluginSettingsFactory;

    @Inject
    public REST(TokenDAO tokenDAO, LicenseManager licenseManager, PluginSettingsFactory pluginSettingsFactory) {
        this.licenseManager = licenseManager;
        if (log.isDebugEnabled()) {
            log.debug("-------------< REST init >----------------");
        }
        this.tokenDAO = tokenDAO;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getTokens() {
        if (log.isDebugEnabled()) {
            log.debug("GET: /rest/api-tokens/latest/");
        }
        Token[] tokens = this.tokenDAO.getUserTokens(AuthenticatedUserThreadLocal.getUsername());
        ArrayList<TokenBean> beans = new ArrayList<TokenBean>();
        for (Token t : tokens) {
            beans.add(new TokenBean(t));
        }
        return Response.ok(beans).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createToken(LabelPassPair labelPassword) {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        Object enableCreation = settings.get("com.wombatscorp.jira.tokens.enabletokencreation");
        if (enableCreation != null && !Boolean.parseBoolean(enableCreation.toString())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Token creation is disable by administrator").build();
        }
        Token[] tokens = this.tokenDAO.getUserTokens(AuthenticatedUserThreadLocal.getUsername());
        Object maxTokensPerUser = settings.get("com.wombatscorp.jira.tokens.maxtokenperuser");
        if (maxTokensPerUser != null && Integer.parseInt(maxTokensPerUser.toString()) != 0 && tokens.length >= Integer.parseInt(maxTokensPerUser.toString())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Exceeded maximum amount of token. Please contact your administrator").build();
        }
        Object maxExpiration = settings.get("com.wombatscorp.jira.tokens.maxexpiration");
        Object enableUnlimitedExpiration = settings.get("com.wombatscorp.jira.tokens.enableunlimitedtokens");
        if (this.isUnlimitedExpirationDisabled(enableUnlimitedExpiration)) {
            if (labelPassword.getExpiration() == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Expiration cannot be null").build();
            }
            if (maxExpiration != null && this.isLimitExceeded(labelPassword.getExpiration(), maxExpiration)) {
                labelPassword.setExpiration(Integer.parseInt(maxExpiration.toString()));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("POST: /rest/api-tokens/latest/ label:{}", (Object)labelPassword.getLabel());
        }
        labelPassword.setPasswordValue(TokensEncryption.generateToken());
        Token t = this.tokenDAO.createToken(labelPassword.getLabel().trim(), AuthenticatedUserThreadLocal.getUsername(), labelPassword.getPasswordValue(), this.integerToDate(labelPassword.getExpiration()));
        if (log.isDebugEnabled()) {
            log.debug("created: {}({})", (Object)t.getDescription(), (Object)t.getKey());
        }
        labelPassword.setLabel(null);
        return Response.ok((Object)labelPassword).build();
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response deleteToken(@PathParam(value="id") String key) {
        log.debug("DELETE: /rest/api-tokens/latest/{}", (Object)key);
        boolean status = this.tokenDAO.deleteTokenByKey(key, AuthenticatedUserThreadLocal.getUsername());
        if (status) {
            if (log.isDebugEnabled()) {
                log.debug("deleted: {}", (Object)key);
            }
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        if (log.isDebugEnabled()) {
            log.debug("not found: {}", (Object)key);
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @DELETE
    @Path(value="all")
    @Produces(value={"application/json"})
    public Response deleteAllToken() {
        Token[] tokens;
        if (log.isDebugEnabled()) {
            log.debug("DELETE: /rest/api-tokens/latest/all");
        }
        for (Token t : tokens = this.tokenDAO.getUserTokens(AuthenticatedUserThreadLocal.getUsername())) {
            this.tokenDAO.deleteToken(t);
            if (!log.isDebugEnabled()) continue;
            log.debug("deleted: {}({})", (Object)t.getDescription(), (Object)t.getKey());
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="license")
    @Produces(value={"application/json"})
    public Response getLicenseStatus() {
        return Response.ok((Object)this.licenseManager.isValid()).build();
    }

    @GET
    @Path(value="server-time")
    @Produces(value={"application/json"})
    public Response getServerTime() {
        return Response.ok((Object)new Date()).build();
    }

    public Date integerToDate(Integer expirationDays) {
        if (expirationDays == null) {
            log.debug("empty expiration date");
            return null;
        }
        if (expirationDays < 1 || expirationDays > 10000) {
            log.warn("expiration date could not be less then 1 or more then 10000");
            return null;
        }
        GregorianCalendar result = new GregorianCalendar();
        ((Calendar)result).add(5, expirationDays);
        return result.getTime();
    }

    private boolean isUnlimitedExpirationDisabled(Object enableUnlimitedExpiration) {
        return enableUnlimitedExpiration != null && !Boolean.parseBoolean(enableUnlimitedExpiration.toString());
    }

    private boolean isLimitExceeded(int currentExpiration, Object maxExpiration) {
        try {
            int maxExp = Integer.parseInt(maxExpiration.toString());
            return currentExpiration > maxExp;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

