/*
 * Decompiled with CFR 0.152.
 */
package com.wombatscorp.confluence.tokens.rest;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.wombatscorp.confluence.tokens.dto.Config;
import com.wombatscorp.confluence.tokens.filters.TokenFilter;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/config")
public class ConfigREST {
    @ComponentImport
    private final PluginSettingsFactory pluginSettingsFactory;
    @ComponentImport
    private final PermissionManager permissionManager;
    private static final Integer DEFAULT_EXPIRATION = 0;
    private static final Integer MAX_TOKENS_EXPIRATION = 3000;
    private static final Integer MAX_TOKENS_PER_USER = 100;

    @Inject
    public ConfigREST(PluginSettingsFactory pluginSettingsFactory, PermissionManager permissionManager) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.permissionManager = permissionManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getConfig() {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        boolean enableToken = Boolean.parseBoolean(Optional.ofNullable(pluginSettings.get("com.wombatscorp.jira.tokens.enablepasswordauth")).orElse(false).toString());
        boolean enableCreation = Boolean.parseBoolean(Optional.ofNullable(pluginSettings.get("com.wombatscorp.jira.tokens.enabletokencreation")).orElse(true).toString());
        boolean enableUnlimitedExpiration = Boolean.parseBoolean(Optional.ofNullable(pluginSettings.get("com.wombatscorp.jira.tokens.enableunlimitedtokens")).orElse(true).toString());
        int defaultExpiration = Integer.parseInt(Optional.ofNullable(pluginSettings.get("com.wombatscorp.jira.tokens.defaultexpiration")).orElse(DEFAULT_EXPIRATION).toString());
        int maxExpiration = Integer.parseInt(Optional.ofNullable(pluginSettings.get("com.wombatscorp.jira.tokens.maxexpiration")).orElse(MAX_TOKENS_EXPIRATION).toString());
        int maxTokensPerUser = Integer.parseInt(Optional.ofNullable(pluginSettings.get("com.wombatscorp.jira.tokens.maxtokenperuser")).orElse(MAX_TOKENS_PER_USER).toString());
        Config response = new Config();
        response.setOnlyTokensAllowed(enableToken);
        response.setCreationAllowed(enableCreation);
        response.setUnlimitedExpiration(enableUnlimitedExpiration);
        response.setRecommendedExpiration(defaultExpiration);
        response.setMaxExpiration(maxExpiration);
        response.setMaxTokensPerUser(maxTokensPerUser);
        return Response.ok().entity((Object)response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response setConfig(Config config) {
        if (!this.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (config.getMaxExpiration() > MAX_TOKENS_EXPIRATION) {
            config.setMaxExpiration(MAX_TOKENS_EXPIRATION);
        }
        if (config.getMaxTokensPerUser() > MAX_TOKENS_PER_USER) {
            config.setMaxTokensPerUser(MAX_TOKENS_PER_USER);
        }
        if (config.getRecommendedExpiration() > config.getMaxExpiration()) {
            config.setRecommendedExpiration(config.getMaxExpiration());
        }
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put("com.wombatscorp.jira.tokens.enablepasswordauth", (Object)config.isOnlyTokensAllowed().toString());
        TokenFilter.setIsPassAuthKeyEnabled(config.isOnlyTokensAllowed());
        pluginSettings.put("com.wombatscorp.jira.tokens.enabletokencreation", (Object)config.isCreationAllowed().toString());
        pluginSettings.put("com.wombatscorp.jira.tokens.enableunlimitedtokens", (Object)config.isUnlimitedExpiration().toString());
        pluginSettings.put("com.wombatscorp.jira.tokens.defaultexpiration", (Object)config.getRecommendedExpiration().toString());
        pluginSettings.put("com.wombatscorp.jira.tokens.maxexpiration", (Object)config.getMaxExpiration().toString());
        pluginSettings.put("com.wombatscorp.jira.tokens.maxtokenperuser", (Object)config.getMaxTokensPerUser().toString());
        return Response.ok().entity((Object)config).build();
    }

    private boolean isAdmin() {
        return this.permissionManager.isConfluenceAdministrator(AuthenticatedUserThreadLocal.getUser());
    }
}

