/*
 * Decompiled with CFR 0.152.
 */
package com.wombatscorp.confluence.tokens.rest;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.wombatscorp.confluence.tokens.dto.TokenResponse;
import com.wombatscorp.confluence.tokens.persistance.Token;
import com.wombatscorp.confluence.tokens.persistance.TokenDAO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin")
public class AdminREST {
    private static final Logger log = LoggerFactory.getLogger(AdminREST.class);
    private final TokenDAO tokenDAO;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final UserAccessor userAccessor;

    @Inject
    public AdminREST(TokenDAO tokenDAO, PermissionManager permissionManager, UserAccessor userAccessor) {
        this.tokenDAO = tokenDAO;
        this.permissionManager = permissionManager;
        this.userAccessor = userAccessor;
    }

    @GET
    @Path(value="/all")
    @Produces(value={"application/json"})
    public Response getTokens() {
        if (log.isDebugEnabled()) {
            log.debug("GET: /rest/api-tokens/latest/admin/all");
        }
        if (!this.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Token[] allTokens = this.tokenDAO.getAllTokens();
        ArrayList<TokenResponse> response = new ArrayList<TokenResponse>();
        for (Token token : allTokens) {
            TokenResponse resp = this.getTokenResponse(token);
            response.add(resp);
        }
        return Response.ok().entity(response).build();
    }

    @POST
    @Path(value="/bulk")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteTokens(List<String> tokens) {
        if (!this.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        tokens.forEach(this.tokenDAO::deleteTokenByKey);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private boolean isAdmin() {
        return this.permissionManager.isConfluenceAdministrator(AuthenticatedUserThreadLocal.getUser());
    }

    private TokenResponse getTokenResponse(Token token) {
        Date currentDate = new Date();
        ConfluenceUser user = this.userAccessor.getUserByName(token.getUsername());
        boolean isUserActive = user != null && !this.userAccessor.isDeactivated((User)user);
        boolean isTokenActive = token.getExpirationDate() == null || currentDate.before(token.getExpirationDate());
        return new TokenResponse(token.getUsername(), isUserActive, isTokenActive, token.getID(), token.getKey(), token.getDescription(), token.getUsageCount(), token.getCreated(), token.getLastUsage(), token.getExpirationDate());
    }
}

