/*
 * Decompiled with CFR 0.152.
 */
package com.wombatscorp.confluence.tokens.dto;

import com.wombatscorp.confluence.tokens.persistance.Token;
import java.util.Date;
import java.util.Optional;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;

@XmlRootElement
public class TokenBean {
    @XmlElement(required=true, nillable=true)
    public String label;
    @XmlSchemaType(name="date")
    @XmlElement(required=true, nillable=true)
    public Date createdAt;
    @XmlSchemaType(name="date")
    @XmlElement(required=true, nillable=true)
    Date lastAccessed;
    @XmlElement(required=true, nillable=true)
    public String id;
    @XmlElement(required=true, nillable=true)
    public Integer usageCount;
    @XmlSchemaType(name="date")
    @XmlElement(required=true, nillable=true)
    public Date expirationDate;

    private TokenBean() {
    }

    public TokenBean(Token token) {
        this.label = token.getDescription();
        this.createdAt = token.getCreated();
        this.lastAccessed = token.getLastUsage();
        this.usageCount = Optional.ofNullable(token.getUsageCount()).orElse(0);
        this.expirationDate = token.getExpirationDate();
        this.id = token.getKey();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(Date lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getUsageCount() {
        return this.usageCount;
    }

    public void setUsageCount(Integer usageCount) {
        this.usageCount = usageCount;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }
}

