/*
 * Decompiled with CFR 0.152.
 */
package com.wombatscorp.confluence.tokens.security;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.mindrot.jbcrypt.BCrypt;

public class TokensEncryption {
    public static final int TOKEN_LENGTH = 35;
    public static final String AB = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final SecureRandom rnd = new SecureRandom();

    public static String hashToken(String plainToken) {
        return BCrypt.hashpw(plainToken, BCrypt.gensalt());
    }

    public static boolean checkToken(String plainToken, String hashedToken) {
        return BCrypt.checkpw(plainToken, hashedToken);
    }

    public static String generateKeyForToken(String username) {
        StringBuilder key = new StringBuilder(username + System.nanoTime());
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            key.setLength(0);
            byte[] md5Hash = md.digest((username + System.nanoTime()).getBytes(StandardCharsets.UTF_8));
            for (int i = 0; i < 16; ++i) {
                key.append(AB.charAt(Byte.toUnsignedInt(md5Hash[i]) % AB.length()));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return "asp_" + key;
    }

    public static String generateToken() {
        StringBuilder sb = new StringBuilder(35);
        for (int i = 0; i < 35; ++i) {
            sb.append(AB.charAt(rnd.nextInt(AB.length())));
        }
        return sb.toString();
    }
}

