/*
 * Decompiled with CFR 0.152.
 */
package com.wombatscorp.confluence.tokens.persistance;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.wombatscorp.confluence.tokens.persistance.Token;
import com.wombatscorp.confluence.tokens.security.TokensEncryption;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class TokenDAO {
    private static final Logger log = LoggerFactory.getLogger(TokenDAO.class);
    @ComponentImport
    private final ActiveObjects ao;

    @Inject
    public TokenDAO(ActiveObjects ao) {
        this.ao = ao;
        log.debug("TokenManager initialized with AO {}", (Object)ao);
    }

    public Token getToken(String key) {
        Token[] tokens = (Token[])this.ao.executeInTransaction(() -> (Token[])this.ao.find(Token.class, Query.select().where("KEY = ?", new Object[]{key}).order("ID")));
        if (tokens.length > 0) {
            return tokens[0];
        }
        return null;
    }

    public Token[] getUserTokens(String username) {
        return (Token[])this.ao.executeInTransaction(() -> (Token[])this.ao.find(Token.class, Query.select().where("USERNAME = ?", new Object[]{username.toLowerCase()}).order("ID")));
    }

    public Token createToken(String description, String username, String plainToken, Date expirationDate) {
        return (Token)this.ao.executeInTransaction(() -> {
            Token token = (Token)this.ao.create(Token.class, new DBParam[0]);
            token.setDescription(description);
            token.setLastUsage(null);
            token.setUsername(username.toLowerCase());
            token.setToken(TokensEncryption.hashToken(plainToken));
            token.setCreated(new Date());
            token.setKey(TokensEncryption.generateKeyForToken(username));
            token.setUsageCount(0);
            token.setExpirationDate(expirationDate);
            token.save();
            return token;
        });
    }

    public boolean deleteTokenByKey(String key, String username) {
        return (Boolean)this.ao.executeInTransaction(() -> {
            Token token = this.getToken(key);
            if (token == null) {
                return false;
            }
            if (!token.getUsername().equalsIgnoreCase(username)) {
                return false;
            }
            this.ao.delete(new RawEntity[]{token});
            return true;
        });
    }

    public boolean deleteToken(Token token) {
        return (Boolean)this.ao.executeInTransaction(() -> {
            if (token == null) {
                return false;
            }
            this.ao.delete(new RawEntity[]{token});
            return true;
        });
    }

    public boolean deleteTokenByKey(String key) {
        return (Boolean)this.ao.executeInTransaction(() -> {
            Token token = this.getToken(key);
            if (token == null) {
                return false;
            }
            this.ao.delete(new RawEntity[]{token});
            return true;
        });
    }

    public Token checkToken(String username, String tokenCandidate) {
        List<Token> tokens = Arrays.asList(this.getUserTokens(username));
        return tokens.stream().filter(t -> TokensEncryption.checkToken(tokenCandidate, t.getToken())).findFirst().orElse(null);
    }

    public void useToken(Token token) {
        this.ao.executeInTransaction(() -> {
            token.setLastUsage(new Date());
            int currentUsageCount = Optional.ofNullable(token.getUsageCount()).orElse(0);
            token.setUsageCount(currentUsageCount + 1);
            token.save();
            return true;
        });
    }

    public Token[] getAllTokens() {
        return (Token[])this.ao.executeInTransaction(() -> (Token[])this.ao.find(Token.class, Query.select().order("USERNAME")));
    }
}

